/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import javax.vecmath.Point3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.io.nativexfer.ANativeObject;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.nativebuffered.Object3D;

public class BoundsCalculator
extends ANativeObject {
    private static final int method_getMin = 0;
    private static final int method_getMax = 1;
    private static final int method_reset = 2;
    private static final int method_addPoint3d = 3;
    private static final int method_addBoundingAABox = 4;
    private static final int method_addObject3D = 5;

    public BoundsCalculator() {
    }

    protected BoundsCalculator(Integer key, long cptr) {
        super(key, cptr);
    }

    @Override
    public Class resolveNativeClass() {
        return BoundsCalculator.class;
    }

    public Point3d getMin() {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(BoundsCalculator.class, (INativeObject)this, 0, new Object[0]);
        Native.manager.flush();
        double[] vals = Native.manager.readDoubles(3);
        Native.manager.unlockWriteBuffer();
        return new Point3d(vals[0], vals[1], vals[2]);
    }

    public Point3d getMax() {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(BoundsCalculator.class, (INativeObject)this, 1, new Object[0]);
        Native.manager.flush();
        double[] vals = Native.manager.readDoubles(3);
        Native.manager.unlockWriteBuffer();
        return new Point3d(vals[0], vals[1], vals[2]);
    }

    public AABox getBounds() {
        return new AABox(this.getMin(), this.getMax());
    }

    public String toString() {
        return this.getBounds().toString();
    }

    public void add(Point3d p) {
        Native.manager.execMethod(BoundsCalculator.class, (INativeObject)this, 3, p.x, p.y, p.z);
    }

    public void add(AABox bb) {
        Point3d min = bb.getMin();
        Point3d max = bb.getMax();
        Native.manager.execMethod(BoundsCalculator.class, (INativeObject)this, 4, min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public void add(Object3D ... objs) {
        Native.manager.execMethod(BoundsCalculator.class, (INativeObject)this, 5, objs.length, objs);
    }
}

