/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.nativebuffered.ARenderComponent;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.IRenderComponent;
import thunderheadeng.scene3d.nativebuffered.IRenderable;
import thunderheadeng.scene3d.nativebuffered.Scene;

public class BasicRenderer
extends ARenderComponent
implements IRenderComponent {
    public BasicRenderer() {
        this((Camera)null, new IRenderable[0]);
    }

    public BasicRenderer(Scene scene) {
        this(scene.getCamera(), scene);
    }

    public BasicRenderer(Camera cam, IRenderable ... objs) {
        this.setCamera(cam);
        this.setMode(Mode.RENDER);
        for (IRenderable obj : objs) {
            this.add(obj);
        }
    }

    protected BasicRenderer(Integer key, long cptr) {
        super(key, cptr);
    }

    @Override
    public Class resolveNativeClass() {
        return BasicRenderer.class;
    }

    public void add(IRenderable obj) {
        Native.manager.execMethod(BasicRenderer.class, (INativeObject)this, Methods.add.ordinal(), obj);
    }

    public void remove(IRenderable obj) {
        Native.manager.execMethod(BasicRenderer.class, (INativeObject)this, Methods.remove.ordinal(), obj);
    }

    public void clear() {
        Native.manager.execMethod(BasicRenderer.class, (INativeObject)this, Methods.clear.ordinal(), new Object[0]);
    }

    public void setAutoZFit(boolean enabled) {
        Native.manager.execMethod(BasicRenderer.class, (INativeObject)this, Methods.setAutoZFit.ordinal(), enabled);
    }

    public void setCamera(Camera camera) {
        Native.manager.execMethod(BasicRenderer.class, (INativeObject)this, Methods.setCamera.ordinal(), camera);
    }

    public void setMode(Mode mode) {
        Native.manager.execMethod(BasicRenderer.class, (INativeObject)this, Methods.setMode.ordinal(), mode.ordinal());
    }

    private static enum Methods {
        add,
        remove,
        clear,
        setAutoZFit,
        setCamera,
        setMode;

    }

    public static enum Mode {
        RENDER,
        Z_FIT_ONLY;

    }
}

