/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import thunderheadeng.scene3d.nativebuffered.Viewport;

public abstract class ARenderCounter {
    private int d_renderPauseCounter = 0;
    private boolean d_render = false;
    private Viewport d_renderVP = null;

    protected abstract void forceRender(Viewport var1);

    protected abstract Viewport getFullVP();

    public void pauseRender() {
        ++this.d_renderPauseCounter;
    }

    public void resumeRender() {
        this.resumeRender(false);
    }

    public void resumeRender(boolean render) {
        if (render) {
            this.render();
        }
        --this.d_renderPauseCounter;
        this.tryRender(this.getFullVP());
    }

    public void render() {
        this.d_render = true;
        this.tryRender(this.getFullVP());
    }

    public void render(Viewport vp) {
        this.d_render = true;
        this.tryRender(vp);
    }

    private void tryRender(Viewport vp) {
        if (this.d_renderPauseCounter == 0 && this.d_render) {
            this.forceRender(vp);
            this.d_render = false;
            this.d_renderVP = null;
        } else if (this.d_renderVP == null) {
            this.d_renderVP = vp;
        } else {
            this.d_renderVP.add(vp);
        }
    }
}

