/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.manip;

import thunderheadeng.geometry.IMutableGeomSrc;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.manip.ManipMgr;

public class ManipEvent {
    private final ManipMgr d_mgr;
    private final Type d_type;
    private final boolean d_committed;
    private final IGeomNode d_newNode;
    private final IHandle d_oldHandle;
    private final IMutableGeomSrc d_oldSource;

    public static ManipEvent manipStarted(ManipMgr mgr) {
        return new ManipEvent(mgr, Type.MANIP_STARTED, false, null, null, null);
    }

    public static ManipEvent handlesModified(ManipMgr mgr) {
        return new ManipEvent(mgr, Type.HANDLES_MODIFIED, false, null, null, null);
    }

    public static ManipEvent manipEnded(ManipMgr mgr, boolean committed, IGeomNode newGeom) {
        return new ManipEvent(mgr, Type.MANIP_ENDED, committed, newGeom, null, null);
    }

    public static ManipEvent sourceChanged(ManipMgr mgr, IMutableGeomSrc oldSource) {
        return new ManipEvent(mgr, Type.SOURCE_CHANGED, false, null, null, oldSource);
    }

    public static ManipEvent activeHandleChanged(ManipMgr mgr, IHandle oldHandle) {
        return new ManipEvent(mgr, Type.ACTIVE_HANDLE_CHANGED, false, null, oldHandle, null);
    }

    private ManipEvent(ManipMgr mgr, Type type, boolean committed, IGeomNode newNode, IHandle oldHandle, IMutableGeomSrc oldSource) {
        this.d_mgr = mgr;
        this.d_type = type;
        this.d_committed = committed;
        this.d_newNode = newNode;
        this.d_oldHandle = oldHandle;
        this.d_oldSource = oldSource;
    }

    public ManipMgr getSource() {
        return this.d_mgr;
    }

    public Type getType() {
        return this.d_type;
    }

    public boolean isCommitted() {
        return this.d_committed;
    }

    public IHandle getOldHandle() {
        return this.d_oldHandle;
    }

    public IMutableGeomSrc getOldSource() {
        return this.d_oldSource;
    }

    public IGeomNode getNewNode() {
        return this.d_newNode;
    }

    public static enum Type {
        MANIP_STARTED,
        MANIP_ENDED,
        HANDLES_MODIFIED,
        SOURCE_CHANGED,
        ACTIVE_HANDLE_CHANGED;

    }
}

