/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.gui;

import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import thunderheadeng.Intl;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.format.UDListFormat;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.scene3d.gui.IOffset;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.theUtil;

public class ValueEditorUtil {
    public static final String LOCATION = "LOCATION";
    public static final String OFFSET = "OFFSET";
    public static final int OFFSET_DISTANCE = 0;
    public static final int OFFSET_RELATIVE = 1;
    public static final int OFFSET_ABSOLUTE = 2;

    public static void configureLocation(ValueEditor editor, IUnitSrc lenUnit, String desc) {
        editor.addChoice(LOCATION, new ValueEditor.Choice(0, desc, new guiFormattedFld<Object>(new UDListFormat(lenUnit, 3, 3), null)));
    }

    public static void configureOffset(ValueEditor editor, IUnitSrc lenUnit, String distDesc, String relOffsetDesc, String absPosDesc) {
        if (distDesc != null) {
            editor.addChoice(OFFSET, new ValueEditor.Choice(0, distDesc, ValueFields.udFld(lenUnit)));
        }
        if (relOffsetDesc != null) {
            editor.addChoice(OFFSET, new ValueEditor.Choice(1, relOffsetDesc, new guiFormattedFld<Object>(new UDListFormat(lenUnit, 3, 3), null)));
        }
        if (absPosDesc != null) {
            editor.addChoice(OFFSET, new ValueEditor.Choice(2, absPosDesc, new guiFormattedFld<Object>(new UDListFormat(lenUnit, 3, 3), null)));
        }
    }

    public static void configure(ValueEditor editor, IUnitSrc lenUnit, String ... valueTypes) {
        if (ValueEditorUtil.contains(valueTypes, LOCATION)) {
            ValueEditorUtil.configureLocation(editor, lenUnit, Intl.intl("First Point (x,y,z)"));
        }
        if (ValueEditorUtil.contains(valueTypes, OFFSET)) {
            ValueEditorUtil.configureOffset(editor, lenUnit, Intl.intl("Distance"), Intl.intl("Relative Offset (x,y,z)"), Intl.intl("Absolute Position (x,y,z)"));
        }
    }

    private static boolean contains(Object[] values, Object value) {
        for (Object val : values) {
            if (!theUtil.equal(val, value)) continue;
            return true;
        }
        return false;
    }

    public static Point3d getLocation(ValueEditor editor, Unit dstLocUnit) {
        String key = editor.getCurrentValueType();
        if (LOCATION.equals(key)) {
            UnitDouble[] vals = (UnitDouble[])editor.getValue();
            if (vals == null) {
                return null;
            }
            return new UnitPoint3D(vals).getPoint3dValue(dstLocUnit);
        }
        return null;
    }

    public static void setLocation(ValueEditor editor, Point3d loc, Unit srcLocUnit) {
        UnitDouble[] vals = new UnitDouble[]{new UnitDouble(loc.x, srcLocUnit), new UnitDouble(loc.y, srcLocUnit), new UnitDouble(loc.z, srcLocUnit)};
        editor.setValue(vals);
    }

    public static IOffset getOffset(ValueEditor editor) {
        String key = editor.getCurrentValueType();
        if (OFFSET.equals(key)) {
            if (editor.getCurrentChoiceId() == 0) {
                UnitDouble val = (UnitDouble)editor.getValue();
                return val == null ? null : new IOffset.Distance(val);
            }
            boolean relative = editor.getCurrentChoiceId() == 1;
            UnitDouble[] vals = (UnitDouble[])editor.getValue();
            if (vals == null || vals.length < 3) {
                return null;
            }
            UnitPoint3D p = new UnitPoint3D(vals[0], vals[1], vals[2]);
            return new IOffset.DirOffset(p, relative);
        }
        return null;
    }

    public static void setOffset(ValueEditor editor, IOffset offset, boolean changeChoice) {
        editor.setValueType(OFFSET);
        if (offset instanceof IOffset.Distance) {
            editor.setValue(((IOffset.Distance)offset).dist, 0, changeChoice);
        } else if (offset instanceof IOffset.DirOffset) {
            IOffset.DirOffset dirOffset = (IOffset.DirOffset)offset;
            int choice = dirOffset.relative ? 1 : 2;
            UnitDouble[] vals = new UnitDouble[]{dirOffset.offset.xu(), dirOffset.offset.yu(), dirOffset.offset.zu()};
            editor.setValue(vals, choice, changeChoice);
        }
    }
}

