/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import thunderheadeng.image.IImage;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.theUtil;

public class Texture
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final IPropertySet.Prop<Boolean> PROP_CACHE_IN_STREAM = new IPropertySet.Prop<Boolean>("Texture.CACHE_IN_STREAM", false);
    public static final String DEFAULT_UVSET_NAME = "uvset";
    public final IImage image;
    public final Mode mode;
    public final Wrap wrap;
    public final Color borderColor;
    public final String uvSet;

    public Texture(IImage image, Mode mode, Wrap wrap, Color borderColor, String uvSet) {
        assert (!wrap.requiresBorderColor || borderColor != null);
        assert (!Objects.equals(uvSet, "teciuv0x193fa"));
        this.mode = mode;
        this.image = image;
        this.wrap = wrap;
        this.borderColor = borderColor;
        this.uvSet = uvSet;
    }

    public static Texture clampedToEdge(IImage image, Mode mode, String uvSet) {
        return new Texture(image, mode, Wrap.CLAMP_TO_EDGE, null, uvSet);
    }

    public static Texture clampedToEdge(IImage image, String uvSet) {
        return Texture.clampedToEdge(image, Mode.MODULATE, uvSet);
    }

    public static Texture clampedToBorder(IImage image, Mode mode, Color borderColor, String uvSet) {
        return new Texture(image, mode, Wrap.CLAMP, borderColor, uvSet);
    }

    public static Texture clampedToBorder(IImage image, Color borderColor, String uvSet) {
        return Texture.clampedToBorder(image, Mode.MODULATE, borderColor, uvSet);
    }

    public static Texture repeated(IImage image, Mode mode, String uvSet) {
        return new Texture(image, mode, Wrap.REPEAT, null, uvSet);
    }

    public static Texture repeated(IImage image, String uvSet) {
        return Texture.repeated(image, Mode.MODULATE, uvSet);
    }

    public Texture apply(IImage image) {
        if (image == this.image) {
            return this;
        }
        return new Texture(image, this.mode, this.wrap, this.borderColor, this.uvSet);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Texture && this.mode == ((Texture)obj).mode && this.wrap == ((Texture)obj).wrap && Texture.borderColorsEqual(this, (Texture)obj) && this.image.equals(((Texture)obj).image) && Objects.equals(this.uvSet, ((Texture)obj).uvSet);
    }

    public int hashCode() {
        return 107099379 + this.image.hashCode() + this.mode.hashCode() + this.wrap.hashCode() + Texture.borderColorHash(this) + this.uvSet.hashCode();
    }

    private static boolean borderColorsEqual(Texture tex1, Texture tex2) {
        return !tex1.wrap.requiresBorderColor || theUtil.equal(tex1.borderColor, tex2.borderColor);
    }

    private static int borderColorHash(Texture tex) {
        return !tex.wrap.requiresBorderColor ? 0 : theUtil.hashCode(tex.borderColor);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        boolean version = true;
        oos.writeInt(1);
        oos.writeObject((Object)this.mode);
        oos.writeObject((Object)this.wrap);
        oos.writeObject(this.borderColor);
        boolean cacheImage = oos instanceof IPropertySet && ((IPropertySet)((Object)oos)).get(PROP_CACHE_IN_STREAM) != false;
        IImage img = cacheImage ? this.image.cacheImage() : this.image;
        oos.writeObject(img);
        oos.writeObject(this.uvSet);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int version = ois.readInt();
        try {
            Object uvSet;
            theUtil.assignFinalField(this, Texture.class, "mode", ois.readObject());
            theUtil.assignFinalField(this, Texture.class, "wrap", ois.readObject());
            theUtil.assignFinalField(this, Texture.class, "borderColor", ois.readObject());
            theUtil.assignFinalField(this, Texture.class, "image", ois.readObject());
            Object object = uvSet = version >= 1 ? ois.readObject() : DEFAULT_UVSET_NAME;
            if (Objects.equals(uvSet, "teciuv0x193fa")) {
                uvSet = DEFAULT_UVSET_NAME;
            }
            theUtil.assignFinalField(this, Texture.class, "uvSet", uvSet);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e.getCause());
        }
        catch (NoSuchFieldException e) {
            throw new IOException(e.getCause());
        }
    }

    public static enum Wrap {
        CLAMP(true),
        CLAMP_TO_EDGE(false),
        REPEAT(false);

        public boolean requiresBorderColor;

        private Wrap(boolean requiresBorderColor) {
            this.requiresBorderColor = requiresBorderColor;
        }
    }

    public static enum Mode {
        MODULATE,
        REPLACE,
        DECAL,
        BLEND;

    }
}

