/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.geom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import thunderheadeng.scene3d.geom.FlattenedProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsSubList;
import thunderheadeng.scene3d.geom.UniformProps;

public class PropsBuilder
implements IPropsSrc {
    static final long serialVersionUID = 1L;
    private final ArrayList<Object> d_props = new ArrayList();
    private final ArrayList<RangeEntry> d_ranges = new ArrayList();

    @Override
    public IPropsSrc subset(int begin, int length) {
        if (begin == 0 && length == this.size()) {
            return this;
        }
        if (length == 1) {
            return new UniformProps(this.get(begin));
        }
        int endIx = begin + length - 1;
        RangeEntry entry = this.getPreviousRangeEntry(begin);
        if (entry != null && begin <= entry.gmax && endIx <= entry.gmax) {
            return new UniformProps(entry.props);
        }
        return new PropsSubList(this, begin, length);
    }

    public void add(IPropsSrc src, int count) {
        if (src instanceof UniformProps) {
            this.add(src.get(0), count);
        } else if (src instanceof PropsBuilder) {
            PropsBuilder builder = (PropsBuilder)src;
            int remaining = count;
            for (Object p : builder.d_props) {
                if (remaining != 0) {
                    if (p instanceof IPrimProps) {
                        this.add((IPrimProps)p);
                        --remaining;
                        continue;
                    }
                    RangeEntry re = (RangeEntry)p;
                    int toAdd = Math.min(remaining, re.gmax - re.gmin + 1);
                    this.add(re.props, toAdd);
                    remaining -= toAdd;
                    continue;
                }
                break;
            }
        } else {
            for (int m = 0; m < count; ++m) {
                this.add(src.get(m));
            }
        }
    }

    public void add(IPrimProps props) {
        this.add(props, 1);
    }

    public void add(IPrimProps props, int numPrims) {
        if (numPrims <= 0) {
            return;
        }
        if (!this.d_props.isEmpty()) {
            Object prev = this.d_props.get(this.d_props.size() - 1);
            if (prev instanceof RangeEntry) {
                if (((RangeEntry)prev).props.equals(props)) {
                    RangeEntry re = (RangeEntry)prev;
                    re.gmax += numPrims;
                    return;
                }
            } else if (prev.equals(props)) {
                int currSize = this.size();
                RangeEntry re = new RangeEntry(props, currSize - 1, currSize + numPrims - 1, this.d_props.size() - 1);
                this.d_props.set(re.lix, re);
                this.d_ranges.add(re);
                return;
            }
        }
        if (numPrims == 1) {
            this.d_props.add(props);
        } else {
            int lix = this.d_props.size();
            int gmin = this.size();
            int gmax = gmin + numPrims - 1;
            RangeEntry re = new RangeEntry(props, gmin, gmax, lix);
            this.d_ranges.add(re);
            this.d_props.add(re);
        }
    }

    @Override
    public IPrimProps[] flatten(int count) {
        IPrimProps[] props = new IPrimProps[count];
        int ix = 0;
        for (Object o : this.d_props) {
            if (ix >= count) break;
            if (o instanceof IPrimProps) {
                props[ix++] = (IPrimProps)o;
                continue;
            }
            RangeEntry re = (RangeEntry)o;
            int max = Math.min(re.gmax, count - 1);
            while (ix <= max) {
                props[ix] = re.props;
                ++ix;
            }
        }
        return props;
    }

    public int size() {
        if (this.d_ranges.isEmpty()) {
            return this.d_props.size();
        }
        RangeEntry lastRange = this.d_ranges.get(this.d_ranges.size() - 1);
        int diff = this.d_props.size() - lastRange.lix;
        return lastRange.gmax + diff;
    }

    protected int getLocalIx(int gix) {
        int reix = this.getPreviousRangeEntryIx(gix);
        if (reix == -1) {
            return gix;
        }
        RangeEntry re = this.d_ranges.get(reix);
        if (gix <= re.gmax) {
            return re.lix;
        }
        return gix - re.gmax + re.lix;
    }

    @Override
    public IPrimProps get(int ix) {
        int lix = this.getLocalIx(ix);
        Object obj = this.d_props.get(lix);
        return obj instanceof RangeEntry ? ((RangeEntry)obj).props : (IPrimProps)obj;
    }

    @Override
    public int getUniformCount(int startix, int maxCount) {
        return Math.min(this.getUniformCount(startix), maxCount);
    }

    public int getUniformCount(int startix) {
        RangeEntry re = this.getPreviousRangeEntry(startix);
        if (re != null && startix < re.gmax) {
            return re.gmax - startix + 1;
        }
        return 1;
    }

    private RangeEntry getPreviousRangeEntry(int ix) {
        int reix = this.getPreviousRangeEntryIx(ix);
        return reix < 0 ? null : this.d_ranges.get(reix);
    }

    private int getPreviousRangeEntryIx(int ix) {
        if (this.d_ranges.isEmpty()) {
            return -1;
        }
        int rangeix = Collections.binarySearch(this.d_ranges, ix);
        if (rangeix < 0) {
            if ((rangeix = -rangeix - 1) == 0) {
                return -1;
            }
            --rangeix;
        }
        return rangeix;
    }

    public IPropsSrc finalizeProps() {
        if (this.d_props.size() == 1) {
            Object props = this.d_props.get(0);
            IPrimProps p = props instanceof RangeEntry ? ((RangeEntry)props).props : (IPrimProps)props;
            return new UniformProps(p);
        }
        if (this.d_ranges.isEmpty()) {
            IPrimProps[] props = new IPrimProps[this.d_props.size()];
            for (int m = 0; m < props.length; ++m) {
                props[m] = (IPrimProps)this.d_props.get(m);
            }
            return new FlattenedProps(props);
        }
        this.d_props.trimToSize();
        this.d_ranges.trimToSize();
        return this;
    }

    @Override
    public Iterator<IPrimProps> iterator() {
        final int size = this.size();
        return new Iterator<IPrimProps>(){
            private int d_ix = 0;
            private int d_entryIx = 0;

            @Override
            public boolean hasNext() {
                return this.d_ix < size;
            }

            @Override
            public IPrimProps next() {
                ++this.d_ix;
                Object prop = PropsBuilder.this.d_props.get(this.d_entryIx);
                if (prop instanceof RangeEntry) {
                    RangeEntry re = (RangeEntry)prop;
                    if (this.d_ix > re.gmax) {
                        ++this.d_entryIx;
                    }
                    return re.props;
                }
                ++this.d_entryIx;
                return (IPrimProps)prop;
            }
        };
    }

    private static class RangeEntry
    implements Comparable<Integer>,
    Serializable {
        static final long serialVersionUID = 1L;
        public final IPrimProps props;
        public final int gmin;
        public int gmax;
        public final int lix;

        public RangeEntry(IPrimProps props, int gmin, int gmax, int lix) {
            this.props = props;
            this.gmin = gmin;
            this.gmax = gmax;
            this.lix = lix;
        }

        @Override
        public int compareTo(Integer o) {
            return this.gmin - o;
        }
    }
}

