/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.geom;

import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import thunderheadeng.image.HashableImage;
import thunderheadeng.image.IImage;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;

public class MatUtil {
    public static boolean isSupported(IMatAttrs mat, MatChannel chnl) {
        return mat.getColor(chnl) != null || mat.getTexture(chnl) != null;
    }

    public static MatChannel[] getSupportedChannels(IMatAttrs mat) {
        ArrayList<MatChannel> sChannels = new ArrayList<MatChannel>(MatChannel.values().length);
        for (MatChannel chnl : MatChannel.values()) {
            if (!MatUtil.isSupported(mat, chnl)) continue;
            sChannels.add(chnl);
        }
        return sChannels.toArray(new MatChannel[sChannels.size()]);
    }

    public static Pair<Color, Texture> getChannel(IMatAttrs mat, MatChannel chnl) {
        return new Pair<Color, Texture>(mat.getColor(chnl), mat.getTexture(chnl));
    }

    public static Set<String> getUVSets(IMatAttrs mat) {
        LinkedHashSet<String> uvSets = new LinkedHashSet<String>();
        for (MatChannel chnl : MatChannel.values()) {
            Texture tex = mat.getTexture(chnl);
            if (tex == null) continue;
            uvSets.add(tex.uvSet);
        }
        return uvSets;
    }

    public static IMatAttrs makeImagesHashable(IMatAttrs attrs) {
        boolean modified = false;
        ArrayList props = new ArrayList();
        for (IPropertySet.Prop prop : IMatAttrs.ALL) {
            props.add(prop);
            Object val = attrs.get(prop);
            if (val instanceof Texture) {
                val = MatUtil.makeImageHashable((Texture)val);
                modified = true;
            }
            props.add(val);
        }
        if (!modified) {
            return attrs;
        }
        return new MatAttrs(theUtil.toArray(props, Object.class));
    }

    public static Texture makeImageHashable(Texture t) {
        if (t.image instanceof HashableImage) {
            return t;
        }
        return t.apply(new HashableImage(t.image));
    }

    public static IMatAttrs.MatProp<Texture> newTexProp(Object key, String xmlKey) {
        TypedProp<String> xmlFNProp = new TypedProp<String>((Object)xmlKey, String.class);
        TypedProp<String> xmlUVSetProp = new TypedProp<String>((Object)(xmlKey + ".uvSet"), "uvset");
        return new IMatAttrs.MatProp<Texture>(key, null, (tp, imgSaver, tex) -> {
            String fn;
            if (tex != null && tex.image != null && (fn = (String)imgSaver.apply(tex.image)) != null) {
                tp.set(xmlFNProp, fn);
                tp.set(xmlUVSetProp, tex.uvSet);
            }
        }, (tp, imgLoader) -> {
            String name = (String)tp.get(xmlFNProp);
            String uvSet = (String)tp.get(xmlUVSetProp);
            if (uvSet.equals("teciuv0x193fa")) {
                uvSet = "uvset";
            }
            if (name == null || name.isEmpty()) {
                return null;
            }
            IImage img = (IImage)imgLoader.apply(name);
            if (img == null) {
                return null;
            }
            return Texture.repeated(img, uvSet);
        });
    }

    public static IMatAttrs.MatProp<Color> newColorProp(Object key, String xmlKey, Color defVal) {
        TypedProp<Integer> xmlProp = new TypedProp<Integer>((Object)xmlKey, Integer.class);
        return new IMatAttrs.MatProp<Color>(key, defVal, (tp, imgSaver, color) -> {
            if (color != null) {
                tp.set(xmlProp, Integer.valueOf(MatUtil.encodeARGB(color)));
            }
        }, (tp, imgLoader) -> {
            Integer colorARGB = (Integer)tp.get(xmlProp);
            if (colorARGB == null) {
                return defVal;
            }
            return new Color(colorARGB, true);
        });
    }

    public static <T> IMatAttrs.MatProp<T> newProp(Object key, String xmlKey, T defVal) {
        return MatUtil.newProp(key, new TypedProp<T>((Object)xmlKey, defVal));
    }

    public static <T> IMatAttrs.MatProp<T> newProp(Object key, String xmlKey, Class<T> type) {
        return MatUtil.newProp(key, new TypedProp<T>((Object)xmlKey, type));
    }

    private static <T> IMatAttrs.MatProp<T> newProp(Object key, TypedProp<T> xmlProp) {
        return new IMatAttrs.MatProp<Object>(key, xmlProp.defVal, (tp, imgSaver, val) -> tp.set(xmlProp, val), (tp, imgLoader) -> tp.get(xmlProp));
    }

    private static int encodeARGB(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int a = color.getAlpha();
        return a << 24 & 0xFF000000 | r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b << 0 & 0xFF;
    }
}

