/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.theUtil;

public class MatAttrs
implements IMatAttrs,
Serializable {
    static final long serialVersionUID = 1L;
    private final PropertySet d_props;

    public MatAttrs() {
        this(Collections.emptyList());
    }

    public MatAttrs(Color diffuseColor, Texture diffuseTex, double diffuseFade) {
        this(diffuseColor, diffuseTex, diffuseFade, (Texture)IMatAttrs.NORMAL.defVal);
    }

    public MatAttrs(Color diffuseColor, Texture diffuseTex, double diffuseFade, Texture normal) {
        this(diffuseColor, diffuseTex, diffuseFade, (Color)IMatAttrs.SPECULAR_COLOR.defVal, (Texture)IMatAttrs.SPECULAR_TEXTURE.defVal, (Double)IMatAttrs.SPECULAR_FADE.defVal, normal, (Integer)IMatAttrs.OPTIONS.defVal);
    }

    public MatAttrs(Color diffuseColor, Texture diffuseTex, double diffuseFade, Color specColor, Texture specTex, double specFade, Texture normal, int options) {
        this(DIFFUSE_COLOR, diffuseColor, DIFFUSE_TEXTURE, diffuseTex, DIFFUSE_FADE, diffuseFade, SPECULAR_COLOR, specColor, SPECULAR_TEXTURE, specTex, SPECULAR_FADE, specFade, NORMAL, normal, OPTIONS, options);
    }

    public MatAttrs(Object ... props) {
        this(Arrays.asList(props));
    }

    public MatAttrs(List<Object> props) {
        assert (props.size() % 2 == 0);
        this.d_props = new PropertySet();
        for (int m = 0; m < props.size(); m += 2) {
            this.d_props.setIfNotDefault((IPropertySet.Prop)props.get(m + 0), props.get(m + 1));
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IMatAttrs)) {
            return false;
        }
        IMatAttrs attrs = (IMatAttrs)obj;
        return this.compare((IPropertySet)attrs, ALL);
    }

    public int hashCode() {
        return this.hash(ALL);
    }

    @Override
    public <T> void set(IPropertySet.Prop<T> prop, T val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void remove(IPropertySet.Prop<T> prop) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T get(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    @Override
    public <T> boolean isDefined(IPropertySet.Prop<T> prop) {
        return this.d_props.isDefined(prop);
    }

    public <T> MatAttrs apply(IPropertySet.Prop<T> prop, T val) {
        MatAttrs result = new MatAttrs();
        result.d_props.merge((IPropertySet)this.d_props, ALL);
        result.d_props.setIfNotDefault(prop, val);
        return result;
    }

    public <T> MatAttrs apply(Object ... props) {
        assert (props.length % 2 == 0);
        MatAttrs result = new MatAttrs();
        result.d_props.merge((IPropertySet)this.d_props, ALL);
        for (int m = 0; m < props.length; m += 2) {
            result.d_props.setIfNotDefault((IPropertySet.Prop)props[m + 0], props[m + 1]);
        }
        return result;
    }

    public <T> MatAttrs applyColor(MatChannel chnl, Color val) {
        MatAttrs result = new MatAttrs();
        result.d_props.merge((IPropertySet)this.d_props, ALL);
        switch (chnl) {
            case DIFFUSE: {
                result.d_props.setIfNotDefault(DIFFUSE_COLOR, val);
                break;
            }
            case EMISSIVE: {
                result.d_props.setIfNotDefault(EMISSIVE_COLOR, val);
                break;
            }
            case OPACITY: {
                result.d_props.setIfNotDefault(OPACITY_COLOR, val);
                break;
            }
            case REFLECTION: {
                result.d_props.setIfNotDefault(REFLECTION_COLOR, val);
                break;
            }
            case SPECULAR: {
                result.d_props.setIfNotDefault(SPECULAR_COLOR, val);
            }
        }
        return result;
    }

    public <T> MatAttrs applyFade(MatChannel chnl, double val) {
        MatAttrs result = new MatAttrs();
        result.d_props.merge((IPropertySet)this.d_props, ALL);
        switch (chnl) {
            case DIFFUSE: {
                result.d_props.setIfNotDefault(DIFFUSE_FADE, val);
                break;
            }
            case EMISSIVE: {
                result.d_props.setIfNotDefault(EMISSIVE_FADE, val);
                break;
            }
            case OPACITY: {
                result.d_props.setIfNotDefault(OPACITY_FADE, val);
                break;
            }
            case REFLECTION: {
                result.d_props.setIfNotDefault(REFLECTION_FADE, val);
                break;
            }
            case SPECULAR: {
                result.d_props.setIfNotDefault(SPECULAR_FADE, val);
            }
        }
        return result;
    }

    public <T> MatAttrs applyTexture(MatChannel chnl, Texture val) {
        MatAttrs result = new MatAttrs();
        result.d_props.merge((IPropertySet)this.d_props, ALL);
        switch (chnl) {
            case BUMP: {
                result.d_props.setIfNotDefault(BUMP, val);
                break;
            }
            case DIFFUSE: {
                result.d_props.setIfNotDefault(DIFFUSE_TEXTURE, val);
                break;
            }
            case EMISSIVE: {
                result.d_props.setIfNotDefault(EMISSIVE_TEXTURE, val);
                break;
            }
            case NORMAL: {
                result.d_props.setIfNotDefault(NORMAL, val);
                break;
            }
            case OPACITY: {
                result.d_props.setIfNotDefault(OPACITY_TEXTURE, val);
                break;
            }
            case REFLECTION: {
                result.d_props.setIfNotDefault(REFLECTION_TEXTURE, val);
                break;
            }
            case SPECULAR: {
                result.d_props.setIfNotDefault(SPECULAR_TEXTURE, val);
            }
        }
        return result;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_props == null) {
            try {
                theUtil.assignFinalField(this, MatAttrs.class, "d_props", new PropertySet());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public MatAttrs applyColorToDiffuseAndOpacity(Color col) {
        int a = 255;
        if (col != null && col.getAlpha() != 255) {
            a = col.getAlpha();
            col = new Color(col.getRed(), col.getGreen(), col.getBlue());
        }
        return this.apply(IMatAttrs.DIFFUSE_COLOR, col, IMatAttrs.OPACITY_COLOR, new Color(a, a, a));
    }
}

