/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.geom;

import java.util.Arrays;
import java.util.Iterator;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.util.theUtil;

public class FlattenedProps
implements IPropsSrc {
    static final long serialVersionUID = 1L;
    private final IPrimProps[] d_props;

    public FlattenedProps(IPrimProps ... props) {
        this.d_props = props;
    }

    @Override
    public IPrimProps get(int ix) {
        return this.d_props[ix];
    }

    public boolean isUniform(int ix, int count) {
        return count == 1;
    }

    @Override
    public int getUniformCount(int startix, int maxCount) {
        int uniformCount = 1;
        IPrimProps first = this.d_props[startix];
        int end = startix + maxCount;
        for (int m = startix + 1; m < end && this.d_props[m].equals(first); ++m) {
            ++uniformCount;
        }
        return uniformCount;
    }

    @Override
    public IPropsSrc subset(int startix, int count) {
        if (startix == 0 && count == this.d_props.length) {
            return this;
        }
        return IPropsSrc.super.subset(startix, count);
    }

    public IPrimProps[] getAll() {
        return this.d_props;
    }

    @Override
    public IPrimProps[] flatten(int count) {
        if (count == this.d_props.length) {
            return this.d_props;
        }
        return Arrays.copyOf(this.d_props, count);
    }

    @Override
    public Iterator<IPrimProps> iterator() {
        return theUtil.iterator(this.d_props);
    }
}

