/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.geom;

import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.scene3d.geom.FlattenedProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.UniformProps;

public class DisplayGeom {
    public static final DisplayGeom EMPTY = new DisplayGeom(GeomNodeUtil.EMPTY_NODE, new FlattenedProps(new IPrimProps[0]));
    public final IGeomNode node;
    public final IPropsSrc props;

    public DisplayGeom(IGeomNode geom, IPropsSrc props) {
        this.node = geom;
        this.props = props;
    }

    public DisplayGeom(IGeomNode geom, IPrimProps props) {
        this(geom, new UniformProps(props));
    }

    public DisplayGeom(IGeomNode geom, IPrimProps ... props) {
        this(geom, new FlattenedProps(props));
    }

    public DisplayGeom transform(TransformInfo xform) {
        IGeomNode newNode = this.node.transform(xform);
        if (newNode == this.node) {
            return this;
        }
        return new DisplayGeom(newNode, this.props);
    }

    public DisplayGeom quickTransform(TransformInfo xform) {
        IGeomNode newNode = this.node.quickTransform(xform);
        if (newNode == this.node) {
            return this;
        }
        return new DisplayGeom(newNode, this.props);
    }
}

