/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d;

import java.awt.Color;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPlanarFace;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.legacy.v1.util.LinkedIdentityHashMap;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ListMap;

public class GeomWriter {
    public static boolean ADVANCED_PARAMS_ENABLED = false;
    public static int CURR_VERSION = Version.curr().ordinal();
    private static final IMatAttrs s_defAttrs = new MatAttrs();

    public static void write(ObjectOutput writer, IGeomNode node, IPropsSrc props, double curveError, double faceError) throws IOException {
        writer.writeInt(0);
        writer.writeInt(0);
        writer.writeInt(0);
        writer.writeInt(0);
        GeomWriter.writeNode(writer, TransformUtil.IDENTITY, node, props, 0, curveError, faceError);
        writer.writeInt(GeomType.GT_END.ordinal());
    }

    private static int writeNode(ObjectOutput writer, ITransform parentTransform, IGeomNode node, IPropsSrc props, int primOffset, double curveError, double faceError) throws IOException {
        TransformInfo ti = parentTransform.concatenate(node.getLocalTransform()).getInfo();
        IGeom geom = node.getLocalGeom();
        IPropertySet elements = node.getLocalElements();
        primOffset = GeomWriter.writeGeom(writer, geom, ti, props, primOffset, elements, curveError, faceError);
        for (IGeomNode iGeomNode : node.getChildren()) {
            primOffset = GeomWriter.writeNode(writer, ti.xform, iGeomNode, props, primOffset, curveError, faceError);
        }
        return primOffset;
    }

    private static int writeGeom(ObjectOutput writer, IGeom geom, TransformInfo ti, IPropsSrc props, int primOffset, IPropertySet elements, double curveError, double faceError) throws IOException {
        geom = geom.transform(ti, 0);
        elements = Elements.transform(elements, ti);
        ElementSources elSrc = new ElementSources(elements, geom.getNumPrims(7));
        return GeomWriter.writeGeom(writer, geom, props, primOffset, elSrc, curveError, faceError);
    }

    private static int writeGeom(ObjectOutput writer, IGeom geom, IPropsSrc props, int primOffset, ElementSources elements, double curveError, double faceError) throws IOException {
        if (geom instanceof Point) {
            GeomWriter.writePoint(writer, (Point)geom, props.get(primOffset++));
        } else if (geom instanceof LineSeg) {
            GeomWriter.writeLineSeg(writer, (LineSeg)geom, props.get(primOffset++));
        } else if (geom instanceof PolyLine) {
            GeomWriter.writeLineStrip(writer, (PolyLine)geom, props.get(primOffset++));
        } else if (geom instanceof Triangle) {
            GeomWriter.writeTriangle(writer, (Triangle)geom, props.get(primOffset), elements);
            ++primOffset;
        } else if (geom instanceof Quad) {
            GeomWriter.writeQuad(writer, (Quad)geom, props.get(primOffset), elements);
            ++primOffset;
        } else if (geom instanceof IPlanarFace) {
            GeomWriter.writePoly(writer, ((IPlanarFace)geom).toPoly(curveError), props.get(primOffset), elements);
            ++primOffset;
        } else if (geom instanceof Mesh) {
            primOffset = GeomWriter.writeMesh(writer, (Mesh)geom, props, primOffset, elements, null);
        } else if (geom instanceof ICurve) {
            Mesh mesh = ((ICurve)geom).getSegments(curveError);
            primOffset = GeomWriter.writeMesh(writer, mesh, props, primOffset, elements, (ICurve)geom);
        } else if (geom instanceof IFace) {
            Mesh mesh = ((IFace)geom).triangulate(faceError);
            primOffset = GeomWriter.writeMesh(writer, mesh, props, primOffset, elements, (IFace)geom);
        } else if (geom.canExplode()) {
            int offset = 0;
            for (IGeom subGeom : geom.explode(new ArrayList<IGeom>())) {
                int numPrims = subGeom.getNumPrims(7);
                ElementSources subElems = elements.sublist(offset, numPrims);
                primOffset = GeomWriter.writeGeom(writer, subGeom, props, primOffset, subElems, curveError, faceError);
                offset += numPrims;
            }
        } else {
            assert (geom.getNumPrims(7) == 0);
            primOffset += geom.getNumPrims(7);
        }
        return primOffset;
    }

    private static List<Point2d> generateUVDiffuse(IPolygon face, IPrimProps props, ElementSources elements) {
        Texture tex;
        Texture texture = tex = props.getMaterial() != null ? props.getMaterial().getAttributes().get(IMatAttrs.DIFFUSE_TEXTURE) : null;
        if (tex != null) {
            IElemSource<Point2d> uv = elements.getUV(tex.uvSet);
            return GeomWriter.generateElements(face, props, elements, Point2d.class, uv, Elements.NO_UV);
        }
        return Collections.emptyList();
    }

    private static List<Vector3d> generateNormals(IPolygon face, IPrimProps props, ElementSources elements) {
        return GeomWriter.generateElements(GeomWriter.needsNormals(true), face, props, elements, Elements.NORMAL, Elements.NO_NORMAL);
    }

    private static List<Boolean> generateCreases(IPolygon face, IPrimProps props, ElementSources elements) {
        return GeomWriter.generateElements(GeomWriter.needsCreases(true), face, props, elements, Elements.CREASE, null);
    }

    private static List<Elements.Orient> generateOrients(IPolygon face, IPrimProps props, ElementSources elements) {
        return GeomWriter.generateElements(GeomWriter.needsOrients(true), face, props, elements, Elements.ORIENT, null);
    }

    private static <ElemT> List<ElemT> generateElements(boolean needsElements, IPolygon face, IPrimProps props, ElementSources allElements, Elements.ElemProp<ElemT> elemProp, IElemSource<ElemT> noElems) {
        if (needsElements) {
            IElemSource<ElemT> elements = allElements.get(elemProp);
            return GeomWriter.generateElements(face, props, allElements, elemProp.type, elements, noElems);
        }
        return Collections.EMPTY_LIST;
    }

    private static <ElemT> List<ElemT> generateElements(IPolygon face, IPrimProps props, ElementSources allElements, Class<ElemT> type, IElemSource<ElemT> elements, IElemSource<ElemT> noElems) {
        if (elements == noElems) {
            return Collections.emptyList();
        }
        ElementMesh<ElemT> elemMesh = elements.generate(type, Collections.singletonList(face), allElements.get(Elements.ORIENT), new UniformProps(props), PolyUtil.getNumVerts(face), false);
        if (elemMesh.mapping == ElementMesh.Mapping.ALL_SAME) {
            return Collections.singletonList(elemMesh.getPrimVertElement(0, 0));
        }
        return elemMesh;
    }

    private static void writePoint(ObjectOutput writer, Point point, IPrimProps props) throws IOException {
        GeomWriter.beginGeom(writer, point, GeomType.GT_POINT.ordinal(), props);
        GeomWriter.writeTuple3d(writer, (Tuple3d)point.loc);
    }

    private static void writeLineSeg(ObjectOutput writer, LineSeg line, IPrimProps props) throws IOException {
        GeomWriter.beginGeom(writer, line, GeomType.GT_LINESEG.ordinal(), props);
        GeomWriter.write((DataOutput)writer, new Tuple3d[]{line.p1, line.p2});
    }

    private static void writeLineStrip(ObjectOutput writer, PolyLine line, IPrimProps props) throws IOException {
        GeomWriter.beginGeom(writer, line, GeomType.GT_LINE_STRIP.ordinal(), props);
        GeomWriter.writeArray((DataOutput)writer, (Tuple3d[])line.verts);
    }

    private static void beginPoly(ObjectOutput writer, GeomType type, IPolygon poly, IPrimProps props, ElementSources elements) throws IOException {
        writer.writeInt(type.ordinal());
        GeomWriter.writeTuple2dList(writer, GeomWriter.generateUVDiffuse(poly, props, elements));
        GeomWriter.writeTuple3dList(writer, GeomWriter.generateNormals(poly, props, elements));
        GeomWriter.writeBooleanList(writer, GeomWriter.generateCreases(poly, props, elements));
        List<Elements.Orient> orients = GeomWriter.generateOrients(poly, props, elements);
        Elements.Orient orient = orients.isEmpty() ? Elements.Orient.CCW : orients.get(0);
        GeomWriter.writeOrient(writer, orient);
        GeomWriter.writeMeta(writer, poly, props);
    }

    private static void writeTriangle(ObjectOutput writer, Triangle tri, IPrimProps props, ElementSources elements) throws IOException {
        GeomWriter.beginPoly(writer, GeomType.GT_TRIANGLE, tri, props, elements);
        GeomWriter.write((DataOutput)writer, new Tuple3d[]{tri.p1, tri.p2, tri.p3});
    }

    private static void writeQuad(ObjectOutput writer, Quad quad, IPrimProps props, ElementSources elements) throws IOException {
        GeomWriter.beginPoly(writer, GeomType.GT_QUAD, quad, props, elements);
        GeomWriter.write((DataOutput)writer, new Tuple3d[]{quad.p1, quad.p2, quad.p3, quad.p4});
    }

    private static void writePoly(ObjectOutput writer, IPolygon poly, IPrimProps props, ElementSources elements) throws IOException {
        GeomWriter.beginPoly(writer, GeomType.GT_POLYGON, poly, props, elements);
        writer.writeInt(poly.getNumLoops());
        for (int m = 0; m < poly.getNumLoops(); ++m) {
            writer.writeInt(poly.getNumPoints(m));
            for (int n = 0; n < poly.getNumPoints(m); ++n) {
                Point3d p = poly.getPoint(m, n);
                GeomWriter.writeTuple3d(writer, (Tuple3d)p);
            }
        }
    }

    private static int writeMesh(ObjectOutput writer, Mesh mesh, IPropsSrc props, int pOffset, ElementSources elements, IPrimitive source) throws IOException {
        int count;
        writer.writeInt(GeomType.GT_MESH.ordinal());
        boolean isFaceType = GeomWriter.isFaceType(mesh);
        boolean smoothNormals = mesh.testFlag(2);
        writer.writeBoolean(smoothNormals);
        switch (mesh.primtype) {
            case 0: {
                writer.writeInt(GeomType.GT_POINT.ordinal());
                break;
            }
            case 1: {
                writer.writeInt(GeomType.GT_LINESEG.ordinal());
                break;
            }
            case 2: {
                writer.writeInt(GeomType.GT_TRIANGLE.ordinal());
                break;
            }
            case 3: {
                writer.writeInt(GeomType.GT_QUAD.ordinal());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        boolean needsTexUV = false;
        int numPrims = mesh.getNumPrims(7);
        int numProps = source != null ? 1 : numPrims;
        LinkedIdentityHashMap<IPrimProps, Integer> primMap = new LinkedIdentityHashMap<IPrimProps, Integer>();
        ArrayList<int[]> offsets = new ArrayList<int[]>();
        int pEnd = numProps + pOffset;
        for (int offset = pOffset; offset < pEnd; offset += count) {
            IPrimProps primProps = props.get(offset);
            count = props.getUniformCount(offset, pEnd - offset);
            assert (count > 0);
            Integer ix = (Integer)primMap.get(primProps);
            if (ix == null) {
                ix = primMap.size();
                primMap.put(primProps, ix);
            }
            offsets.add(new int[]{count, ix});
            needsTexUV = needsTexUV || isFaceType && GeomWriter.needsTexUV(primProps);
        }
        GeomWriter.writeArray((DataOutput)writer, (Tuple3d[])mesh.vertices);
        GeomWriter.writeArray((DataOutput)writer, mesh.indices);
        IPropsSrc meshProps = props.subset(pOffset, numProps);
        if (numProps != numPrims && !(meshProps instanceof UniformProps)) {
            meshProps = new UniformProps(meshProps.get(0));
        }
        ElementMesh<Point2d> diffUV = GeomWriter.getUVElements(needsTexUV, elements, source, mesh, meshProps, numPrims);
        ElementMesh<Vector3d> normals = GeomWriter.getElements(GeomWriter.needsNormals(isFaceType), elements, Elements.NORMAL, Elements.NO_NORMAL, source, mesh, meshProps, numPrims);
        ElementMesh<Boolean> creases = GeomWriter.getElements(GeomWriter.needsCreases(isFaceType), elements, Elements.CREASE, null, source, mesh, meshProps, numPrims);
        ElementMesh<Elements.Orient> orients = GeomWriter.getElements(GeomWriter.needsOrients(isFaceType), elements, Elements.ORIENT, null, source, mesh, meshProps, numPrims);
        GeomWriter.writeElements(writer, mesh.indices, diffUV, (w, a) -> GeomWriter.writeArray(w, (Tuple2d[])a));
        GeomWriter.writeElements(writer, mesh.indices, normals, (w, a) -> GeomWriter.writeArray(w, (Tuple3d[])a));
        GeomWriter.writeElements(writer, mesh.indices, creases, (w, a) -> GeomWriter.writeArray(w, a));
        GeomWriter.writeElements(writer, mesh.indices, orients, (w, a) -> GeomWriter.writeArray(w, a));
        writer.writeInt(primMap.size());
        for (IPrimProps primProps : primMap.keySet()) {
            GeomWriter.writeMeta(writer, mesh, primProps);
        }
        writer.writeInt(numProps);
        Iterator<Object> iterator = offsets.iterator();
        while (iterator.hasNext()) {
            int[] offset;
            for (int offsetVal : offset = (int[])iterator.next()) {
                writer.writeInt(offsetVal);
            }
        }
        return pOffset + numProps;
    }

    private static <ElemT> ElementMesh<ElemT> getElements(boolean relevant, ElementSources elements, Elements.ElemProp<ElemT> prop, IElemSource<ElemT> noElems, IPrimitive source, Mesh mesh, IPropsSrc props, int numPrims) {
        return GeomWriter.getElements(relevant, elements, prop.type, () -> elements.get(prop), noElems, source, mesh, props, numPrims);
    }

    private static <ElemT> ElementMesh<ElemT> getElements(boolean relevant, ElementSources elements, Class<ElemT> elemType, Supplier<IElemSource<ElemT>> elemSupplier, IElemSource<ElemT> noElems, IPrimitive source, Mesh mesh, IPropsSrc props, int numPrims) {
        if (!relevant) {
            return null;
        }
        IElemSource<Elements.Orient> orients = elements.get(Elements.ORIENT);
        IElemSource<ElemT> elems = elemSupplier.get();
        if (elems == noElems) {
            return null;
        }
        if (source != null) {
            return elems.generate(elemType, source, orients.getPrimElement(0), mesh, props.get(0));
        }
        assert (GeomWriter.isFaceType(mesh));
        return elems.generate(elemType, mesh.getPrimitives(), orients, props, mesh.getNumVertsPerPrim(), false);
    }

    private static ElementMesh<Point2d> getUVElements(boolean relevant, ElementSources elements, IPrimitive source, Mesh mesh, IPropsSrc props, int numPrims) {
        if (!relevant) {
            return null;
        }
        if (elements.isUniformUV() || source != null) {
            Supplier elemSupplier = elements.isUniformUV() ? () -> elements.getUniformUV() : () -> {
                Texture dtex;
                IPrimProps pprops = props.get(0);
                Texture texture = dtex = pprops.getMaterial() != null ? pprops.getMaterial().getAttributes().get(IMatAttrs.DIFFUSE_TEXTURE) : null;
                if (dtex == null) {
                    return Elements.NO_UV;
                }
                return elements.getUV(dtex.uvSet);
            };
            return GeomWriter.getElements(relevant, elements, Point2d.class, elemSupplier, Elements.NO_UV, source, mesh, props, numPrims);
        }
        ListMap<String, ElementMesh> channelUV = new ListMap<String, ElementMesh>();
        Function<String, ElementMesh> computeUV = uvSet -> GeomWriter.getElements(relevant, elements, Point2d.class, () -> {
            IElemSource<Point2d> uvsrc = elementSources.uvsublists.get(uvSet);
            if (uvsrc == null) {
                return Elements.NO_UV;
            }
            return uvsrc;
        }, Elements.NO_UV, source, mesh, props, numPrims);
        Point2d pnt2dOrigin = new Point2d(0.0, 0.0);
        Point2d[] result = new Point2d[mesh.indices.length];
        Iterator<IPrimProps> propit = props.iterator();
        int vperprim = mesh.getNumVertsPerPrim();
        int voffset = 0;
        for (int m = 0; m < numPrims; ++m) {
            Texture dtex;
            IPrimProps prop = propit.next();
            Texture texture = dtex = prop.getMaterial() != null ? prop.getMaterial().getAttributes().get(IMatAttrs.DIFFUSE_TEXTURE) : null;
            if (dtex != null) {
                ElementMesh duv = channelUV.computeIfAbsent(dtex.uvSet, computeUV);
                if (duv == null && (duv = channelUV.computeIfAbsent("teciuv0x193fa", computeUV)) == null && !elements.uvsublists.isEmpty()) {
                    duv = channelUV.computeIfAbsent(elements.uvsublists.keySet().iterator().next(), computeUV);
                }
                if (duv != null) {
                    for (int n = 0; n < vperprim; ++n) {
                        result[voffset] = (Point2d)duv.get(voffset);
                        ++voffset;
                    }
                    continue;
                }
            }
            for (int n = 0; n < vperprim; ++n) {
                result[voffset++] = pnt2dOrigin;
            }
        }
        return new ElementMesh<Point2d>(ElementMesh.Mapping.PER_PRIM_VERTEX, result, vperprim);
    }

    private static boolean isFaceType(Mesh mesh) {
        return mesh.primtype == 3 || mesh.primtype == 2;
    }

    private static boolean needsNormals(boolean isFaceType) {
        return isFaceType;
    }

    private static boolean needsCreases(boolean isFaceType) {
        return isFaceType;
    }

    private static boolean needsOrients(boolean isFaceType) {
        return isFaceType;
    }

    private static boolean needsTexUV(IPrimProps props) {
        IMaterial mat = props.getMaterial();
        if (mat == null) {
            return false;
        }
        IMatAttrs attrs = mat.getAttributes();
        for (MatChannel chnl : MatChannel.values()) {
            if (attrs.getTexture(chnl) == null) continue;
            return true;
        }
        return false;
    }

    private static <T> void writeElements(ObjectOutput writer, int[] geomIndices, ElementMesh<T> mesh, ThrowableBiConsumer<DataOutput, T[]> elemWriter) throws IOException {
        ElemMapping nmapping;
        writer.writeBoolean(mesh != null);
        if (mesh == null) {
            return;
        }
        switch (mesh.mapping) {
            case ALL_SAME: {
                nmapping = ElemMapping.EM_ALL_SAME;
                break;
            }
            case PER_PRIM: {
                nmapping = ElemMapping.EM_PER_FACE;
                break;
            }
            case PER_PRIM_VERTEX: {
                nmapping = ElemMapping.EM_PER_INDEX;
                break;
            }
            default: {
                nmapping = ElemMapping.EM_NONE;
            }
        }
        writer.writeInt(nmapping.ordinal());
        elemWriter.accept(writer, mesh.elements);
        boolean writeIndices = geomIndices != mesh.indices;
        writer.writeBoolean(writeIndices);
        if (writeIndices) {
            GeomWriter.writeArray((DataOutput)writer, mesh.indices);
        }
    }

    private static void beginGeom(ObjectOutput writer, IGeom geom, int type, IPrimProps props) throws IOException {
        writer.writeInt(type);
        GeomWriter.writeMeta(writer, geom, props);
    }

    private static void writeMeta(ObjectOutput writer, IGeom geom, IPrimProps props) throws IOException {
        Color color = props.getColor();
        IMaterial mat = props.getMaterial();
        if (color == null && mat != null) {
            color = mat.getAttributes().getDiffuseColorWithOpacity();
        }
        assert (color != null || mat != null) : "Either a material or a color must be specified.";
        GeomWriter.write((DataOutput)writer, color);
        writer.writeObject(mat);
        writer.writeFloat((float)props.getEdgeWidth());
        writer.writeInt(props.getEdgeStipple());
        writer.writeFloat((float)props.getPointSize());
        int options = props.getOptions();
        if (props.getMaterial() != null && (props.getMaterial().getAttributes().getOptions() & 2) != 0) {
            options |= 2;
        }
        writer.writeInt(options);
    }

    private static void write(DataOutput writer, Color color) throws IOException {
        float[] comps = new float[4];
        color.getComponents(comps);
        writer.writeFloat(comps[0]);
        writer.writeFloat(comps[1]);
        writer.writeFloat(comps[2]);
        writer.writeFloat(comps[3]);
    }

    private static void writeTuple3dList(DataOutput writer, List<? extends Tuple3d> points) throws IOException {
        GeomWriter.writeList(writer, GeomWriter::writeTuple3d, points);
    }

    private static void writeArray(DataOutput writer, Tuple3d ... points) throws IOException {
        GeomWriter.writeArray(writer, GeomWriter::writeTuple3d, points);
    }

    private static void write(DataOutput writer, Tuple3d ... points) throws IOException {
        for (Tuple3d t : points) {
            GeomWriter.writeTuple3d(writer, t);
        }
    }

    private static void writeTuple3d(DataOutput writer, Tuple3d t) throws IOException {
        writer.writeFloat((float)t.x);
        writer.writeFloat((float)t.y);
        writer.writeFloat((float)t.z);
    }

    private static void writeTuple2dList(DataOutput writer, List<? extends Tuple2d> tcoords) throws IOException {
        GeomWriter.writeList(writer, GeomWriter::writeTuple2d, tcoords);
    }

    private static void writeTuple2d(DataOutput writer, Tuple2d p) throws IOException {
        writer.writeFloat((float)p.x);
        writer.writeFloat((float)p.y);
    }

    private static void writeArray(DataOutput writer, Tuple2d ... tcoords) throws IOException {
        GeomWriter.writeTuple2dList(writer, Arrays.asList(tcoords));
    }

    private static void writeArray(DataOutput writer, int ... vals) throws IOException {
        writer.writeInt(vals.length);
        for (int v : vals) {
            writer.writeInt(v);
        }
    }

    private static void writeBooleanList(DataOutput writer, List<Boolean> values) throws IOException {
        GeomWriter.writeList(writer, writer::writeBoolean, values);
    }

    private static void writeArray(DataOutput writer, Boolean ... vals) throws IOException {
        GeomWriter.writeArray(writer, writer::writeBoolean, vals);
    }

    private static void writeOrientList(DataOutput writer, List<Elements.Orient> orients) throws IOException {
        GeomWriter.writeList(writer, GeomWriter::writeOrient, orients);
    }

    private static void writeArray(DataOutput writer, Elements.Orient ... orients) throws IOException {
        GeomWriter.writeArray(writer, GeomWriter::writeOrient, orients);
    }

    private static void writeOrient(DataOutput writer, Elements.Orient orient) throws IOException {
        writer.writeBoolean(orient == Elements.Orient.CCW);
    }

    private static <T> void writeList(DataOutput writer, ThrowableConsumer<T> vwriter, List<T> values) throws IOException {
        writer.writeInt(values.size());
        for (T v : values) {
            vwriter.accept(v);
        }
    }

    private static <T> void writeList(DataOutput writer, ThrowableBiConsumer<DataOutput, T> vwriter, List<T> values) throws IOException {
        writer.writeInt(values.size());
        for (T v : values) {
            vwriter.accept(writer, (DataOutput)v);
        }
    }

    private static <T> void writeArray(DataOutput writer, ThrowableConsumer<T> vwriter, T ... vals) throws IOException {
        writer.writeInt(vals.length);
        for (T v : vals) {
            vwriter.accept(v);
        }
    }

    private static <T> void writeArray(DataOutput writer, ThrowableBiConsumer<DataOutput, T> vwriter, T ... vals) throws IOException {
        writer.writeInt(vals.length);
        for (T v : vals) {
            vwriter.accept(writer, (DataOutput)v);
        }
    }

    public static void write(ObjectOutput writer, IMaterial mat) throws IOException {
        writer.writeObject(mat.getAttributes());
    }

    public static void write(ObjectOutput writer, IMatAttrs attrs) throws IOException {
        GeomWriter.writeChannel(writer, attrs, MatChannel.AMBIENT);
        GeomWriter.writeTexture(writer, attrs, MatChannel.BUMP, false);
        writer.writeFloat(GeomWriter.get(attrs, IMatAttrs.BUMP_SCALE).floatValue());
        GeomWriter.writeChannel(writer, attrs, MatChannel.DIFFUSE);
        GeomWriter.writeChannel(writer, attrs, MatChannel.EMISSIVE);
        GeomWriter.writeTexture(writer, attrs, MatChannel.NORMAL, false);
        GeomWriter.writeChannel(writer, attrs, MatChannel.OPACITY, true);
        GeomWriter.writeChannel(writer, attrs, MatChannel.REFLECTION);
        GeomWriter.writeChannel(writer, attrs, MatChannel.SPECULAR);
        writer.writeFloat(GeomWriter.get(attrs, IMatAttrs.SHININESS).floatValue());
    }

    private static void writeChannel(ObjectOutput stream, IMatAttrs attrs, MatChannel chnl) throws IOException {
        GeomWriter.writeChannel(stream, attrs, chnl, false);
    }

    private static void writeChannel(ObjectOutput stream, IMatAttrs attrs, MatChannel chnl, boolean allowAdvanced) throws IOException {
        GeomWriter.write((DataOutput)stream, GeomWriter.getColor(attrs, chnl, allowAdvanced));
        GeomWriter.writeTexture(stream, attrs, chnl, false);
        stream.writeFloat((float)GeomWriter.getFade(attrs, chnl, false));
    }

    private static void writeTexture(ObjectOutput stream, IMatAttrs attrs, MatChannel chnl, boolean allowAdvanced) throws IOException {
        stream.writeObject(GeomWriter.getTexture(attrs, chnl, allowAdvanced));
    }

    public static void write(ObjectOutput stream, Texture tex) throws IOException {
        if (tex.image == null) {
            stream.writeObject(null);
        } else {
            stream.writeObject(tex.image);
            stream.writeInt(tex.mode.ordinal());
            stream.writeInt(tex.wrap.ordinal());
            if (tex.wrap.requiresBorderColor) {
                GeomWriter.write((DataOutput)stream, tex.borderColor);
            }
        }
    }

    private static Color getColor(IMatAttrs attrs, MatChannel chnl, boolean allowAdvanced) {
        if (allowAdvanced || ADVANCED_PARAMS_ENABLED) {
            return attrs.getColor(chnl);
        }
        switch (chnl) {
            case DIFFUSE: {
                return attrs.getColor(chnl);
            }
        }
        return s_defAttrs.getColor(chnl);
    }

    private static Texture getTexture(IMatAttrs attrs, MatChannel chnl, boolean allowAdvanced) {
        if (allowAdvanced || ADVANCED_PARAMS_ENABLED) {
            return attrs.getTexture(chnl);
        }
        switch (chnl) {
            case DIFFUSE: {
                return attrs.getTexture(chnl);
            }
        }
        return s_defAttrs.getTexture(chnl);
    }

    private static double getFade(IMatAttrs attrs, MatChannel chnl, boolean allowAdvanced) {
        if (allowAdvanced || ADVANCED_PARAMS_ENABLED) {
            return attrs.getFade(chnl);
        }
        switch (chnl) {
            case DIFFUSE: {
                return attrs.getFade(chnl);
            }
        }
        return s_defAttrs.getFade(chnl);
    }

    private static <T> T get(IMatAttrs attrs, IPropertySet.Prop<T> prop) {
        if (ADVANCED_PARAMS_ENABLED) {
            return attrs.get(prop);
        }
        return s_defAttrs.get(prop);
    }

    private static class ElementSources {
        public final Map<Elements.ElemProp<?>, IElemSource<?>> sublists = new HashMap();
        public final Map<String, IElemSource<Point2d>> uvsublists;

        public ElementSources(IPropertySet elements, int numPrims) {
            for (Elements.ElemProp<?> elemProp : Elements.FIXED) {
                IElemSource subset = ((IElemSource)elements.get(elemProp)).subset(0, numPrims);
                this.sublists.put(elemProp, subset);
            }
            this.uvsublists = new ListMap<String, IElemSource<Point2d>>();
            for (Map.Entry entry : elements.get(Elements.UV).entrySet()) {
                this.uvsublists.put((String)entry.getKey(), ((IElemSource)entry.getValue()).subset(0, numPrims));
            }
        }

        public ElementSources(ElementSources iterators, int begin, int length) {
            for (Elements.ElemProp<?> elemProp : Elements.FIXED) {
                IElemSource<?> subset = iterators.sublists.get(elemProp).subset(begin, length);
                this.sublists.put(elemProp, subset);
            }
            this.uvsublists = new ListMap<String, IElemSource<Point2d>>();
            for (Map.Entry entry : iterators.uvsublists.entrySet()) {
                this.uvsublists.put((String)entry.getKey(), ((IElemSource)entry.getValue()).subset(begin, length));
            }
        }

        public ElementSources sublist(int begin, int length) {
            return new ElementSources(this, begin, length);
        }

        public boolean isUniformUV() {
            return this.uvsublists.size() == 1;
        }

        public IElemSource<Point2d> getUV(String uvSet) {
            IElemSource<Point2d> result = this.uvsublists.get(uvSet);
            if (result == null && (result = this.uvsublists.get("teciuv0x193fa")) == null) {
                result = this.getFirstUV();
            }
            return result;
        }

        public IElemSource<Point2d> getUniformUV() {
            return this.uvsublists.size() == 1 ? this.uvsublists.values().iterator().next() : Elements.NO_UV;
        }

        public IElemSource<Point2d> getFirstUV() {
            return !this.uvsublists.isEmpty() ? this.uvsublists.values().iterator().next() : Elements.NO_UV;
        }

        public <T> IElemSource<T> get(Elements.ElemProp<T> prop) {
            return this.sublists.get(prop);
        }
    }

    private static interface ThrowableConsumer<T> {
        public void accept(T var1) throws IOException;
    }

    private static interface ThrowableBiConsumer<T, U> {
        public void accept(T var1, U var2) throws IOException;
    }

    private static enum ElemMapping {
        EM_PER_INDEX,
        EM_PER_FACE,
        EM_ALL_SAME,
        EM_NONE;

    }

    private static enum GeomType {
        GT_END,
        GT_POINT,
        GT_LINE_STRIP,
        GT_LINESEG,
        GT_TRIANGLE,
        GT_QUAD,
        GT_POLYGON,
        GT_MESH;

    }

    public static enum Version {
        VERSION_0000,
        VERSION_0001,
        VERSION_0002,
        VERSION_0003,
        VERSION_0004,
        VERSION_0005;


        public static Version curr() {
            return Version.values()[Version.values().length - 1];
        }
    }
}

