/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d;

import java.io.PrintStream;
import java.util.function.Consumer;

public class FPSTimer {
    private long d_updateIntervalNS;
    private double d_updateIntervalS;
    private long d_timeElapsed = 0L;
    private long d_timeStart;
    private long d_timeEnd;
    private int d_numFrames = 0;
    private Consumer<Double> d_consumer;
    private double d_fps = 0.0;

    public FPSTimer() {
        this(1.0);
    }

    public FPSTimer(double updateIntervalS) {
        this(updateIntervalS, System.out);
    }

    public FPSTimer(double updateIntervalS, PrintStream stream) {
        this(updateIntervalS, (Double fps) -> stream.println("FPS: " + fps));
    }

    public FPSTimer(double updateIntervalS, Consumer<Double> fpsConsumer) {
        this.d_updateIntervalNS = (long)(updateIntervalS * 1.0E9);
        this.d_updateIntervalS = updateIntervalS;
        this.d_consumer = fpsConsumer;
    }

    public void setConsumer(Consumer<Double> consumer) {
        this.d_consumer = consumer;
    }

    public void start() {
        ++this.d_numFrames;
        this.d_timeStart = System.nanoTime();
    }

    public void stop() {
        this.d_timeEnd = System.nanoTime();
        this.d_timeElapsed += this.d_timeEnd - this.d_timeStart;
        if (this.d_timeElapsed >= this.d_updateIntervalNS) {
            double fps = (double)this.d_numFrames * 1.0E9 / (double)this.d_timeElapsed;
            this.d_consumer.accept(fps);
            this.d_timeElapsed = 0L;
            this.d_numFrames = 0;
            this.d_fps = fps;
        }
    }

    public double getFPS() {
        return this.d_fps;
    }
}

