/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.license3;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultHighlighter;
import thunderheadeng.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.MultiLineLabel;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiProgressMonitor;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.io.CopyFile;
import thunderheadeng.io.ExampleFileFilter;
import thunderheadeng.license3.LicenseManager;
import thunderheadeng.util.OnlineLicenseReq;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.Win32Native;

public class ActivationDlg
extends guiDialog {
    private static final long serialVersionUID = -5473590092572781810L;
    public static final String LOCATION_NONE = "not_set";
    public static final String LOCATION_FILE = "file";
    public static final String LOCATION_SERVER = "server";
    public static final TypedProp<String> PROP_LOCATION = new TypedProp<String>((Object)"thunderheadeng.license3.LicenseManager.location", "not_set");
    private guiLabel d_status = null;
    private MultiLineLabel d_details = null;
    private LicenseManager d_lm = null;
    private guiRadioButton d_dirRadio;
    private guiRadioButton d_srvRadio;
    private DirChooserPanel d_dirPanel;
    private SrvChooserPanel d_srvPanel;
    private MultiLineLabel hostid = null;
    private final String d_productName;
    private final TeciProps d_prefs;
    private static final MouseListener MOUSE_TRAP = new MouseAdapter(){};

    public ActivationDlg(JFrame owner, LicenseManager lm, String productName, Icon bannerIcon, TeciProps prefs, TypedProp<String> dirPref, TypedProp<String> srvPref, Color bannerColor) {
        super((Window)owner, productName, 16);
        this.d_lm = lm;
        guiPanel panel = this.getDialogPane();
        this.d_productName = productName;
        this.d_prefs = prefs;
        TitleSeparator infoLabel = new TitleSeparator(Intl.intl("Computer Information"));
        this.hostid = new MultiLineLabel(this.d_lm.getHostIDs());
        this.hostid.setHighlighter(new DefaultHighlighter());
        ImageIcon ico1 = guiUtil.loadTeciIcon("Copy16.gif");
        JButton hostidBtn = new JButton(Intl.intl("Copy"), ico1);
        hostidBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActivationDlg.this.hostid.selectAll();
                ActivationDlg.this.hostid.copy();
            }
        });
        TitleSeparator lmLabel = new TitleSeparator(Intl.intl("License Location"));
        this.d_dirRadio = new guiRadioButton(Intl.intl("License File"));
        this.d_srvRadio = new guiRadioButton(Intl.intl("License Server"));
        this.d_dirPanel = new DirChooserPanel(this, dirPref, Intl.intl("Location:"));
        this.d_dirPanel.linkStatus(this.d_dirRadio);
        this.d_srvPanel = new SrvChooserPanel(this, srvPref, Intl.intl("Server:"));
        this.d_srvPanel.linkStatus(this.d_srvRadio);
        TitleSeparator licenseSep = new TitleSeparator(Intl.intl("Current License"));
        guiLabel status = new guiLabel(Intl.intl("Status:"));
        this.d_status = new guiLabel(Intl.intl("Not Licensed"));
        guiLabel details = new guiLabel(Intl.intl("Details:"));
        this.d_details = new MultiLineLabel("more stuff\nhere...");
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.d_dirRadio);
        bg.add(this.d_srvRadio);
        OptListener l = new OptListener();
        this.d_dirRadio.addActionListener(l);
        this.d_srvRadio.addActionListener(l);
        TopBanner banner = new TopBanner(Color.WHITE, bannerColor);
        banner.setTitle(Intl.intl("Licensing and Activation"));
        banner.setSubTitle("");
        if (bannerIcon != null) {
            banner.setIcon(bannerIcon);
        }
        panel.setLayout(new GridBagLayout());
        GridBagUtil.add(panel, banner, 0, 0, 4, 1, -12, -12, 12, -12);
        GridBagUtil.add(panel, infoLabel, 0, 1, 4, 1, 0, 0, 12, 0);
        GridBagUtil.add(panel, this.hostid, 0, 2, 3, 1, 0, 18, 12, 0, 2, 100.0, 1.0);
        GridBagUtil.add(panel, hostidBtn, 3, 2, 1, 1, 0, 0, 12, 0, 0, 1.0, 1.0);
        GridBagUtil.add(panel, lmLabel, 0, 3, 4, 1, 0, 0, 12, 0);
        guiPanel panel2 = new guiPanel();
        panel2.setLayout(new GridBagLayout());
        int r = 0;
        GridBagUtil.add(panel2, this.d_dirRadio, 0, r++, 4, 1, 0, 18, 3, 0);
        r = this.d_dirPanel.addToPanel(panel2, 4);
        GridBagUtil.add(panel2, this.d_srvRadio, 0, r++, 4, 1, 0, 18, 3, 0);
        r = this.d_srvPanel.addToPanel(panel2, r);
        GridBagUtil.add(panel, panel2, 0, 4, 4, 1, 0, 0, 0, 0);
        GridBagUtil.add(panel, licenseSep, 0, 5, 4, 1, 0, 0, 12, 0);
        guiPanel panel3 = new guiPanel();
        panel3.setLayout(new GridBagLayout());
        GridBagUtil.add(panel3, status, 0, 1, 1, 1, 0, 12, 12, 0);
        GridBagUtil.add(panel3, this.d_status, 1, 1, 1, 1, 0, 12, 12, 0, 2, 100.0, 1.0);
        GridBagUtil.add(panel3, details, 0, 2, 1, 1, 0, 12, 12, 0);
        GridBagUtil.add(panel3, this.d_details, 1, 2, 1, 1, 0, 12, 12, 0, 1, 100.0, 1.0);
        GridBagUtil.add(panel, panel3, 0, 6, 4, 1, 0, 0, 0, 0, 1, 100.0, 100.0);
        this.loadPrefs();
        String location = this.inferCurrentLicenseLocation();
        this.d_dirRadio.setSelected(LOCATION_FILE.equals(location));
        this.d_srvRadio.setSelected(LOCATION_SERVER.equals(location));
        this.updateStatus();
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        return super.validateData(showWarn, allowModify);
    }

    private void loadPrefs() {
        this.d_dirPanel.load(this.d_prefs);
        this.d_srvPanel.load(this.d_prefs);
    }

    private String inferCurrentLicenseLocation() {
        if (this.d_lm.isAuthorized()) {
            String licenseDesc = this.d_lm.getDescription();
            if (licenseDesc.toLowerCase().contains("floating")) {
                return LOCATION_SERVER;
            }
            if (licenseDesc.toLowerCase().contains("node-locked")) {
                return LOCATION_FILE;
            }
            System.err.println("Unable to infer license location from description: " + licenseDesc);
        }
        return this.d_prefs.getString(PROP_LOCATION);
    }

    private void updateStatus() {
        if (this.d_lm.isAuthorized()) {
            this.d_status.setText(Intl.intl("Licensed"));
        } else if (this.d_lm.inQueue()) {
            this.d_status.setText(Intl.intl("Licensed (Waiting in Queue)"));
        } else {
            this.d_status.setText(Intl.intl("Not Licensed"));
        }
        String desc = this.d_lm.getDescription();
        if (desc.contains("-59") && desc.contains("-142")) {
            desc = desc + "\n";
            desc = desc + Intl.intl("Floating license server too old.\nThunderhead License Manager update required.");
        }
        this.d_details.setText(desc);
        if (!this.d_lm.isAuthorized()) {
            this.d_details.setForeground(Color.RED);
        } else {
            this.d_details.setForeground(Color.BLACK);
        }
        this.pack();
        System.out.println(this.d_lm.getLicenseLocation());
    }

    private void refreshLicense(final Runnable onUpdateStatus) {
        this.setModified(true);
        this.d_status.setText(Intl.intl("Checking for License..."));
        this.d_details.setText("");
        JRootPane root = this.getRootPane();
        root.setCursor(Cursor.getPredefinedCursor(3));
        Component glass = root.getGlassPane();
        glass.addMouseListener(MOUSE_TRAP);
        glass.setVisible(true);
        Thread t = new Thread(){

            @Override
            public void run() {
                ActivationDlg.this.restartLM();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JRootPane root = ActivationDlg.this.getRootPane();
                        root.setCursor(Cursor.getDefaultCursor());
                        Component glass = root.getGlassPane();
                        glass.removeMouseListener(MOUSE_TRAP);
                        glass.setVisible(false);
                        ActivationDlg.this.updateStatus();
                        if (onUpdateStatus != null) {
                            onUpdateStatus.run();
                        }
                    }
                });
            }
        };
        t.start();
    }

    private void restartLM() {
        String loc = "";
        loc = this.d_srvRadio.isSelected() ? this.d_srvPanel.getLicenseSrv() : this.d_dirPanel.getLicenseDir();
        this.d_lm.closeLM();
        this.d_lm.startLM(loc);
    }

    @Override
    public int doModal() {
        this.setModified(false);
        int result = super.doModal();
        this.d_dirPanel.save(this.d_prefs);
        this.d_srvPanel.save(this.d_prefs);
        if (this.d_srvRadio.isSelected()) {
            this.d_prefs.set(PROP_LOCATION, LOCATION_SERVER);
        } else if (this.d_dirRadio.isSelected()) {
            this.d_prefs.set(PROP_LOCATION, LOCATION_FILE);
        }
        if (this.isModified()) {
            this.restartLM();
        }
        if (!this.d_lm.isAuthorized()) {
            JOptionPane.showMessageDialog(this.getParent(), String.format(Intl.intl("%s is not Licensed and will close."), this.d_productName), String.format(Intl.intl("%s (Unlicensed)"), this.d_productName), 0);
            EventQueue.invokeLater(() -> {
                if (Application.getApp() != null) {
                    Application.getApp().quit(false);
                }
            });
        }
        return result;
    }

    private void installLicenseFromString(String str, Runnable onUpdateStatus) {
        try {
            Calendar now = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat("yyMMddHHmmss");
            String stamp = df.format(now.getTime());
            String tmpdir = System.getProperty("java.io.tmpdir");
            File temp = new File(tmpdir, this.d_productName.toLowerCase() + stamp + ".lic");
            temp.deleteOnExit();
            PrintWriter out = new PrintWriter(temp);
            out.println(str);
            out.close();
            this.installLicenseFile(temp, onUpdateStatus);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void installLicenseFile(File chosenFile, Runnable onUpdateStatus) {
        File dir = new File(this.d_dirPanel.getLicenseDir());
        File dest = new File(this.d_dirPanel.getLicenseDir(), chosenFile.getName());
        if (!dest.exists()) {
            try {
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                CopyFile.copy(chosenFile, dest);
                this.refreshLicense(onUpdateStatus);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, Intl.intl("Could not copy license file to Local License folder."), Intl.intl("License Copy Error"), 0);
                e.printStackTrace();
            }
        }
    }

    private void installLicenseFile(Runnable onUpdateStatus) {
        guiFileChooser fileChooser = new guiFileChooser();
        ExampleFileFilter filter = new ExampleFileFilter("lic", Intl.intl("License Files"));
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setFileFilter(filter);
        fileChooser.setMustExist(true);
        int result = fileChooser.showOpenDialog(this);
        if (result != 0) {
            return;
        }
        this.installLicenseFile(fileChooser.getSelectedFile(), onUpdateStatus);
    }

    private static class TopBanner
    extends guiPanel {
        private static final long serialVersionUID = -6696244371779433758L;
        private Paint d_gradient;
        private String d_title;
        private String d_subTitle;
        private Icon d_icon;

        public TopBanner(Color c1, Color c2) {
            this.d_gradient = new GradientPaint(0.0f, 0.0f, c1, 500.0f, 0.0f, c2);
            this.setPreferredSize(new Dimension(500, 59));
            this.d_title = null;
            this.d_subTitle = null;
            this.d_icon = null;
        }

        public void setTitle(String title) {
            this.d_title = title;
        }

        public void setSubTitle(String subTitle) {
            this.d_subTitle = subTitle;
        }

        public void setIcon(Icon img) {
            this.d_icon = img;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D gfx = (Graphics2D)g;
            gfx.setPaint(this.d_gradient);
            gfx.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.d_icon != null) {
                int wid = this.d_icon.getIconWidth();
                int ht = this.d_icon.getIconHeight();
                int y = (this.getHeight() - ht) / 2;
                int x = this.getWidth() - (y > 0 ? y : 8) - wid;
                this.d_icon.paintIcon(this, gfx, x, y);
            }
            gfx.setFont(this.getFont());
            FontMetrics fMets = gfx.getFontMetrics();
            Rectangle2D mRect = fMets.getStringBounds("M", gfx);
            gfx.setColor(Color.BLACK);
            int x = (int)mRect.getWidth() * 2;
            int y = (int)mRect.getHeight() * 3 / 2;
            gfx.setFont(this.getFont().deriveFont(1));
            gfx.drawString(this.d_title, x, y);
            gfx.setFont(this.getFont());
            gfx.drawString(this.d_subTitle, x += (int)mRect.getWidth() * 2, y += (int)mRect.getHeight() * 5 / 4);
        }
    }

    private class SrvChooserPanel {
        private final TypedProp<String> d_preferenceKey;
        private final guiLabel d_label;
        private final guiTextField d_locationTF;
        private final JButton d_locationBtn;

        public SrvChooserPanel(final guiDialog parent, TypedProp<String> prefKey, String desc) {
            this.d_preferenceKey = prefKey;
            this.d_label = new guiLabel(desc);
            this.d_locationTF = new guiTextField();
            this.d_locationTF.setEditable(false);
            this.d_locationTF.setColumns(30);
            this.d_locationBtn = new JButton("Edit...");
            this.d_locationBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SrvChooserPanel.this.getServer(parent);
                }
            });
        }

        public int addToPanel(guiPanel panel, int beginRow) {
            int row = beginRow;
            GridBagUtil.add(panel, this.d_label, 0, row, 1, 1, 0, 38, 12, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(panel, this.d_locationTF, 1, row, 2, 1, 0, 0, 12, 6, 2, 1.0, 0.0, 17);
            GridBagUtil.add(panel, this.d_locationBtn, 3, row++, 1, 1, 0, 0, 12, 0, 0, 0.0, 0.0, 13);
            return row;
        }

        public void load(TeciProps prefs) {
            String loc = prefs.getString(this.d_preferenceKey);
            if (loc == null) {
                loc = "";
            }
            this.d_locationTF.setText(loc);
        }

        public void save(TeciProps prefs) {
            String loc = this.d_locationTF.getText();
            prefs.set(this.d_preferenceKey, loc);
        }

        public String getLicenseSrv() {
            return this.d_locationTF.getText();
        }

        public void linkStatus(guiRadioButton btn) {
            LinkStatus.link((AbstractButton)btn, this.d_label, this.d_locationTF, this.d_locationBtn);
        }

        public void getServer(guiDialog parent) {
            String server = "localhost";
            int port = 52100;
            String[] str = this.d_locationTF.getText().split("@", 2);
            if (str.length == 1) {
                server = str[0];
            } else {
                try {
                    port = Integer.parseInt(str[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                server = str[1];
            }
            guiDialog serverDlg = new guiDialog((Window)parent, Intl.intl("License Server"), 9);
            guiPanel panel = serverDlg.getDialogPane();
            guiLabel serverLabel = new guiLabel(Intl.intl("Server:"));
            guiLabel portLabel = new guiLabel(Intl.intl("Port:"));
            guiTextField serverName = new guiTextField(server);
            serverName.setColumns(20);
            guiIntField portNum = new guiIntField(port);
            portNum.setColumns(20);
            panel.setLayout(new GridBagLayout());
            int row = 0;
            GridBagUtil.add(panel, serverLabel, 0, row, 1, 1, 0, 0, 12, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(panel, serverName, 1, row++, 1, 1, 0, 0, 12, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(panel, portLabel, 0, row, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(panel, portNum, 1, row++, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
            int result = serverDlg.doModal();
            if (result == 1) {
                this.d_locationTF.setText(portNum.getValue() + "@" + serverName.getValue());
                ActivationDlg.this.refreshLicense(null);
            }
        }
    }

    private class DirChooserPanel {
        private TypedProp<String> d_preferenceKey;
        private final guiLabel d_label;
        private final guiTextField d_locationTF;
        private JButton d_installLicense;
        private JButton d_activationKey;

        public DirChooserPanel(guiDialog parent, TypedProp<String> prefKey, String desc) {
            this.d_label = new guiLabel(desc);
            this.d_preferenceKey = prefKey;
            this.d_locationTF = new guiTextField();
            this.d_locationTF.setEditable(false);
            this.d_locationTF.setColumns(30);
            this.d_installLicense = new JButton(Intl.intl("Local..."));
            this.d_installLicense.addActionListener(e -> ActivationDlg.this.installLicenseFile(null));
            this.d_activationKey = new JButton(Intl.intl("Online..."));
            this.d_activationKey.addActionListener(e -> {
                guiDialog onlineActivationDlg = new guiDialog((Window)parent, Intl.intl("Online Activation"), 9);
                guiTextField keyTF = new guiTextField();
                keyTF.setColumns(30);
                guiPanel pnl = new guiPanel(new GridBagLayout());
                GridBagHelper gb = new GridBagHelper(pnl);
                gb.addRow(Intl.intl("Key:"), keyTF);
                onlineActivationDlg.setDialogComponent(pnl);
                if (onlineActivationDlg.doModal() == 1) {
                    TaskProgress progress = new TaskProgress();
                    guiProgressMonitor monitor = new guiProgressMonitor(parent, Intl.intl("Loading license..."), true, progress, 0);
                    Runnable activation = () -> this.onlineActivation(keyTF, progress);
                    new Thread(activation).start();
                    monitor.begin();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onlineActivation(guiTextField keyField, TaskProgress progress) {
            Cursor oldCursor = ActivationDlg.this.getCursor();
            try {
                ActivationDlg.this.setCursor(Cursor.getPredefinedCursor(3));
                String key = keyField.getText();
                keyField.setModified(false);
                key = key.trim();
                key = key.toUpperCase();
                key = key.replaceAll("[^0-9A-F]", "");
                OnlineLicenseReq.Response resp = null;
                try {
                    try {
                        Win32Native.ProxyConfig proxyCfg = Win32Native.getProxyConfig();
                        Win32Native.setJVMDefaultProxyProps(proxyCfg);
                    }
                    catch (UnsatisfiedLinkError e) {
                        e.printStackTrace();
                    }
                    resp = OnlineLicenseReq.getAuth(key, ActivationDlg.this.d_lm.getHostID(1), ActivationDlg.this.d_lm.getEth0("000000000000"));
                }
                catch (ConnectException e) {
                    e.printStackTrace();
                    resp = new OnlineLicenseReq.Response();
                    resp.err = -10;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    resp = new OnlineLicenseReq.Response();
                    resp.license = e.getClass().getName() + ": " + e.getLocalizedMessage();
                    resp.err = -1;
                }
                if (!progress.isRunning()) {
                    return;
                }
                if (!resp.isError()) {
                    ActivationDlg.this.installLicenseFromString(resp.getLicenseString(), new AuthMessage());
                    progress.cancel();
                } else {
                    String msg = resp.getErrorString() + "\n" + Intl.intl("For additional information, please contact Thunderhead Engineering.\n");
                    if (resp.err == -10) {
                        msg = resp.getErrorString() + "\n" + Intl.intl("Your computer may be behind a proxy server. \n To activate your license, please contact Thunderhead Engineering. \nAutomated activation is available at: http://www.thunderheadeng.com/license/");
                    }
                    progress.cancel();
                    JOptionPane.showMessageDialog(ActivationDlg.this, msg, Intl.intl("Online Authorization Failed"), 1);
                }
            }
            finally {
                ActivationDlg.this.setCursor(oldCursor);
            }
        }

        public int addToPanel(guiPanel panel, int beginRow) {
            int row = beginRow;
            GridBagUtil.add(panel, this.d_label, 0, row, 1, 1, 0, 38, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(panel, this.d_locationTF, 1, row, 2, 1, 0, 0, 6, 6, 2, 0.0, 0.0, 17);
            GridBagUtil.add(panel, this.d_activationKey, 1, ++row, 1, 1, 0, -1, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(panel, this.d_installLicense, 2, row, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
            return ++row;
        }

        public void load(TeciProps prefs) {
            String loc = prefs.getString(this.d_preferenceKey);
            if (loc == null) {
                loc = "";
            }
            this.d_locationTF.setText(loc);
        }

        public void save(TeciProps prefs) {
            String loc = this.d_locationTF.getText();
            prefs.set(this.d_preferenceKey, loc);
        }

        public String getLicenseDir() {
            return this.d_locationTF.getText();
        }

        public void linkStatus(guiRadioButton btn) {
            LinkStatus.link((AbstractButton)btn, this.d_label, this.d_locationTF, this.d_installLicense, this.d_activationKey);
        }

        public void getFile(Component parent) {
            guiFileChooser fileChooser = new guiFileChooser();
            fileChooser.setFileSelectionMode(1);
            fileChooser.setMustExist(true);
            File file = new File(this.d_locationTF.getText());
            fileChooser.setCurrentDirectory(file.getParentFile());
            fileChooser.setSelectedFile(file);
            int result = fileChooser.showOpenDialog(parent);
            if (result == 0) {
                File chosenFile = fileChooser.getSelectedFile();
                this.d_locationTF.setText(chosenFile.getAbsolutePath());
                ActivationDlg.this.refreshLicense(null);
            }
        }
    }

    private class AuthMessage
    implements Runnable {
        private AuthMessage() {
        }

        @Override
        public void run() {
            if (!EventQueue.isDispatchThread()) {
                try {
                    EventQueue.invokeAndWait(this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            String msg = Intl.intl("Authorization Failed");
            if (ActivationDlg.this.d_lm.isAuthorized()) {
                int dRem = ActivationDlg.this.d_lm.getDaysRemaining();
                String strRem = dRem == 0 ? Intl.intl("Unlimited") : Integer.toString(dRem);
                msg = Intl.intl("Authorization Successful") + "\n" + String.format(Intl.intl("Days Remaining: %s"), strRem);
                ActivationDlg.this.d_dirRadio.setSelected(true);
            }
            JOptionPane.showMessageDialog(ActivationDlg.this, msg, Intl.intl("Online Authorization"), 1);
        }
    }

    private class OptListener
    implements ActionListener {
        private OptListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ActivationDlg.this.refreshLicense(null);
        }
    }
}

