/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.license2.crypkey;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import thunderheadeng.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.license2.LicenseManager;
import thunderheadeng.license2.NetworkWaitDlg;
import thunderheadeng.license2.crypkey.CrypKeyAPI;
import thunderheadeng.license2.crypkey.KillLicenseDlg;
import thunderheadeng.license2.crypkey.RegisterDlg;

public class CrypKeyLM
implements LicenseManager {
    private String d_filepath;
    private String d_masterKey;
    private String d_userKey;
    private ReadyToTryConfig d_rttc;
    private String d_currError;
    private int d_requiredLevel;
    private boolean d_firstAuth = true;
    private static final int NUM_OPTION_BITS = 25;
    private static final int NETWORK_MAX_CHECKTIME = 540;
    private static final boolean ALLOW_FLOPPY = false;
    private static final String APP_NOT_AUTHORIZED = Intl.intl("Application not authorized. Please obtain a Site Key.");
    private static final String OPTION_NOT_ALLOWED = Intl.intl("The requested operation is not authorized. It can be enabled by obtaining a new Site Key.");
    private static final String LEVEL_TOO_LOW = Intl.intl("The current license will not work with this version. Please obtain a new Site Key.");

    public CrypKeyLM(String filepath, String masterKey, String userKey, ReadyToTryConfig rttc, int reqLevel) {
        this.d_filepath = filepath;
        this.d_masterKey = masterKey;
        this.d_userKey = userKey;
        this.d_rttc = rttc;
        this.d_requiredLevel = reqLevel;
    }

    private int readyToTry(ReadyToTryConfig rttc) {
        return CrypKeyAPI.readyToTryDays(rttc.getAuthBits(), (short)rttc.getCount(), (short)rttc.getTrialVer(), (short)1);
    }

    @Override
    public final boolean startLicenseManager() {
        int allowFloppy = 0;
        int initRet = CrypKeyAPI.initCrypkey(this.d_filepath, this.d_masterKey, this.d_userKey, allowFloppy, 540);
        if (initRet != 0) {
            this.d_currError = CrypKeyAPI.explainErr(8, initRet);
            return false;
        }
        int authRet = CrypKeyAPI.getAuthorization2(1);
        if (authRet > 0) {
            NetworkWaitDlg dlg = new NetworkWaitDlg(null, this);
            dlg.doModal();
            authRet = CrypKeyAPI.getAuthorization2(0);
        }
        if (authRet != 0 && !this.isAuthorized()) {
            return false;
        }
        this.d_firstAuth = false;
        return true;
    }

    @Override
    public final void endLicenseManager() {
        CrypKeyAPI.endCrypkey();
    }

    @Override
    public final boolean isAuthorized() {
        int trialErr;
        int err = CrypKeyAPI.getAuthorization2(0);
        if (err != 0 && this.d_firstAuth && (trialErr = this.readyToTry(this.d_rttc)) != 0) {
            System.out.println(err);
            this.d_currError = CrypKeyAPI.explainErr(1, err) + " (" + CrypKeyAPI.explainErr(9, trialErr) + ")";
            return false;
        }
        if (this.d_firstAuth) {
            this.d_firstAuth = false;
            CrypKeyAPI.getAuthorization2(1);
        }
        return this.isLevelAllowed();
    }

    @Override
    public final boolean isOptionAllowed(int option) {
        if (!this.isAuthorized()) {
            return false;
        }
        int opt = CrypKeyAPI.getOption(25, option);
        if (opt == 0) {
            this.d_currError = OPTION_NOT_ALLOWED;
            return false;
        }
        if (opt == -1) {
            this.d_currError = APP_NOT_AUTHORIZED;
            return false;
        }
        return true;
    }

    public final boolean isLevelAllowed() {
        return this.isLevelAllowed(this.d_requiredLevel);
    }

    @Override
    public final boolean isLevelAllowed(int level) {
        if (this.d_firstAuth) {
            return false;
        }
        int licenseLevel = CrypKeyAPI.getLevel(25);
        if (level > licenseLevel) {
            this.d_currError = LEVEL_TOO_LOW;
            return false;
        }
        return true;
    }

    @Override
    public String getError() {
        return this.d_currError;
    }

    @Override
    public final boolean register() {
        RegisterDlg dlg = new RegisterDlg(Application.getApp().getMainFrame(), this);
        int res = dlg.doModal();
        return res == 1;
    }

    @Override
    public final boolean kill() {
        KillLicenseDlg dlg = new KillLicenseDlg(Application.getApp().getMainFrame(), this);
        dlg.doModal();
        return dlg.isKilled();
    }

    @Override
    public String getLicenseDesc() {
        int authOpt = CrypKeyAPI.getAuthOpt();
        int level = CrypKeyAPI.getLevel(25);
        int numUsers = CrypKeyAPI.getNumMultiUsers();
        String desc = Intl.intl("Current License") + ": ";
        desc = numUsers > 0 ? desc + Intl.intl("Floating,") + " " : desc + Intl.intl("Node-Locked,") + " ";
        desc = authOpt == 0 ? desc + Intl.intl("Perpetual") : (authOpt == 1 ? desc + Intl.intl("Time-Limited\nDays used") + ": " + CrypKeyAPI.getNumUsed() + "\n" + Intl.intl("Days licensed") + ": " + CrypKeyAPI.getNumAllowed() : (authOpt == 2 ? desc + Intl.intl("Runs-limited\nRuns used") + ": " + CrypKeyAPI.getNumUsed() + "\n" + Intl.intl("Runs licensed") + ": " + CrypKeyAPI.getNumAllowed() : desc + Intl.intl("None")));
        if (numUsers > 0) {
            desc = desc + "\n" + Intl.intl("Max Users") + ": " + numUsers;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(2005, 10, 5);
        cal.add(2, level);
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance(3);
        df.applyPattern("MMMM yyyy");
        desc = desc + "\n" + Intl.intl("Support Ends") + ": " + df.format(cal.getTime());
        return desc;
    }

    public static class ReadyToTryConfig {
        private int d_type;
        private int d_count;
        private int d_auth;
        private int d_trialVer;
        public static final int DAYS = 0;
        public static final int RUNS = 1;

        public ReadyToTryConfig(int type, int count, int trialVer, int authBits) {
            this.d_type = type;
            this.d_count = count;
            this.d_auth = authBits;
            this.d_trialVer = trialVer;
        }

        public boolean isDaysLimited() {
            return this.d_type == 0;
        }

        public boolean isRunsLimited() {
            return this.d_type == 1;
        }

        public int getCount() {
            return this.d_count;
        }

        public int getTrialVer() {
            return this.d_trialVer;
        }

        public int getAuthBits() {
            return this.d_auth;
        }
    }
}

