/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.legacy.v9.image;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import thunderheadeng.io.FileSystem;
import thunderheadeng.io.IOUtil;
import thunderheadeng.io.streamsrc.ByteBufferStreamSrc;
import thunderheadeng.io.streamsrc.IStreamSrc;

public class Image
implements Serializable {
    static final long serialVersionUID = 1L;
    private Integer d_version = Version.curr().ordinal();
    private int d_width;
    private int d_height;
    private String d_filename;
    private IStreamSrc d_source;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int streamVersion;
        in.defaultReadObject();
        int n = streamVersion = this.d_version == null ? Version.VERSION_0001.ordinal() : this.d_version.intValue();
        if (streamVersion < Version.VERSION_0003.ordinal()) {
            IStreamSrc src;
            boolean bufferSpecified = in.readBoolean();
            if (!bufferSpecified) {
                src = FileSystem.INSTANCE.getStreamSrc(this.d_filename, 3);
            } else {
                int length = in.readInt();
                if (streamVersion < Version.VERSION_0002.ordinal()) {
                    byte[] buffer = new byte[length];
                    in.readFully(buffer);
                    int ro = 2;
                    int go = 1;
                    int bo = 0;
                    int byteWidth = this.d_width * 3;
                    int pitch = byteWidth % 4 == 0 ? byteWidth : (byteWidth >> 2) + 1 << 2;
                    src = Image.createSrcFromLegacy(this.d_filename, buffer, this.d_width, this.d_height, pitch, ro, go, bo);
                } else {
                    ByteBuffer buffer = IOUtil.readByteBuffer(in, length, true, ByteOrder.nativeOrder());
                    src = new ByteBufferStreamSrc(buffer);
                }
            }
            this.d_source = src;
        }
        this.d_version = Version.curr().ordinal();
    }

    private static IStreamSrc createSrcFromLegacy(String filename, byte[] data, int width, int height, int pitch, int ro, int go, int bo) throws IOException {
        assert (data.length >= pitch * height);
        BufferedImage bi = new BufferedImage(width, height, 5);
        int boffset = 0;
        for (int r = 0; r < height; ++r) {
            int y = height - r - 1;
            for (int x = 0; x < width; ++x) {
                int coffset = boffset + x * 3;
                int red = data[coffset + ro] & 0xFF;
                int green = data[coffset + go] & 0xFF;
                int blue = data[coffset + bo] & 0xFF;
                int color = 0xFF000000 | red << 16 | green << 8 | blue << 0;
                bi.setRGB(x, y, color);
            }
            boffset += pitch;
        }
        byte[] compressed = thunderheadeng.image.Image.compress(bi);
        ByteBuffer bbuffer = Image.allocate(compressed.length);
        bbuffer.put(compressed);
        return new ByteBufferStreamSrc(bbuffer);
    }

    public static ByteBuffer allocate(long numBytes) {
        if (numBytes == 0L || numBytes > Integer.MAX_VALUE) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect((int)numBytes);
        buffer.order(ByteOrder.nativeOrder());
        return buffer;
    }

    public Object readResolve() throws ObjectStreamException {
        return thunderheadeng.image.Image.loadUnchecked(this.d_filename, this.d_source);
    }

    private static enum Version {
        VERSION_0000,
        VERSION_0001,
        VERSION_0002,
        VERSION_0003;


        public static Version curr() {
            return Version.values()[Version.values().length - 1];
        }
    }
}

