/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.legacy.v13.geometry.objs;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.util.theUtil;

public class GeomGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    public List<Object> children;

    private Object readResolve() throws ObjectStreamException {
        return this.convert();
    }

    public Object convert() {
        if (this.children.isEmpty()) {
            return EmptyGeom.INSTANCE;
        }
        if (this.children.stream().allMatch(o -> o instanceof IGeom)) {
            return new thunderheadeng.geometry.objs.GeomGroup(theUtil.filter(this.children, IGeom.class));
        }
        ArrayList<IGeomNode> nodes = new ArrayList<IGeomNode>();
        Predicate<Object> isGeom = o -> o instanceof IGeom;
        int m = 0;
        while (m < this.children.size()) {
            Object child = this.children.get(m);
            if (child instanceof IGeom) {
                int geomCount = theUtil.getMatchCount(this.children.subList(m, this.children.size()), isGeom);
                ArrayList<IGeom> geoms = new ArrayList<IGeom>();
                int end = m + geomCount;
                for (int n = m; n < end; ++n) {
                    geoms.add((IGeom)this.children.get(n));
                }
                nodes.add(GeomNodeUtil.newNode(GeomUtil.group(geoms)));
                m += geomCount;
                continue;
            }
            nodes.add((IGeomNode)child);
            ++m;
        }
        return GeomNodeUtil.newNode(nodes).prune();
    }
}

