/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io.streamsrc;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import thunderheadeng.io.ByteBufferInputStream;
import thunderheadeng.io.IOUtil;
import thunderheadeng.io.streamsrc.ILocalStreamSrc;
import thunderheadeng.io.streamsrc.IStreamSrc;
import thunderheadeng.util.theUtil;

public class ByteBufferStreamSrc
implements ILocalStreamSrc,
Serializable {
    private static final long serialVersionUID = 0L;
    public final transient ByteBuffer buffer;

    public ByteBufferStreamSrc(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(Version.curr().ordinal());
        out.writeBoolean(this.buffer.isDirect());
        out.writeBoolean(this.buffer.order() == ByteOrder.LITTLE_ENDIAN);
        out.writeInt(this.buffer.limit());
        IOUtil.write(out, this.buffer);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.readInt();
        boolean direct = in.readBoolean();
        boolean littleEndian = in.readBoolean();
        ByteOrder bo = littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        int bufSize = in.readInt();
        ByteBuffer bbuf = IOUtil.readByteBuffer(in, bufSize, direct, bo);
        try {
            theUtil.assignFinalField(this, ByteBufferStreamSrc.class, "buffer", bbuf);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public ByteBuffer getLocalData() {
        return this.buffer.duplicate();
    }

    @Override
    public InputStream open(int options) throws IOException {
        return new ByteBufferInputStream(this.buffer);
    }

    @Override
    public long getSize(int options) throws IOException {
        return this.buffer.capacity();
    }

    @Override
    public long getModTime() {
        return 0L;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    public void transferData(OutputStream output) throws IOException {
        IOUtil.write(output, this.buffer);
    }

    @Override
    public IStreamSrc refilter(IStreamSrc src) {
        return src;
    }

    private static enum Version {
        VERSION_0000;


        public static Version curr() {
            return Version.values()[Version.values().length - 1];
        }
    }
}

