/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io.streamsrc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import thunderheadeng.io.streamsrc.ILocalStreamSrc;
import thunderheadeng.io.streamsrc.IStreamSrc;

public class ByteArrayStreamSrc
implements ILocalStreamSrc,
Serializable {
    private static final long serialVersionUID = 0L;
    public final byte[] data;
    public final int offset;
    public final int length;

    public ByteArrayStreamSrc(byte[] data) {
        this(data, 0, data.length);
    }

    public ByteArrayStreamSrc(byte[] data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public ByteBuffer getLocalData() {
        return ByteBuffer.wrap(this.data, this.offset, this.length);
    }

    @Override
    public InputStream open(int options) throws IOException {
        return new ByteArrayInputStream(this.data, this.offset, this.length);
    }

    @Override
    public long getSize(int options) throws IOException {
        return this.length;
    }

    @Override
    public long getModTime() {
        return 0L;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    public void transferData(OutputStream output) throws IOException {
        output.write(this.data, this.offset, this.length);
    }

    @Override
    public IStreamSrc refilter(IStreamSrc src) {
        return src;
    }
}

