/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class UrlDataLoader {
    public static final X509TrustManager BLIND_TRUST_MANAGER = new BlindTrustManager();
    public static final HostnameVerifier BLIND_HOSTNAME_VERIFIER = new BlindHostnameVerifier();
    private final URL url;
    private final X509TrustManager customTrustManager;
    private final HostnameVerifier customHostnameVerifier;

    public UrlDataLoader(URL url, HostnameVerifier customHostnameVerifier, X509TrustManager customTrustManager) {
        this.url = url;
        this.customHostnameVerifier = customHostnameVerifier;
        this.customTrustManager = customTrustManager;
    }

    private URLConnection connectThroughToFinalDestination(URL intermediateUrl, int cycleLimit) throws IOException {
        if (cycleLimit <= 0) {
            throw new IOException("URL forwarding cycle detected - aborting connection: " + intermediateUrl.toString());
        }
        URLConnection conn = intermediateUrl.openConnection();
        if (conn instanceof HttpsURLConnection && this.customTrustManager != null) {
            try {
                SSLContext sc = SSLContext.getInstance("SSLv3");
                sc.init(null, new TrustManager[]{this.customTrustManager}, null);
                ((HttpsURLConnection)conn).setSSLSocketFactory(sc.getSocketFactory());
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        if (conn instanceof HttpsURLConnection && this.customHostnameVerifier != null) {
            try {
                ((HttpsURLConnection)conn).setHostnameVerifier(this.customHostnameVerifier);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        conn.connect();
        int respCode = UrlDataLoader.getResponseCode(conn);
        if (299 < respCode && respCode < 400) {
            String redirectUrl = conn.getHeaderField("Location");
            return this.connectThroughToFinalDestination(new URL(redirectUrl), cycleLimit - 1);
        }
        return conn;
    }

    public static int getResponseCode(URLConnection conn) throws IOException {
        if (conn instanceof HttpsURLConnection) {
            return ((HttpsURLConnection)conn).getResponseCode();
        }
        if (conn instanceof HttpURLConnection) {
            return ((HttpURLConnection)conn).getResponseCode();
        }
        return 200;
    }

    public String connectAndRead() throws IOException {
        URLConnection conn = this.connect();
        return this.read(conn);
    }

    public URLConnection connect() throws IOException {
        return this.connectThroughToFinalDestination(this.url, 100);
    }

    public String read(URLConnection conn) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String string = in.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    private static class BlindHostnameVerifier
    implements HostnameVerifier {
        private BlindHostnameVerifier() {
        }

        @Override
        public boolean verify(String arg0, SSLSession arg1) {
            return true;
        }
    }

    private static class BlindTrustManager
    implements X509TrustManager {
        private BlindTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

