/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class TeciLogging {
    public static void initToSplitHandler(Logger logger, Level errLevelA, Level errLevelB, Formatter fmt, PrintStream out, PrintStream err) {
        StreamHandlerWithAutoFlush outHandler = new StreamHandlerWithAutoFlush(out, fmt);
        outHandler.setLevel(errLevelA);
        outHandler.setFilter(logRecord -> logRecord.getLevel().intValue() < errLevelB.intValue());
        StreamHandlerWithAutoFlush errHandler = new StreamHandlerWithAutoFlush(err, fmt);
        errHandler.setLevel(errLevelB);
        for (Handler logHandler : logger.getHandlers()) {
            logger.removeHandler(logHandler);
        }
        logger.setLevel(errLevelA);
        logger.addHandler(outHandler);
        logger.addHandler(errHandler);
    }

    public static Formatter getDefaultLogFormat() {
        return new SimpleFormatter(){
            private static final String format = "%s %n";

            @Override
            public synchronized String format(LogRecord lr) {
                return String.format(format, lr.getMessage());
            }
        };
    }

    public static void main(String[] args) {
        TeciLogging.initToSplitHandler(Logger.getLogger(""), Level.FINE, Level.WARNING, TeciLogging.getDefaultLogFormat(), System.out, System.err);
        Logger logger = Logger.getLogger("");
        logger.log(Level.FINEST, "finest");
        logger.log(Level.FINER, "finer");
        logger.log(Level.FINE, "fine");
        logger.log(Level.CONFIG, "config");
        logger.log(Level.INFO, "info");
        logger.log(Level.WARNING, "warning");
        logger.log(Level.SEVERE, "severe");
        Logger logger2 = Logger.getLogger("foo.bar.baz");
        logger2.log(Level.FINEST, "finest");
        logger2.log(Level.FINER, "finer");
        logger2.log(Level.FINE, "fine");
        logger2.log(Level.CONFIG, "config");
        logger2.log(Level.INFO, "info");
        logger2.log(Level.WARNING, "warning");
        logger2.log(Level.SEVERE, "severe");
    }

    private static class StreamHandlerWithAutoFlush
    extends StreamHandler {
        public StreamHandlerWithAutoFlush() {
        }

        public StreamHandlerWithAutoFlush(OutputStream out, Formatter formatter) {
            super(out, formatter);
        }

        @Override
        public void publish(LogRecord lr) {
            super.publish(lr);
            this.flush();
        }
    }
}

