/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

public class TeciEncrypt {
    private static final byte[] s_header = new byte[]{-97, 35, 126, 58, -121, -82, 68, 65, 109, 28, 67, 52, -18, 89, 0, 120};
    private static final byte[] s_mask = new byte[]{79, 21, -98, 52};

    public static byte[] getHeader() {
        return s_header;
    }

    public static int getSimpleShift() {
        return 7;
    }

    public static byte[] getSimpleMask() {
        return s_mask;
    }

    public static void swap(byte[] data) {
        int count = data.length / 2;
        for (int m = 0; m < count; ++m) {
            int swapIx = data.length - m - 1;
            byte temp = data[m];
            data[m] = data[swapIx];
            data[swapIx] = temp;
        }
    }

    public static void eor(byte[] data, byte[] mask) {
        assert (data.length == mask.length);
        for (int m = 0; m < data.length; ++m) {
            int n = m;
            data[n] = (byte)(data[n] ^ mask[m]);
        }
    }

    public static void rol(byte[] data, int amount) {
        int lshift;
        for (int remaining = amount; remaining > 0; remaining -= lshift) {
            lshift = Math.min(8, remaining);
            int rshift = 8 - lshift;
            int mask = 255 << 8 - lshift;
            int prev = 0;
            for (int m = data.length - 1; m >= 0; --m) {
                int bdata = data[m] & 0xFF;
                int next = (bdata & mask) >>> rshift & 0xFF;
                data[m] = (byte)(bdata << lshift | prev);
                prev = next;
            }
            int n = data.length - 1;
            data[n] = (byte)(data[n] | prev);
        }
    }

    public static void rolInverted(byte[] data, int amount) {
        int lshift;
        for (int remaining = amount; remaining > 0; remaining -= lshift) {
            lshift = Math.min(8, remaining);
            int rshift = 8 - lshift;
            int mask = 255 << 8 - lshift;
            int prev = 0;
            for (int m = 0; m < data.length; ++m) {
                int bdata = data[m] & 0xFF;
                int next = (bdata & mask) >>> rshift & 0xFF;
                data[m] = (byte)(bdata << lshift | prev);
                prev = next;
            }
            data[0] = (byte)(data[0] | prev);
        }
    }

    public static void ror(byte[] data, int amount) {
        int rshift;
        for (int remaining = amount; remaining > 0; remaining -= rshift) {
            rshift = Math.min(8, remaining);
            int lshift = 8 - rshift;
            int mask = 255 >>> 8 - rshift;
            int prev = 0;
            for (int m = 0; m < data.length; ++m) {
                int bdata = data[m] & 0xFF;
                int next = (bdata & mask) << lshift & 0xFF;
                data[m] = (byte)(bdata >>> rshift | prev);
                prev = next;
            }
            data[0] = (byte)(data[0] | prev);
        }
    }

    public static void rorInverted(byte[] data, int amount) {
        int rshift;
        for (int remaining = amount; remaining > 0; remaining -= rshift) {
            rshift = Math.min(8, remaining);
            int lshift = 8 - rshift;
            int mask = 255 >>> 8 - rshift;
            int prev = 0;
            for (int m = data.length - 1; m >= 0; --m) {
                int bdata = data[m] & 0xFF;
                int next = (bdata & mask) << lshift & 0xFF;
                data[m] = (byte)(bdata >>> rshift | prev);
                prev = next;
            }
            int n = data.length - 1;
            data[n] = (byte)(data[n] | prev);
        }
    }

    public static enum Type {
        UNENCRYPTED(false),
        SIMPLE(true);

        public final boolean encrypted;

        private Type(boolean encrypted) {
            this.encrypted = encrypted;
        }
    }
}

