/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import thunderheadeng.io.BufferedRandomAccessFile;

public class SearchableFile
extends BufferedRandomAccessFile {
    public SearchableFile(File file, String mode) throws FileNotFoundException {
        super(file, mode);
        this.init();
    }

    public SearchableFile(String name, String mode) throws FileNotFoundException {
        super(name, mode);
        this.init();
    }

    public SearchableFile(File file, String mode, int bufferSize) throws FileNotFoundException {
        super(file, mode, bufferSize);
        this.init();
    }

    public SearchableFile(String name, String mode, int bufferSize) throws FileNotFoundException {
        super(name, mode, bufferSize);
        this.init();
    }

    private void init() {
    }

    public long findString(String find, boolean startAtBeginning) {
        int lookForIndex = 0;
        byte[] bytesToFind = find.getBytes();
        if (bytesToFind.length < 1) {
            return -1L;
        }
        try {
            if (startAtBeginning) {
                this.seek(0L);
            }
            while (true) {
                byte curByte;
                if ((curByte = this.readByte()) == bytesToFind[lookForIndex]) {
                    if (++lookForIndex != bytesToFind.length) continue;
                    return this.getFilePointer() - (long)bytesToFind.length;
                }
                if (lookForIndex == 1 && curByte == bytesToFind[lookForIndex - 1]) continue;
                lookForIndex = 0;
            }
        }
        catch (EOFException e) {
            return -1L;
        }
        catch (IOException ex) {
            return -1L;
        }
    }

    public String getNextString(long pos) {
        try {
            this.seek(pos);
        }
        catch (IOException e) {
            return null;
        }
        return this.getNextString();
    }

    public String getNextString() {
        long startPos = -1L;
        long endPos = -1L;
        try {
            while (endPos < 0L) {
                byte curByte = this.readByte();
                if (Character.isWhitespace((char)curByte)) {
                    if (startPos <= 0L) continue;
                    endPos = this.getFilePointer() - 1L;
                    continue;
                }
                if (startPos >= 0L) continue;
                startPos = this.getFilePointer() - 1L;
            }
        }
        catch (EOFException e) {
            if (startPos < 0L) {
                return null;
            }
            try {
                endPos = this.getFilePointer();
            }
            catch (IOException ex) {
                return null;
            }
        }
        catch (IOException ex) {
            return null;
        }
        try {
            if (endPos <= startPos) {
                return null;
            }
            byte[] bytesFound = new byte[(int)(endPos - startPos)];
            this.seek(startPos);
            this.readFully(bytesFound);
            String res = new String(bytesFound);
            return res.trim();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public String findStringAfter(String find, boolean startAtBeginning) {
        long pos = this.findString(find, startAtBeginning);
        if (pos < 0L) {
            return null;
        }
        return this.getNextString(pos + (long)find.length());
    }
}

