/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.function.Predicate;
import thunderheadeng.Intl;
import thunderheadeng.io.LEDataInputStream;
import thunderheadeng.io.LEDataOutputStream;
import thunderheadeng.io.streamsrc.IFilterStreamSrc;
import thunderheadeng.io.streamsrc.ILocalStreamSrc;
import thunderheadeng.io.streamsrc.IStreamSrc;
import thunderheadeng.util.Pair;

public class IOUtil {
    public static DataInput constructNativeDataInput(InputStream is) {
        return ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? new DataInputStream(is) : new LEDataInputStream(is);
    }

    public static DataOutput constructNativeDataOutput(OutputStream os) {
        return ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? new DataOutputStream(os) : new LEDataOutputStream(os);
    }

    public static void write(OutputStream out, ByteBuffer bbuffer) throws IOException {
        if ((bbuffer = bbuffer.duplicate()).hasArray()) {
            byte[] buffer = bbuffer.array();
            out.write(buffer, 0, buffer.length);
        } else {
            byte[] buffer = new byte[8192];
            while (bbuffer.hasRemaining()) {
                int toRead = Math.min(bbuffer.remaining(), buffer.length);
                bbuffer.get(buffer, 0, toRead);
                out.write(buffer, 0, toRead);
            }
        }
    }

    public static ByteBuffer readByteBuffer(InputStream in, int size, boolean direct, ByteOrder bo) throws IOException {
        if (size == -1) {
            int count;
            CustomByteArrayOutputStream baos = new CustomByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((count = in.read(buffer)) > 0) {
                baos.write(buffer, 0, count);
            }
            size = baos.getSize();
            ByteBuffer bbuffer = IOUtil.allocate(size, direct, bo);
            bbuffer.put(baos.getBuffer(), 0, size);
            bbuffer.position(0);
            return bbuffer;
        }
        ByteBuffer bbuffer = IOUtil.allocate(size, direct, bo);
        if (bbuffer.hasArray()) {
            int count;
            for (int remaining = size; remaining > 0; remaining -= count) {
                count = in.read(bbuffer.array(), 0, size);
                if (count > 0) continue;
                throw new IOException(Intl.intl("Could not read ByteBuffer."));
            }
        } else {
            byte[] buffer = new byte[8192];
            while (bbuffer.hasRemaining()) {
                int count = in.read(buffer);
                if (count <= 0) {
                    throw new IOException(Intl.intl("Could not read ByteBuffer"));
                }
                bbuffer.put(buffer, 0, count);
            }
            bbuffer.position(0);
        }
        return bbuffer;
    }

    private static ByteBuffer allocate(int size, boolean direct, ByteOrder bo) {
        ByteBuffer bbuffer = direct ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
        bbuffer.order(bo);
        return bbuffer;
    }

    public static Pair<ByteBuffer, Boolean> loadData(IStreamSrc src, int streamOptions, boolean requireDirect, ByteOrder bo) throws IOException {
        if ((streamOptions & 1) == 1) {
            while (src instanceof IFilterStreamSrc) {
                src = ((IFilterStreamSrc)src).getBaseSource();
            }
        }
        if (src instanceof ILocalStreamSrc) {
            ByteBuffer buffer = ((ILocalStreamSrc)src).getLocalData();
            if (!requireDirect || buffer.isDirect()) {
                if (buffer.order() == bo) {
                    return new Pair<ByteBuffer, Boolean>(buffer, true);
                }
                return new Pair<ByteBuffer, Boolean>(buffer.order(bo), true);
            }
        }
        InputStream is = null;
        try {
            long size = src.getSize(streamOptions);
            if (size > Integer.MAX_VALUE) {
                throw new OutOfMemoryError(Intl.intl("Data is too big to fit into memory."));
            }
            is = src.open(streamOptions);
            ByteBuffer buffer = IOUtil.readByteBuffer(is, (int)size, requireDirect, bo);
            Pair<ByteBuffer, Boolean> pair = new Pair<ByteBuffer, Boolean>(buffer, false);
            return pair;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static File resolvePath(String path, File searchRoot, Boolean isFile) {
        File file = new File(path);
        if (file.exists() && (isFile == null || isFile.booleanValue() == file.isFile())) {
            return file;
        }
        if (searchRoot.isFile()) {
            searchRoot = searchRoot.getParentFile();
        }
        String testPath = "";
        while (file != null) {
            File testFile = new File(searchRoot, testPath = testPath.isEmpty() ? file.getName() : file.getName() + File.separator + testPath);
            if (testFile.exists() && (isFile == null || isFile.booleanValue() == testFile.isFile())) {
                return testFile;
            }
            file = file.getParentFile();
        }
        return null;
    }

    public static File resolvePath2(String path, File searchRoot, Predicate<File> filter) {
        File file;
        if (searchRoot.isFile()) {
            searchRoot = searchRoot.getParentFile();
        }
        if ((file = new File(path)).exists() && filter.test(file)) {
            return file;
        }
        while (file != null) {
            File testFile = new File(searchRoot, file.getPath());
            if (testFile.exists() && filter.test(testFile)) {
                return testFile;
            }
            file = IOUtil.removeRoot(file);
        }
        return null;
    }

    private static File removeRoot(File file) {
        ArrayDeque<String> paths = new ArrayDeque<String>();
        while (file != null) {
            File parent = file.getParentFile();
            if (parent != null) {
                paths.addFirst(file.getName());
            }
            file = parent;
        }
        if (paths.isEmpty()) {
            return null;
        }
        file = new File((String)paths.removeFirst());
        while (!paths.isEmpty()) {
            file = new File(file, (String)paths.removeFirst());
        }
        return file;
    }

    public static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static PrintWriter newPrintWriterUTF8(String filename) throws IOException {
        return IOUtil.newPrintWriter(filename, Charset.forName("UTF-8"));
    }

    public static PrintWriter newPrintWriterUTF8(File f) throws IOException {
        return IOUtil.newPrintWriter(f, Charset.forName("UTF-8"));
    }

    public static PrintWriter newPrintWriter(String filename, Charset charset) throws IOException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), charset));
    }

    public static PrintWriter newPrintWriter(File file, Charset charset) throws IOException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));
    }

    public static void writeUTF8(DataOutput output, String string) throws IOException {
        IOUtil.write(output, string, StandardCharsets.UTF_8);
    }

    public static void write(DataOutput output, String string, Charset charset) throws IOException {
        byte[] bytes = string.getBytes(charset);
        output.writeInt(bytes.length);
        output.write(bytes, 0, bytes.length);
    }

    public static void main(String[] args) {
        Predicate<File> filter = o -> o.isFile();
        String path = "C:\\.\\Temp\\MultiFloorStairwell.txt";
        File f = IOUtil.resolvePath2(path, new File("C:\\Users\\okonski\\Documents"), filter);
        System.out.println(f.getAbsolutePath());
        path = "test.txt";
        f = IOUtil.resolvePath2(path, new File("D:\\okonski\\Documents\\temp"), filter);
        System.out.println(f.getAbsolutePath());
        path = "nodir\\blah\\test.txt";
        f = IOUtil.resolvePath2(path, new File("D:\\okonski\\Documents\\temp"), filter);
        System.out.println(f.getAbsolutePath());
    }

    private static class CustomByteArrayOutputStream
    extends ByteArrayOutputStream {
        private CustomByteArrayOutputStream() {
        }

        public byte[] getBuffer() {
            return this.buf;
        }

        public int getSize() {
            return this.count;
        }
    }
}

