/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.filechooser.FileFilter;
import thunderheadeng.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.io.ExampleFileFilter;
import thunderheadeng.io.MRUFileList;

public class FilenameManager {
    public static final int OPEN_FILE = 0;
    public static final int SAVE_FILE = 1;
    public static final int FORCE_PROMPT = 0;
    public static final int ALLOW_PROMPT = 1;
    public static final int NO_PROMPT = 2;
    private Hashtable d_fileTypes = new Hashtable();
    private File d_defaultFolder;
    private guiFileChooser d_chooser = null;

    public FilenameManager() {
        this(null);
    }

    public FilenameManager(File defaultDir) {
        this.d_defaultFolder = defaultDir;
    }

    public synchronized guiFileChooser getFileChooser() {
        if (this.d_chooser == null) {
            this.d_chooser = new guiFileChooser();
            if (this.d_defaultFolder != null) {
                this.d_chooser.setCurrentDirectory(this.d_defaultFolder);
            }
        }
        return this.d_chooser;
    }

    public guiFileChooser getFileChooser(String ... filters) {
        return this.getFileChooser((File)null, filters);
    }

    public guiFileChooser getFileChooser(File defaultFile, String ... filters) {
        return this.getFileChooser(null, defaultFile, filters);
    }

    public guiFileChooser getFileChooser(String title, File defaultFile, String ... filters) {
        List extensions;
        String desc;
        assert (filters.length % 2 == 0);
        guiFileChooser chooser = this.getFileChooser();
        chooser.setDialogTitle(title);
        chooser.resetChoosableFileFilters();
        ExampleFileFilter defFilter = null;
        LinkedHashMap descMap = new LinkedHashMap();
        for (int m = 0; m < filters.length; m += 2) {
            String ext = filters[m];
            desc = filters[m + 1];
            extensions = (ArrayList<String>)descMap.get(desc);
            if (extensions == null) {
                extensions = new ArrayList<String>(1);
                descMap.put(desc, extensions);
            }
            extensions.add(ext);
        }
        if (descMap.size() > 1) {
            String[] extensions2 = new String[filters.length / 2];
            for (int m = 0; m < filters.length; m += 2) {
                extensions2[m / 2] = filters[m];
            }
            ExampleFileFilter allTypesFilter = new ExampleFileFilter(extensions2, Intl.intl("All Supported Types"));
            allTypesFilter.setExtensionListInDescription(extensions2.length < 6);
            chooser.addChoosableFileFilter(allTypesFilter);
            defFilter = allTypesFilter;
        }
        for (Map.Entry entry : descMap.entrySet()) {
            desc = (String)entry.getKey();
            extensions = (List)entry.getValue();
            ExampleFileFilter filter = new ExampleFileFilter(extensions.toArray(new String[extensions.size()]), desc);
            chooser.addChoosableFileFilter(filter);
            if (defFilter != null) continue;
            defFilter = filter;
        }
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setFileFilter(defFilter);
        if (defaultFile == null) {
            defaultFile = new File("");
        }
        chooser.setSelectedFile(defaultFile);
        return chooser;
    }

    public File getOpenFile(Component parent, String ... filters) {
        return this.getOpenFile(parent, (String)null, (File)null, filters);
    }

    public File getOpenFile(Component parent, File defaultFile, String ... filters) {
        return this.getOpenFile(parent, null, defaultFile, filters);
    }

    public File getOpenFile(Component parent, String title, File defaultFile, String ... filters) {
        guiFileChooser chooser = this.getFileChooser(title, defaultFile, filters);
        if (chooser.showOpenDialog(parent) != 0) {
            return null;
        }
        return chooser.getSelectedFile();
    }

    public File getSaveFile(Component parent, String ... filters) {
        return this.getSaveFile(parent, (String)null, (File)null, filters);
    }

    public File getSaveFile(Component parent, File defaultFile, String ... filters) {
        return this.getSaveFile(parent, null, defaultFile, filters);
    }

    public File getSaveFile(Component parent, String title, File defaultFile, String ... filters) {
        guiFileChooser chooser = this.getFileChooser(title, defaultFile, filters);
        if (chooser.showSaveDialog(parent) != 0) {
            return null;
        }
        return chooser.getSelectedFile();
    }

    public static String changeExtension(String filename, String newExtension) {
        int extension = filename.lastIndexOf(46);
        String newFilename = extension > 0 ? filename.substring(0, extension) + "." + newExtension : filename + "." + newExtension;
        return newFilename;
    }

    public static String getRelativeFilename(File refFile, File targetFile, boolean refIsFile, boolean targetIsFile) {
        return FilenameManager.getRelativeFilename(refFile.getAbsolutePath(), targetFile.getAbsolutePath(), refIsFile, targetIsFile);
    }

    public static String getRelativeFilename(String refFilename, String targetFilename, boolean refIsFile, boolean targetIsFile) {
        File curr;
        if (refFilename == null || targetFilename == null) {
            return null;
        }
        File targetFile = new File(targetFilename);
        File refFile = new File(refFilename);
        String sep = File.separator;
        String path = "";
        ArrayList<File> tList = FilenameManager.getPathList(targetFile, targetIsFile);
        int tix = 0;
        File file = curr = !refIsFile ? refFile : refFile.getParentFile();
        while (curr != null) {
            int currix = tList.indexOf(curr);
            if (currix >= 0) {
                tix = currix;
                break;
            }
            curr = curr.getParentFile();
            path = path + "../";
        }
        ++tix;
        while (tix < tList.size()) {
            path = path + tList.get(tix).getName();
            path = path + sep;
            ++tix;
        }
        if (targetIsFile) {
            path = path + targetFile.getName();
        }
        return path;
    }

    public static String[] splitFilename(String fn) {
        int extix = fn.lastIndexOf(".");
        if (extix >= 0 && extix < fn.length() - 1) {
            String name = fn.substring(0, extix);
            String ext = fn.substring(extix + 1);
            return new String[]{name, ext};
        }
        return new String[]{fn, ""};
    }

    public static String getExtension(String fn) {
        return FilenameManager.splitFilename(fn)[1];
    }

    private static File asDirectory(File f) {
        return f.isDirectory() ? f : f.getParentFile();
    }

    private static ArrayList<File> getPathList(File file, boolean isFile) {
        ArrayList<File> v = new ArrayList<File>();
        if (isFile) {
            file = file.getParentFile();
        }
        while (file != null) {
            v.add(0, file);
            file = file.getParentFile();
        }
        return v;
    }

    public void addFileType(String typeName, FileFilter locateFilter) {
        this.addFileType(typeName, locateFilter, new String());
    }

    public void addFileType(String typeName, FileFilter locateFilter, String defFilename) {
        MRUFileList list = new MRUFileList();
        list.setEntryPrefix(typeName + " MRU Entry #");
        list.usedFile(defFilename);
        this.d_fileTypes.put(typeName, new Entry(locateFilter, list));
    }

    public void setFilename(String typeName, String filename) {
        Entry e = (Entry)this.d_fileTypes.get(typeName);
        if (e != null) {
            e.i_filelist.usedFile(filename);
        }
    }

    public String getFilename(String typeName) {
        Entry e = (Entry)this.d_fileTypes.get(typeName);
        if (e != null && e.i_filelist.getNumEntries() > 0) {
            return e.i_filelist.getFilename(0);
        }
        return null;
    }

    public String getFilename(String typeName, int promptOption, int operation) {
        int returnVal;
        Entry e = (Entry)this.d_fileTypes.get(typeName);
        File file = new File("");
        if (e == null) {
            return null;
        }
        if (e.i_filelist.getNumEntries() > 0 && (file = new File(e.i_filelist.getFilename(0))).exists() && promptOption != 0) {
            return file.getPath();
        }
        if (promptOption == 2) {
            return null;
        }
        guiFileChooser chooser = this.getFileChooser();
        chooser.resetChoosableFileFilters();
        chooser.addChoosableFileFilter(e.i_filter);
        if (file.exists()) {
            chooser.setSelectedFile(file);
        }
        if ((returnVal = operation == 0 ? chooser.showOpenDialog(Application.getApp().getMainFrame()) : chooser.showSaveDialog(Application.getApp().getMainFrame())) == 0) {
            e.i_filelist.usedFile(chooser.getFilename());
            return chooser.getFilename();
        }
        return null;
    }

    public void load(Properties props) {
        Object[] entries = this.d_fileTypes.values().toArray();
        for (int i = 0; i < entries.length; ++i) {
            ((Entry)entries[i]).i_filelist.load(props);
        }
    }

    public void store(Properties props) {
        Object[] entries = this.d_fileTypes.values().toArray();
        for (int i = 0; i < entries.length; ++i) {
            ((Entry)entries[i]).i_filelist.store(props);
        }
    }

    public static boolean equal(File f1, File f2) {
        try {
            f1 = f1.getCanonicalFile();
            f2 = f2.getCanonicalFile();
            return f1.equals(f2);
        }
        catch (IOException e) {
            return f1.equals(f2);
        }
    }

    private class Entry {
        public FileFilter i_filter;
        public MRUFileList i_filelist;

        Entry(FileFilter filter, MRUFileList filelist) {
            this.i_filter = filter;
            this.i_filelist = filelist;
        }
    }
}

