/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import thunderheadeng.io.IFileSystem;
import thunderheadeng.io.streamsrc.DecryptStreamSrc;
import thunderheadeng.io.streamsrc.IFileSrc;
import thunderheadeng.io.streamsrc.IStreamSrc;

public class FileSystem
implements IFileSystem,
Serializable {
    private static final long serialVersionUID = 0L;
    public static final IFileSystem INSTANCE = new FileSystem();

    protected static boolean test(int options, int option) {
        return (options & option) == option;
    }

    @Override
    public InputStream open(String filename, boolean buffered) throws IOException, FileNotFoundException {
        return new FileInputStream(filename);
    }

    @Override
    public long getSize(String filename) throws IOException, FileNotFoundException {
        return new File(filename).length();
    }

    @Override
    public IStreamSrc getStreamSrc(String filename, int options) {
        boolean buffered = FileSystem.test(options, 2);
        IStreamSrc src = new FileSrc(this, filename, buffered);
        if (FileSystem.test(options, 1)) {
            src = new DecryptStreamSrc(src);
        }
        return src;
    }

    @Override
    public long getModTime(String filename) {
        return new File(filename).lastModified();
    }

    @Override
    public void transferData(String filename, boolean buffer, OutputStream os) throws IOException {
        OutputStream out = os;
        if (buffer && !(out instanceof BufferedOutputStream)) {
            out = new BufferedOutputStream(os);
        }
        byte[] buf = new byte[8192];
        InputStream in = new FileInputStream(filename);
        try {
            int count;
            if (buffer) {
                in = new BufferedInputStream(in);
            }
            while ((count = in.read(buf)) > 0) {
                out.write(buf, 0, count);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        if (out != os) {
            out.flush();
        }
    }

    protected static class FileSrc
    implements IFileSrc,
    Serializable {
        private static final long serialVersionUID = 0L;
        public final String filename;
        public final IFileSystem fileSystem;
        public final boolean buffered;

        public FileSrc(IFileSystem fs, String filename, boolean buffered) {
            this.fileSystem = fs;
            this.filename = filename;
            this.buffered = buffered;
        }

        @Override
        public String getFilename() {
            return this.filename;
        }

        @Override
        public IFileSystem getFileSystem() {
            return this.fileSystem;
        }

        @Override
        public boolean isBuffered() {
            return this.buffered;
        }

        @Override
        public InputStream open(int options) throws IOException {
            return this.fileSystem.open(this.filename, this.buffered);
        }

        @Override
        public long getSize(int options) throws IOException {
            return this.fileSystem.getSize(this.filename);
        }

        @Override
        public long getModTime() {
            return this.fileSystem.getModTime(this.filename);
        }

        @Override
        public boolean isLocal() {
            return false;
        }

        public void transferData(OutputStream output) throws IOException {
            this.fileSystem.transferData(this.filename, this.buffered, output);
        }

        @Override
        public IStreamSrc refilter(IStreamSrc src) {
            return src;
        }
    }
}

