/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import thunderheadeng.Intl;
import thunderheadeng.io.TeciEncrypt;

public class DecryptInputStream
extends InputStream
implements Closeable {
    private final InputStream d_stream;
    private final TeciEncrypt.Type d_type;
    private final long d_dataLen;
    private DecryptData d_data;
    private DecryptData d_markedData;

    public static boolean isEncryped(InputStream stream) {
        if (!stream.markSupported()) {
            return false;
        }
        try {
            Header header = DecryptInputStream.readHeader(stream, true);
            return header.type.encrypted;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static Header getEncryptionHeader(InputStream stream) {
        if (!stream.markSupported()) {
            return null;
        }
        try {
            return DecryptInputStream.readHeader(stream, true);
        }
        catch (IOException e) {
            return null;
        }
    }

    public DecryptInputStream(InputStream stream) throws IOException {
        this.d_stream = !stream.markSupported() ? new BufferedInputStream(stream) : stream;
        Header header = DecryptInputStream.readHeader(this.d_stream, false);
        this.d_type = header != null ? header.type : TeciEncrypt.Type.UNENCRYPTED;
        this.d_dataLen = header != null ? header.dataLen : 0L;
        int bufLen = 0;
        switch (this.d_type) {
            case SIMPLE: {
                bufLen = 4;
            }
        }
        this.d_data = new DecryptData(bufLen);
        this.d_markedData = null;
    }

    @Override
    public void close() throws IOException {
        this.d_stream.close();
    }

    public TeciEncrypt.Type getType() {
        return this.d_type;
    }

    @Override
    public boolean markSupported() {
        return this.d_stream.markSupported();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.d_markedData = this.d_data.clone();
        this.d_stream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.d_markedData == null) {
            throw new IOException(Intl.intl("DecryptInputStream.reset() was called when stream was not previously marked."));
        }
        this.d_data = this.d_markedData.clone();
        this.d_stream.reset();
    }

    @Override
    public int available() throws IOException {
        return Math.min((int)Math.min(Integer.MAX_VALUE, this.d_dataLen - this.d_data.readPos), this.d_stream.available());
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        if (!this.d_type.encrypted) {
            return this.d_stream.skip(n);
        }
        if (this.d_data.readPos + n > this.d_dataLen) {
            n = this.d_dataLen - this.d_data.readPos;
        }
        long remaining = (this.d_data.readPos + n) % (long)this.d_data.buffer.length;
        long skipAmount = n - remaining;
        long skipped = this.d_stream.skip(skipAmount);
        this.d_data.readPos += skipped;
        if (skipped < skipAmount) {
            throw new IOException(Intl.intl("Stream could not be skipped by expected amount."));
        }
        if (remaining > 0L) {
            assert (this.d_data.readPos < this.d_dataLen);
            this.decrypt();
            this.d_data.readPos += remaining;
        }
        return n;
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        this.read(buf);
        return buf[0];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.d_type == TeciEncrypt.Type.UNENCRYPTED) {
            return this.d_stream.read(b, off, len);
        }
        if ((len = (int)Math.min(this.d_dataLen - this.d_data.readPos, (long)len)) == 0) {
            return -1;
        }
        int remaining = len;
        while (remaining > 0) {
            this.decrypt();
            int decryptRemaining = (int)(this.d_data.decryptEnd - this.d_data.readPos);
            int toRead = Math.min(remaining, decryptRemaining);
            int bufPos = (int)(this.d_data.readPos - this.d_data.decryptStart);
            System.arraycopy(this.d_data.buffer, bufPos, b, off, toRead);
            this.d_data.readPos += (long)toRead;
            remaining -= toRead;
            off += toRead;
        }
        return len;
    }

    protected void decrypt() throws IOException {
        if (this.d_data.readPos >= this.d_data.decryptStart && this.d_data.readPos < this.d_data.decryptEnd) {
            return;
        }
        long boundary = this.d_data.buffer.length;
        long newDecryptPos = this.d_data.readPos / boundary * boundary;
        this.d_stream.read(this.d_data.buffer);
        switch (this.d_type) {
            case SIMPLE: {
                int shift = TeciEncrypt.getSimpleShift();
                byte[] mask = TeciEncrypt.getSimpleMask();
                TeciEncrypt.eor(this.d_data.buffer, mask);
                TeciEncrypt.rorInverted(this.d_data.buffer, shift);
            }
        }
        this.d_data.decryptStart = newDecryptPos;
        this.d_data.decryptEnd = this.d_data.decryptStart + (long)this.d_data.buffer.length;
    }

    protected static Header readHeader(InputStream stream, boolean resetToBegin) throws IOException {
        assert (stream.markSupported());
        byte[] header = TeciEncrypt.getHeader();
        stream.mark(header.length + 4);
        try {
            DataInputStream ds;
            int type;
            byte[] readHeader = new byte[header.length];
            int amountRead = stream.read(readHeader);
            if (amountRead == header.length && Arrays.equals(header, readHeader) && (type = (ds = new DataInputStream(stream)).readInt()) < TeciEncrypt.Type.values().length) {
                long dataLen = ds.readLong();
                if (resetToBegin) {
                    stream.reset();
                }
                return new Header(TeciEncrypt.Type.values()[type], dataLen);
            }
        }
        catch (IOException e) {
            stream.reset();
            throw e;
        }
        stream.reset();
        return new Header(TeciEncrypt.Type.UNENCRYPTED, 0L);
    }

    protected static class DecryptData
    implements Cloneable {
        public byte[] buffer;
        public long readPos;
        public long decryptStart;
        public long decryptEnd;

        public DecryptData(int bufSize) {
            this.buffer = new byte[bufSize];
            this.readPos = 0L;
            this.decryptEnd = 0L;
            this.decryptStart = 0L;
        }

        public DecryptData clone() {
            try {
                DecryptData clone = (DecryptData)super.clone();
                clone.buffer = Arrays.copyOf(this.buffer, this.buffer.length);
                return clone;
            }
            catch (Throwable t) {
                return null;
            }
        }
    }

    public static class Header {
        public final TeciEncrypt.Type type;
        public final long dataLen;

        public Header(TeciEncrypt.Type type, long dataLen) {
            this.type = type;
            this.dataLen = dataLen;
        }
    }
}

