/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.io.IOUtil;

public class CopyFile {
    public static void copy(File src, File dest) throws IOException {
        CopyFile.copyFileChannel(src, dest, src.length());
    }

    public static void copyFileStream(File src, File dest) throws IOException {
        CopyFile.copyFileStream(src, dest, 0x200000);
    }

    public static void copyFileStream(File src, File dest, int buffSize) throws IOException {
        if (FilenameManager.equal(src, dest)) {
            return;
        }
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dest);
        byte[] buff = new byte[buffSize];
        int i = in.read(buff);
        while (i != -1) {
            out.write(buff, 0, i);
            i = in.read(buff);
        }
        in.close();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileChannel(File src, File dest, long buffSize) throws IOException {
        if (FilenameManager.equal(src, dest)) {
            return;
        }
        FileInputStream srcStrm = null;
        FileOutputStream destStrm = null;
        try {
            srcStrm = new FileInputStream(src);
            destStrm = new FileOutputStream(dest);
            FileChannel srcChan = srcStrm.getChannel();
            FileChannel destChan = destStrm.getChannel();
            long size = srcChan.size();
            for (long position = 0L; position < size; position += srcChan.transferTo(position, buffSize, destChan)) {
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeSilently(srcStrm);
            IOUtil.closeSilently(destStrm);
            throw throwable;
        }
        IOUtil.closeSilently(srcStrm);
        IOUtil.closeSilently(destStrm);
    }
}

