/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer d_buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.d_buffer = buffer.duplicate();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.d_buffer.mark();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.d_buffer.reset();
    }

    @Override
    public int available() throws IOException {
        return this.d_buffer.remaining();
    }

    @Override
    public int read() throws IOException {
        if (this.d_buffer.remaining() == 0) {
            return -1;
        }
        return this.d_buffer.get();
    }

    @Override
    public int read(byte[] b) throws IOException {
        int remaining = this.d_buffer.remaining();
        if (remaining == 0) {
            return -1;
        }
        int toRead = Math.min(remaining, b.length);
        this.d_buffer.get(b, 0, toRead);
        return toRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int remaining = this.d_buffer.remaining();
        if (remaining == 0) {
            return -1;
        }
        int toRead = Math.min(remaining, len);
        this.d_buffer.get(b, off, toRead);
        return toRead;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            return 0L;
        }
        int remaining = this.d_buffer.remaining();
        int toSkip = Math.min(remaining, (int)Math.min(Integer.MAX_VALUE, n));
        this.d_buffer.position(this.d_buffer.position() + toSkip);
        return toSkip;
    }
}

