/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.ImageIO;
import thunderheadeng.image.HashableImage;
import thunderheadeng.image.IImage;
import thunderheadeng.image.ImageInfo;
import thunderheadeng.image.ImageManager;
import thunderheadeng.io.FileSystem;
import thunderheadeng.io.streamsrc.IStreamSrc;

public class Image
implements Serializable,
IImage {
    static final long serialVersionUID = 1L;
    private final String d_filename;
    private final IInfo d_iinfo;
    private final IStreamSrc d_source;

    protected Image(String filename, IStreamSrc source, IInfo info) {
        this.d_filename = filename;
        this.d_iinfo = info;
        this.d_source = source;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public String getFilename() {
        return this.d_filename;
    }

    @Override
    public int getHeight() {
        return this.d_iinfo.height;
    }

    @Override
    public int getWidth() {
        return this.d_iinfo.width;
    }

    @Override
    public boolean hasTransparency() {
        return this.d_iinfo.hasTransparency;
    }

    @Override
    public int getBitsPerPixel() {
        return this.d_iinfo.bpp;
    }

    @Override
    public IStreamSrc getSource() {
        return this.d_source;
    }

    public static Image loadUnchecked(String key, IStreamSrc source) {
        IInfo ii = null;
        try {
            ii = Image.retrieveImageInfo(source);
        }
        catch (IOException e) {
            ii = new IInfo();
        }
        return new Image(key, source, ii);
    }

    public static Image load(String key, IStreamSrc source) throws IOException {
        IInfo info = Image.retrieveImageInfo(source);
        return new Image(key, source, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IInfo retrieveImageInfo(IStreamSrc src) throws IOException {
        InputStream is = null;
        try {
            is = src.open(0);
            ImageInfo ii = new ImageInfo();
            ii.setInput(is);
            if (!ii.check()) {
                IInfo iInfo = new IInfo();
                return iInfo;
            }
            IInfo iInfo = new IInfo(ii.getWidth(), ii.getHeight(), ii.getBitsPerPixel(), ii.hasTransparency());
            return iInfo;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static byte[] compress(BufferedImage img) throws IOException {
        CustomByteArrayOutputStream baos = new CustomByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "PNG", baos);
        return baos.toByteArray();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(Version.curr().ordinal());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        IStreamSrc src;
        Image existing;
        HashableImage himage;
        in.defaultReadObject();
        in.readInt();
        if (this.d_filename != null && new File(this.d_filename).exists() && (himage = new HashableImage(this)).equals(existing = Image.loadUnchecked(this.d_filename, src = FileSystem.INSTANCE.getStreamSrc(this.d_filename, 3)))) {
            ImageManager.registerImage(this.d_filename, this);
        }
    }

    public static ByteBuffer allocate(long numBytes) {
        if (numBytes == 0L || numBytes > Integer.MAX_VALUE) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect((int)numBytes);
        buffer.order(ByteOrder.nativeOrder());
        return buffer;
    }

    protected static class IInfo
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final int width;
        public final int height;
        public final int bpp;
        public final boolean hasTransparency;

        public IInfo() {
            this(0, 0, 0, false);
        }

        public IInfo(int width, int height, int bitsPerPixel, boolean hasTransparency) {
            this.width = width;
            this.height = height;
            this.bpp = bitsPerPixel;
            this.hasTransparency = hasTransparency;
        }
    }

    private static class CustomByteArrayOutputStream
    extends ByteArrayOutputStream {
        private CustomByteArrayOutputStream() {
        }

        public byte[] getBuffer() {
            return this.buf;
        }

        public int getSize() {
            return this.count;
        }
    }

    private static enum Version {
        VERSION_0000;


        public static Version curr() {
            return Version.values()[Version.values().length - 1];
        }
    }
}

