/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.image;

import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.ImageIO;
import thunderheadeng.image.HashableImage;
import thunderheadeng.image.Image;
import thunderheadeng.io.IOUtil;
import thunderheadeng.io.streamsrc.ByteBufferStreamSrc;
import thunderheadeng.io.streamsrc.IStreamSrc;

public interface IImage {
    default public boolean isCached() {
        return this.getSource().isLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean isValid() {
        if (this.isCached()) {
            return true;
        }
        InputStream is = null;
        try {
            is = this.getSource().open(0);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    default public IImage cacheImage() {
        if (this.isCached()) {
            return this;
        }
        try {
            ByteBuffer data = (ByteBuffer)IOUtil.loadData((IStreamSrc)this.getSource(), (int)1, (boolean)true, (ByteOrder)ByteOrder.nativeOrder()).v1;
            IStreamSrc newSrc = this.getSource().refilter(new ByteBufferStreamSrc(data));
            return Image.loadUnchecked(this.getFilename(), newSrc);
        }
        catch (IOException e) {
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public BufferedImage toBufferedImage() {
        InputStream is = null;
        try {
            is = this.getSource().open(0);
            BufferedImage bufferedImage = ImageIO.read(is);
            return bufferedImage;
        }
        catch (IOException | IllegalArgumentException e) {
            e.printStackTrace();
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean save(String name, int streamOptions) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(name);
            this.save(os, streamOptions);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void save(OutputStream os, int streamOptions) throws IOException {
        IStreamSrc source = this.getSource();
        byte[] tbuf = new byte[8192];
        try (InputStream is = source.open(streamOptions);){
            int count;
            while ((count = is.read(tbuf)) > 0) {
                os.write(tbuf, 0, count);
            }
        }
    }

    default public HashableImage makeHashable() {
        return new HashableImage(this);
    }

    public String getFilename();

    public int getHeight();

    public int getWidth();

    public boolean hasTransparency();

    public int getBitsPerPixel();

    public IStreamSrc getSource();
}

