/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.image;

import java.io.IOException;
import thunderheadeng.image.IImage;
import thunderheadeng.image.IImageCreator;
import thunderheadeng.image.Image;
import thunderheadeng.io.IFileSystem;
import thunderheadeng.io.streamsrc.IStreamSrc;

public class FileImageCreator
implements IImageCreator {
    public static final int OPT_CACHE_IMAGE_DATA = 2;
    private final IFileSystem d_fileSystem;
    private final int d_options;
    private final int d_fsOptions;

    public FileImageCreator(IFileSystem fileSystem, int options, int fsOptions) {
        this.d_fileSystem = fileSystem;
        this.d_options = options;
        this.d_fsOptions = fsOptions;
    }

    public int getOptions() {
        return this.d_options;
    }

    protected boolean opt(int option) {
        return (this.d_options & option) == option;
    }

    @Override
    public IImage create(String id) {
        try {
            IStreamSrc src = this.d_fileSystem.getStreamSrc(id, this.d_fsOptions);
            IImage img = Image.load(id, src);
            if (this.opt(2)) {
                img = img.cacheImage();
            }
            return img;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

