/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.tool;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.EventListener;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import thunderheadeng.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.DecoratedIcon;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.tool.DefaultDeviceMgr;
import thunderheadeng.gui.tool.IDeviceListener;
import thunderheadeng.gui.tool.IDeviceManager;
import thunderheadeng.gui.tool.IToolListener;
import thunderheadeng.gui.tool.PropertyEditor;
import thunderheadeng.gui.tool.SwingKeyboard;
import thunderheadeng.gui.tool.SwingMouse;
import thunderheadeng.gui.tool.Tool;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;

public class ToolManager
implements IToolListener {
    private final Component d_target;
    private Tool d_currentTool;
    private final ToolPropsAction d_propsAction;
    private final ButtonGroup d_toolbarGroup;
    private final ButtonGroup d_menuGroup;
    private final Map<Tool, ToolProps> d_tools;
    private final ToolActivatedListener d_toolListener;
    private final DefaultDeviceMgr d_devices;
    private final EventDispatcher d_eventDispatcher;
    private final FocusListener d_focusListener;
    private final Deque<ToolMode> d_toolStack;
    private final Set<ToolChangeListener> d_toolChangeListeners;
    private static final ImageIcon s_stickyIcon = guiUtil.loadTeciIcon("pin.png");

    public ToolManager(Component target) {
        this.d_target = target;
        this.d_tools = new IdentityHashMap<Tool, ToolProps>();
        this.d_propsAction = new ToolPropsAction();
        this.d_toolbarGroup = new ButtonGroup();
        this.d_menuGroup = new ButtonGroup();
        this.d_toolListener = new ToolActivatedListener();
        this.d_devices = new DefaultDeviceMgr(new SwingKeyboard(), new SwingMouse());
        this.d_eventDispatcher = new EventDispatcher(this.d_devices);
        this.d_toolChangeListeners = new LinkedIdentityHashSet<ToolChangeListener>();
        this.d_toolStack = new ArrayDeque<ToolMode>();
        this.d_focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                ToolManager.this.getDevices().getKeyboard().clearPressedKeys();
                ToolManager.this.d_eventDispatcher.clearPressedKeys();
            }
        };
    }

    public IDeviceManager getDevices() {
        return this.d_devices;
    }

    public void addToolChangeListener(ToolChangeListener listener) {
        this.d_toolChangeListeners.add(listener);
    }

    public void removeToolChangeListener(ToolChangeListener listener) {
        this.d_toolChangeListeners.remove(listener);
    }

    public void addTool(Tool t, String name, String toolTip, Icon icon) {
        this.addTool(t, name, toolTip, icon, false, null);
    }

    public void addTool(Tool t, String name, String toolTip, Icon icon, boolean modal, Object customData) {
        ToolAction action = new ToolAction(t, name, toolTip, icon);
        action.addPropertyChangeListener(this.d_toolListener);
        JToggleButton btn = this.createToolbarBtn(t, action);
        JRadioButtonMenuItem menuItem = this.createRadioItem(t, action);
        ToolProps stuff = new ToolProps(action, btn, menuItem, modal, customData);
        this.d_tools.put(t, stuff);
    }

    public Collection<Tool> getTools() {
        return this.d_tools.keySet();
    }

    public void removeTool(Tool t) {
        ToolProps data;
        if (t == this.d_currentTool) {
            this.setCurrentTool(null);
        }
        if ((data = this.d_tools.remove(t)) != null) {
            if (data.menuItem != null) {
                this.d_menuGroup.remove(data.menuItem);
            }
            if (data.toolbarBtn != null) {
                this.d_toolbarGroup.remove(data.toolbarBtn);
            }
        }
    }

    private JToggleButton createToolbarBtn(Tool t, ToolAction a) {
        JToggleButton toolBtn = new JToggleButton(a);
        if (a.getIcon() != null) {
            toolBtn.setText("");
        }
        this.d_toolbarGroup.add(toolBtn);
        toolBtn.addPropertyChangeListener(a);
        return toolBtn;
    }

    private JRadioButtonMenuItem createRadioItem(Tool t, ToolAction a) {
        JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(a);
        this.d_menuGroup.add(menuItem);
        menuItem.addPropertyChangeListener(a);
        return menuItem;
    }

    public ToolAction getToolAction(Tool t) {
        ToolProps s = this.d_tools.get(t);
        if (s != null) {
            return s.action;
        }
        return null;
    }

    public AbstractButton getToolbarButton(Tool t) {
        ToolProps s = this.d_tools.get(t);
        if (s != null) {
            return s.toolbarBtn;
        }
        return null;
    }

    public JMenuItem getMenuItem(Tool t) {
        ToolProps s = this.d_tools.get(t);
        if (s != null) {
            return s.menuItem;
        }
        return null;
    }

    public void setCurrentTool(Tool t) {
        this.setCurrentTool(t, false);
    }

    public void setCurrentTool(Tool t, boolean temporary) {
        this.setCurrentTool(t, true, false, !temporary);
    }

    public void repaintTarget() {
        this.d_target.repaint();
    }

    public Tool getCurrentTool() {
        return this.d_currentTool;
    }

    public Tool getRootTool() {
        return this.d_toolStack.isEmpty() ? this.d_currentTool : this.d_toolStack.getLast().tool;
    }

    public Action getToolPropsAction() {
        return this.d_propsAction;
    }

    protected void setCurrentTool(Tool t, boolean notifyAction, boolean forceSticky, boolean cancelStack) {
        boolean toolModal;
        if (t == this.d_currentTool) {
            return;
        }
        Tool oldTool = this.d_currentTool;
        this.d_currentTool = t;
        boolean bl = toolModal = this.d_currentTool != null ? this.getProps((Tool)this.d_currentTool).modal : false;
        if (cancelStack) {
            int minStackSize;
            int n = minStackSize = toolModal ? 1 : 0;
            while (this.d_toolStack.size() > minStackSize) {
                ToolMode tm = this.d_toolStack.pop();
                tm.tool.removeToolListener(this);
                tm.tool.cancel();
                tm.tool.addToolListener(this);
                tm.end();
            }
        }
        if (this.d_currentTool != null) {
            boolean stickyMod = toolModal;
            boolean sticky = forceSticky || !toolModal;
            ToolMode tm = new ToolMode(this.d_currentTool, sticky, stickyMod);
            this.d_toolStack.push(tm);
            tm.begin();
        }
        for (ToolChangeListener listener : this.d_toolChangeListeners) {
            listener.toolWillChanged(oldTool, this.d_currentTool);
        }
        if (oldTool != null) {
            oldTool.removeToolListener(this);
            if (this.d_target != null) {
                this.d_target.removeMouseMotionListener(this.d_eventDispatcher);
                this.d_target.removeMouseListener(this.d_eventDispatcher);
                this.d_target.removeKeyListener(this.d_eventDispatcher);
                this.d_target.removeMouseWheelListener(this.d_eventDispatcher);
                this.d_target.removeFocusListener(this.d_focusListener);
                this.d_eventDispatcher.setTool(null);
            }
            oldTool.deactivate();
            this.getToolAction(oldTool).setSelected(false);
        }
        this.d_propsAction.setEnabled(this.d_currentTool instanceof PropertyEditor);
        if (this.d_currentTool != null) {
            this.d_currentTool.activate();
            if (notifyAction) {
                this.getToolAction(this.d_currentTool).setSelected(true);
            }
            if (this.d_target != null) {
                this.d_eventDispatcher.setTool(this.d_currentTool);
                this.d_target.addMouseMotionListener(this.d_eventDispatcher);
                this.d_target.addMouseListener(this.d_eventDispatcher);
                this.d_target.addKeyListener(this.d_eventDispatcher);
                this.d_target.addMouseWheelListener(this.d_eventDispatcher);
                this.d_target.addFocusListener(this.d_focusListener);
            }
            this.d_currentTool.addToolListener(this);
            this.d_currentTool.repaintSurface();
        }
    }

    public ToolProps getProps(Tool tool) {
        return this.d_tools.get(tool);
    }

    public void enableTool(Tool tool, boolean enable) {
        this.getToolAction(tool).setEnabled(enable);
        if (!enable && this.getCurrentTool() == tool) {
            assert (!this.d_toolStack.isEmpty());
            this.setCurrentTool(this.d_toolStack.getLast().tool, false);
        }
    }

    @Override
    public void toolEnded(Tool tool, boolean cancelled) {
        if (this.d_toolStack.size() <= 1 || !cancelled && this.d_toolStack.peek().isSticky()) {
            return;
        }
        ToolMode finishedTool = this.d_toolStack.pop();
        assert (finishedTool.tool == tool);
        finishedTool.end();
        ToolMode nextTool = this.d_toolStack.pop();
        boolean nextToolSticky = nextTool.isSticky();
        nextTool.end();
        this.setCurrentTool(nextTool.tool, true, nextToolSticky, false);
    }

    public void cancelCurrentTool() {
        Tool tool = this.getCurrentTool();
        if (tool != null) {
            tool.cancel();
        }
    }

    public void setDeviceIntercept(IDeviceListener ilistener) {
        this.d_eventDispatcher.setIntercept(ilistener);
    }

    private static class ChainedDeviceListener
    implements IDeviceListener {
        private final List<EventListener> d_listeners;

        public ChainedDeviceListener(EventListener ... listeners) {
            this(Arrays.asList(listeners));
        }

        public ChainedDeviceListener(List<EventListener> listeners) {
            this.d_listeners = listeners;
        }

        private <T> Collection<T> filter(Class<T> type) {
            return theUtil.filter(this.d_listeners, type);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            for (MouseMotionListener listener : this.filter(MouseMotionListener.class)) {
                listener.mouseDragged(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            for (MouseMotionListener listener : this.filter(MouseMotionListener.class)) {
                listener.mouseMoved(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            for (MouseListener listener : this.filter(MouseListener.class)) {
                listener.mouseClicked(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            for (MouseListener listener : this.filter(MouseListener.class)) {
                listener.mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            for (MouseListener listener : this.filter(MouseListener.class)) {
                listener.mouseReleased(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            for (MouseListener listener : this.filter(MouseListener.class)) {
                listener.mouseEntered(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            for (MouseListener listener : this.filter(MouseListener.class)) {
                listener.mouseExited(e);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            for (KeyListener listener : this.filter(KeyListener.class)) {
                listener.keyTyped(e);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            for (KeyListener listener : this.filter(KeyListener.class)) {
                listener.keyPressed(e);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            for (KeyListener listener : this.filter(KeyListener.class)) {
                listener.keyReleased(e);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            for (MouseWheelListener listener : this.filter(MouseWheelListener.class)) {
                listener.mouseWheelMoved(e);
            }
        }
    }

    protected static class EventDispatcher
    implements IDeviceListener {
        private final IDeviceManager d_devcMgr;
        private final Set<Integer> d_pressedKeys;
        private final Set<Integer> d_pressedBtns;
        private IDeviceListener d_intercept;
        private Tool d_tool;
        private IDeviceListener d_eventListener;
        private IDeviceListener d_devicesListener;

        private EventDispatcher(IDeviceManager devcMgr) {
            this.d_devcMgr = devcMgr;
            this.d_pressedKeys = new HashSet<Integer>();
            this.d_pressedBtns = new HashSet<Integer>();
        }

        private static boolean isEnabled(ComponentEvent e) {
            Application app = Application.getApp();
            if (app == null) {
                return true;
            }
            return !app.isInputBlocking(e.getComponent());
        }

        public void setIntercept(IDeviceListener intercept) {
            this.d_intercept = intercept;
            this.updateListener();
        }

        public void setTool(Tool tool) {
            this.d_tool = tool;
            this.updateListener();
            this.d_pressedKeys.clear();
            this.d_pressedBtns.clear();
        }

        private void updateListener() {
            ArrayList<EventListener> eventListeners = new ArrayList<EventListener>();
            ArrayList<EventListener> deviceListeners = new ArrayList<EventListener>();
            BiConsumer<Object, List> add = (o, l) -> {
                if (o instanceof EventListener) {
                    l.add((EventListener)o);
                }
            };
            add.accept(this.d_devcMgr.getKeyboard(), deviceListeners);
            add.accept(this.d_devcMgr.getMouse(), deviceListeners);
            this.d_devicesListener = new ChainedDeviceListener(deviceListeners);
            add.accept(this.d_intercept, eventListeners);
            eventListeners.add(this.d_tool);
            this.d_eventListener = eventListeners.size() == 1 ? this.d_tool : new ChainedDeviceListener(eventListeners);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (this.d_pressedKeys.add(e.getKeyCode())) {
                this.d_devicesListener.keyPressed(e);
                if (EventDispatcher.isEnabled(e)) {
                    this.d_eventListener.keyPressed(e);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (this.d_pressedKeys.remove(e.getKeyCode())) {
                this.d_devicesListener.keyReleased(e);
                if (EventDispatcher.isEnabled(e)) {
                    this.d_eventListener.keyReleased(e);
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.d_devicesListener.keyTyped(e);
            if (EventDispatcher.isEnabled(e)) {
                this.d_eventListener.keyTyped(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.d_pressedBtns.add(e.getButton())) {
                this.d_devicesListener.mousePressed(e);
                if (EventDispatcher.isEnabled(e)) {
                    this.d_eventListener.mousePressed(e);
                }
            }
        }

        private static boolean testBit(int mask, int bit) {
            return (mask & bit) == bit;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int modifiers = e.getModifiersEx();
            boolean btn1 = EventDispatcher.testBit(modifiers, 1024);
            boolean btn2 = EventDispatcher.testBit(modifiers, 2048);
            boolean btn3 = EventDispatcher.testBit(modifiers, 4096);
            if (btn1 && this.d_pressedBtns.contains(1) || btn2 && this.d_pressedBtns.contains(2) || btn3 && this.d_pressedBtns.contains(3)) {
                this.d_devicesListener.mouseDragged(e);
                if (EventDispatcher.isEnabled(e)) {
                    this.d_eventListener.mouseDragged(e);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.d_pressedBtns.remove(e.getButton())) {
                this.d_devicesListener.mouseReleased(e);
                if (EventDispatcher.isEnabled(e)) {
                    this.d_eventListener.mouseReleased(e);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.d_devicesListener.mouseClicked(e);
            if (EventDispatcher.isEnabled(e)) {
                this.d_eventListener.mouseClicked(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.d_devicesListener.mouseEntered(e);
            if (EventDispatcher.isEnabled(e)) {
                this.d_eventListener.mouseEntered(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.d_devicesListener.mouseExited(e);
            if (EventDispatcher.isEnabled(e)) {
                this.d_eventListener.mouseExited(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.d_devicesListener.mouseMoved(e);
            if (EventDispatcher.isEnabled(e)) {
                this.d_eventListener.mouseMoved(e);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            this.d_devicesListener.mouseWheelMoved(e);
            if (EventDispatcher.isEnabled(e)) {
                this.d_eventListener.mouseWheelMoved(e);
            }
        }

        public void clearPressedKeys() {
            this.d_pressedKeys.clear();
        }
    }

    private class ToolMode {
        public final Tool tool;
        private final boolean d_stickyModifiable;
        private final MouseAdapter d_stickyListener;
        private boolean d_sticky = false;

        public ToolMode(Tool tool, boolean sticky, boolean stickyModifiable) {
            this.tool = tool;
            this.d_stickyModifiable = stickyModifiable;
            this.d_stickyListener = this.d_stickyModifiable ? new MouseAdapter(){
                private boolean d_pressed = false;

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 1) {
                        this.d_pressed = true;
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() == 1 && this.d_pressed) {
                        this.d_pressed = false;
                        ToolMode.this.setSticky(!ToolMode.this.isSticky());
                    }
                }
            } : null;
            this.d_sticky = sticky;
        }

        public boolean isSticky() {
            return this.d_sticky;
        }

        public void setSticky(boolean sticky) {
            if (!this.d_stickyModifiable) {
                return;
            }
            this.d_sticky = sticky;
            AbstractButton btn = ToolManager.this.getToolbarButton(this.tool);
            if (this.d_sticky) {
                ImageIcon newIcon = btn.getIcon() != null ? new DecoratedIcon(btn.getIcon(), s_stickyIcon, 3) : s_stickyIcon;
                btn.setIcon(newIcon);
            } else {
                Icon currIcon = btn.getIcon();
                if (currIcon instanceof DecoratedIcon) {
                    btn.setIcon(((DecoratedIcon)currIcon).getBase());
                } else if (currIcon == s_stickyIcon) {
                    btn.setIcon(null);
                }
            }
        }

        void begin() {
            this.setSticky(this.d_sticky);
            if (this.d_stickyListener != null) {
                ToolManager.this.getToolbarButton(this.tool).addMouseListener(this.d_stickyListener);
            }
        }

        void end() {
            if (this.d_stickyListener != null) {
                ToolManager.this.getToolbarButton(this.tool).removeMouseListener(this.d_stickyListener);
            }
            if (this.isSticky()) {
                this.setSticky(false);
            }
        }
    }

    public static interface ToolChangeListener {
        public void toolWillChanged(Tool var1, Tool var2);
    }

    public static class ToolProps {
        public final ToolAction action;
        public final JToggleButton toolbarBtn;
        public final JMenuItem menuItem;
        public final boolean modal;
        public final Object meta;

        public ToolProps(ToolAction action, JToggleButton toolbarBtn, JMenuItem menuItem, boolean modal, Object meta) {
            this.action = action;
            this.toolbarBtn = toolbarBtn;
            this.menuItem = menuItem;
            this.modal = modal;
            this.meta = meta;
        }
    }

    private class ToolActivatedListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("SwingSelectedKey") && evt.getNewValue().equals(Boolean.TRUE)) {
                ToolAction a = (ToolAction)evt.getSource();
                Tool t = a.getTool();
                ToolManager.this.setCurrentTool(t, false, false, true);
            }
        }
    }

    public class ToolPropsAction
    extends AbstractAction {
        public ToolPropsAction() {
            super(Intl.intl("Tool Properties"), guiUtil.loadTeciIcon("Preferences16.gif"));
            this.putValue("ShortDescription", Intl.intl("Tool Properties"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ToolManager.this.d_currentTool instanceof PropertyEditor) {
                ((PropertyEditor)((Object)ToolManager.this.d_currentTool)).editProperties();
            }
        }
    }

    public class ToolAction
    extends BooleanAction {
        private Tool d_tool;
        private Icon d_icon;

        public ToolAction(Tool tool, String name, String toolTip, Icon icon) {
            super(name, false, icon);
            this.d_icon = icon;
            this.d_tool = tool;
            this.putValue("ShortDescription", toolTip);
        }

        @Override
        public Icon getIcon() {
            return this.d_icon;
        }

        @Override
        public boolean isSelected() {
            return (Boolean)this.getValue("SwingSelectedKey");
        }

        @Override
        public void setSelected(boolean selected) {
            this.putValue("SwingSelectedKey", selected);
        }

        public Tool getTool() {
            return this.d_tool;
        }
    }
}

