/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.tool;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import thunderheadeng.gui.tool.ButtonHistory;
import thunderheadeng.gui.tool.IKeyboardDevc;

public class SwingKeyboard
extends KeyAdapter
implements IKeyboardDevc {
    private static final ButtonHistory DEF_HISTORY = new ButtonHistory();
    private final Map<Integer, ButtonHistory> d_pressedKeys = new HashMap<Integer, ButtonHistory>();

    @Override
    public ButtonHistory getHistory(int key) {
        return this.d_pressedKeys.getOrDefault(key, DEF_HISTORY);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        ButtonHistory history = this.d_pressedKeys.computeIfAbsent(e.getKeyCode(), k -> new ButtonHistory());
        history.isPressed = true;
        history.lastPressed = e.getWhen();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        ButtonHistory history = this.d_pressedKeys.computeIfAbsent(e.getKeyCode(), k -> new ButtonHistory());
        history.isPressed = false;
        history.lastReleased = e.getWhen();
    }

    @Override
    public void clearPressedKeys() {
        this.d_pressedKeys.clear();
    }
}

