/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.tool;

import java.awt.Point;
import java.util.stream.Stream;
import thunderheadeng.gui.tool.ButtonHistory;

public interface IMouseDevc {
    public void moveMouse(Point var1);

    public MouseButtonHistory getHistory(Button var1);

    public MouseButtonHistory getHistory(int var1);

    default public boolean isPressed(Button button) {
        return this.getHistory((Button)button).isPressed;
    }

    default public boolean isPressed(int button) {
        return this.getHistory((int)button).isPressed;
    }

    default public int getMostRecentlyPressed(Stream<Integer> buttons) {
        return buttons.filter(b -> this.getHistory((int)b.intValue()).isPressed).max((b1, b2) -> Long.compare(this.getHistory((int)b1.intValue()).lastPressed, this.getHistory((int)b2.intValue()).lastPressed)).get();
    }

    default public Button getMostRecentlyPressedPredef(Stream<Button> buttons) {
        return buttons.filter(b -> this.getHistory((Button)b).isPressed).max((b1, b2) -> Long.compare(this.getHistory((Button)b1).lastPressed, this.getHistory((Button)b2).lastPressed)).orElse(null);
    }

    public static class MouseButtonHistory
    extends ButtonHistory {
        public long lastDragged = Long.MAX_VALUE;

        public boolean isDragging() {
            return this.lastDragged >= this.lastPressed;
        }

        public boolean wasDragged() {
            return this.lastDragged <= this.lastReleased;
        }
    }

    public static enum Button {
        LEFT,
        MIDDLE,
        RIGHT;

    }
}

