/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.table;

import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;

public class guiTableUtil {
    public static guiTable fixedColumnTable(String[] columnHeaders, Class[] columnClasses) {
        return guiTableUtil.fixedColumnTable(columnHeaders, columnClasses, 0, Integer.MAX_VALUE, 24);
    }

    public static guiTable fixedColumnTable(String[] columnHeaders, Class[] columnClasses, guiTable table) {
        return guiTableUtil.fixedColumnTable(columnHeaders, columnClasses, 0, Integer.MAX_VALUE, 24, table);
    }

    public static guiTable fixedColumnTable(String[] columnHeaders, Class[] columnClasses, int options) {
        return guiTableUtil.fixedColumnTable(columnHeaders, columnClasses, 0, Integer.MAX_VALUE, options);
    }

    public static guiTable fixedColumnTable(String[] columnHeaders, Class[] columnClasses, int rows, int maxRows, int tableOptions) {
        if (columnHeaders.length != columnClasses.length) {
            throw new IllegalArgumentException("Must have same number of column headers as column classes.");
        }
        guiDefaultTableModel model = new guiDefaultTableModel(rows, columnHeaders.length, (tableOptions | 8) > 0, maxRows, false, columnHeaders.length);
        guiTable table = new guiTable((TableModel)model, tableOptions);
        TableColumnModel tcm = table.getColumnModel();
        for (int i = 0; i < columnHeaders.length; ++i) {
            tcm.getColumn(i).setHeaderValue(columnHeaders[i]);
            model.setColumnClass(i, columnClasses[i]);
        }
        return table;
    }

    public static guiTable fixedColumnTable(String[] columnHeaders, Class[] columnClasses, int rows, int maxRows, int tableOptions, guiTable table) {
        if (columnHeaders.length != columnClasses.length) {
            throw new IllegalArgumentException("Must have same number of column headers as column classes.");
        }
        guiDefaultTableModel model = new guiDefaultTableModel(rows, columnHeaders.length, (tableOptions | 8) > 0, maxRows, false, columnHeaders.length);
        table.setModel(model);
        TableColumnModel tcm = table.getColumnModel();
        for (int i = 0; i < columnHeaders.length; ++i) {
            tcm.getColumn(i).setHeaderValue(columnHeaders[i]);
            model.setColumnClass(i, columnClasses[i]);
        }
        return table;
    }

    public static double getDouble(TableModel model, int row, int col) {
        return (Double)model.getValueAt(row, col);
    }

    public static int rowWithNullEntry(TableModel model) {
        for (int row = 0; row < model.getRowCount(); ++row) {
            for (int col = 0; col < model.getColumnCount(); ++col) {
                if (model.getValueAt(row, col) != null) continue;
                return row;
            }
        }
        return -1;
    }

    public static boolean containsNull(TableModel model) {
        for (int row = 0; row < model.getRowCount(); ++row) {
            for (int col = 0; col < model.getColumnCount(); ++col) {
                if (model.getValueAt(row, col) != null) continue;
                return true;
            }
        }
        return false;
    }

    public static void setColumnData(DefaultTableModel model, int columnIndex, double[] data) {
        if (model == null || data == null) {
            return;
        }
        model.setRowCount(data.length);
        for (int i = 0; i < data.length; ++i) {
            model.setValueAt(data[i], i, columnIndex);
        }
    }
}

