/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.table;

import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import thunderheadeng.gui.guiComboBox;

public class ComboBoxTableCell<T>
extends DefaultCellEditor
implements TableCellRenderer {
    private final TableCellRenderer d_ren = new DefaultTableCellRenderer();
    private int d_row;
    private int d_col;

    public ComboBoxTableCell(T[] vals) {
        this(Arrays.asList(vals));
    }

    public ComboBoxTableCell(Collection<? extends T> vals) {
        this(new guiComboBox<T>(vals));
    }

    public ComboBoxTableCell(guiComboBox<T> box) {
        super(box);
    }

    public int getEditedRow() {
        return this.d_row;
    }

    public int getEditedColumn() {
        return this.d_col;
    }

    public void setValues(T[] vals) {
        ((guiComboBox)this.editorComponent).setItems(vals);
    }

    public void setValues(Collection<? extends T> vals) {
        ((guiComboBox)this.editorComponent).setItems(vals);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.d_row = row;
        this.d_col = column;
        Component editorComp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        return editorComp;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean sel, boolean hasFocus, int row, int column) {
        Component c = this.d_ren.getTableCellRendererComponent(table, value, sel, hasFocus, row, column);
        return c;
    }

    @Override
    public boolean isCellEditable(EventObject obj) {
        if (obj != null && obj.getSource() instanceof Component) {
            Component c = (Component)obj.getSource();
            return c.isEnabled() && super.isCellEditable(obj);
        }
        return super.isCellEditable(obj);
    }
}

