/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import thunderheadeng.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.ColorIcon;
import thunderheadeng.gui.ComponentGroup;
import thunderheadeng.gui.ComponentGroup2;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IListenerStripper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.NoIcon;
import thunderheadeng.gui.SelectableAction;
import thunderheadeng.gui.WaitCursorMgr;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiFrame;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.image.IImage;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TriConsumer;

public class guiUtil {
    public static final GrayFilter DISABLED_FILTER = new GrayFilter(true, 50);
    private static final HashMap<ImageKey, WeakReference<Image>> s_images = new HashMap();
    private static final WeakHashMap<IImage, WeakReference<BufferedImage>> s_imageCache = new WeakHashMap();
    public static final int VALIDATE_HIDDEN = 1;
    public static final int VALIDATE_DISABLED = 2;

    public static Image loadImage(String filename) {
        return guiUtil.loadImages(filename, -1, -1, ImageFilter.NORMAL)[0];
    }

    public static Image[] loadImages(String filename, int width, int height, ImageFilter ... filters) {
        IImageRetriever<String> retriever = new IImageRetriever<String>(){

            @Override
            public BufferedImage getImage(String resource) throws IOException {
                return guiUtil.forceImageLoad(resource);
            }
        };
        return guiUtil.loadImages(filename, retriever, width, height, filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Image[] loadImages(T resource, IImageRetriever<T> imgRetriever, int width, int height, ImageFilter ... filters) {
        HashMap<ImageKey, WeakReference<Image>> hashMap = s_images;
        synchronized (hashMap) {
            Image baseImage = null;
            Image[] result = new Image[filters.length];
            for (int m = 0; m < filters.length; ++m) {
                try {
                    Image img;
                    ImageKey key = new ImageKey(resource, filters[m], width, height);
                    WeakReference<Image> imageRef = s_images.get(key);
                    Image image = img = imageRef != null ? (Image)imageRef.get() : null;
                    if (img == null) {
                        if (baseImage == null) {
                            ImageKey baseKey = new ImageKey(resource, ImageFilter.NORMAL, width, height);
                            WeakReference<Image> baseImageRef = s_images.get(baseKey);
                            Image image2 = baseImage = baseImageRef != null ? (Image)baseImageRef.get() : null;
                            if (baseImage == null) {
                                baseImage = guiUtil.resizeImage(imgRetriever.getImage(resource), width, height);
                            }
                        }
                        assert (baseImage != null);
                        img = guiUtil.filterImage(baseImage, key.filter);
                        s_images.put(key, new WeakReference<Image>(img));
                    }
                    result[m] = img;
                    continue;
                }
                catch (Exception e) {
                    result[m] = null;
                }
            }
            return result;
        }
    }

    private static BufferedImage forceImageLoad(String filename) throws IOException {
        URL url;
        if (!filename.startsWith("/")) {
            filename = "/" + filename;
        }
        if ((url = guiUtil.class.getResource(filename)) == null) {
            throw new FileNotFoundException(filename);
        }
        return ImageIO.read(url);
    }

    private static Image resizeImage(BufferedImage image, int widthConstraint, int heightConstraint) throws IOException {
        int resizeHeight;
        int resizeWidth;
        int width = image.getWidth();
        int height = image.getHeight();
        if (!(widthConstraint > 0 && width != widthConstraint || heightConstraint > 0 && height != heightConstraint)) {
            return image;
        }
        if (widthConstraint > 0 && heightConstraint > 0) {
            resizeWidth = widthConstraint;
            resizeHeight = heightConstraint;
        } else if (widthConstraint > 0) {
            resizeWidth = widthConstraint;
            resizeHeight = Math.round((float)height / (float)width * (float)resizeWidth);
        } else {
            assert (heightConstraint > 0);
            resizeHeight = heightConstraint;
            resizeWidth = Math.round((float)width / (float)height * (float)resizeHeight);
        }
        double scaleX = (double)resizeWidth / (double)width;
        double scaleY = (double)resizeHeight / (double)height;
        double scale = scaleX < scaleY ? scaleX : scaleY;
        double tx = ((double)resizeWidth - (double)width * scale) / 2.0 / scale;
        double ty = ((double)resizeHeight - (double)height * scale) / 2.0 / scale;
        BufferedImage iconImage = new BufferedImage(resizeWidth, resizeHeight, 2);
        Graphics2D g2d = iconImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setColor(new Color(0, 0, 0, 0));
        g2d.fillRect(0, 0, width, height);
        AffineTransform xform = new AffineTransform();
        xform.scale(scale, scale);
        xform.translate(tx, ty);
        g2d.drawImage(image, xform, new ImageObserver(){

            @Override
            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                return true;
            }
        });
        g2d.dispose();
        return iconImage;
    }

    private static Image filterImage(Image image, ImageFilter filter) {
        if (filter == ImageFilter.DISABLED) {
            return GrayFilter.createDisabledImage(image);
        }
        return image;
    }

    public static ImageIcon loadTeciIcon(String name) {
        return guiUtil.loadTeciIcon(name, -1);
    }

    public static ImageIcon loadTeciIcon(String name, int height) {
        return guiUtil.loadIcon("thunderheadeng/gui/graphics/" + name, height);
    }

    public static ImageIcon loadIcon(String filename) {
        return guiUtil.loadIcon(filename, -1);
    }

    public static ImageIcon loadIcon(String filename, int height) {
        Image image = guiUtil.loadImages(filename, -1, height, ImageFilter.NORMAL)[0];
        return image == null ? null : new ImageIcon(image);
    }

    public static Cursor createTeciCursor(String key, String filename, int hotspotx, int hotspoty) {
        return guiUtil.createCursor(key, "thunderheadeng/gui/graphics/" + filename, hotspotx, hotspoty);
    }

    public static Cursor createCursor(String key, String filename, int hotspotx, int hotspoty) {
        Image image = guiUtil.loadImage(filename);
        try {
            return Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(hotspotx, hotspoty), key);
        }
        catch (Exception e) {
            return Cursor.getDefaultCursor();
        }
    }

    public static void addSelectableMenuItem(JMenu menu, SelectableAction action) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        menu.add(guiUtil.initMenuItem(item, action, null));
    }

    public static void addSelectableMenuItem(JPopupMenu menu, SelectableAction action) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        menu.add(guiUtil.initMenuItem(item, action, null));
    }

    public static JToggleButton createToolbarToggleButton(SelectableAction action) {
        JToggleButton button = new JToggleButton(action);
        guiUtil.initToolbarBtn(action, button);
        button.addItemListener(action);
        return button;
    }

    public static JButton createToolbarButton(Action action) {
        JButton btn = new JButton(action);
        guiUtil.initToolbarBtn(action, btn);
        return btn;
    }

    private static void initToolbarBtn(Action action, AbstractButton btn) {
        Object disIcon;
        Icon icon = (Icon)action.getValue("SmallIcon");
        if (icon != null) {
            btn.setText("");
            String ttt = (String)action.getValue("ShortDescription");
            if (ttt == null || ttt.trim().equals("")) {
                btn.setToolTipText((String)action.getValue("Name"));
            }
        }
        if ((disIcon = action.getValue("guiAction.DISABLED_ICON")) instanceof Icon) {
            btn.setDisabledIcon((Icon)disIcon);
        }
    }

    public static <T extends JMenuItem> T initMenuItem(T item, Action action, ButtonGroup group) {
        Object disIcon;
        String ttt = (String)action.getValue("ShortDescription");
        if (ttt != null && !ttt.trim().isEmpty()) {
            item.setToolTipText(ttt.trim());
        }
        if (action instanceof ItemListener) {
            item.addItemListener((ItemListener)((Object)action));
        }
        if (group != null) {
            group.add(item);
        }
        if ((disIcon = action.getValue("guiAction.DISABLED_ICON")) instanceof Icon) {
            item.setDisabledIcon((Icon)disIcon);
        }
        return item;
    }

    public static void addMEMenuItems(JMenu menu, SelectableAction ... actions) {
        guiUtil.addMEMenuItems(menu, Arrays.asList(actions));
    }

    public static void addMEMenuItems(JMenu menu, Collection<? extends SelectableAction> actions) {
        ButtonGroup group = new ButtonGroup();
        for (SelectableAction selectableAction : actions) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(selectableAction);
            menu.add(guiUtil.initMenuItem(item, selectableAction, group));
        }
    }

    public static void addMEMenuItems(JPopupMenu menu, SelectableAction ... actions) {
        guiUtil.addMEMenuItems(menu, Arrays.asList(actions));
    }

    public static void addMEMenuItems(JPopupMenu menu, Collection<? extends SelectableAction> actions) {
        ButtonGroup group = new ButtonGroup();
        for (SelectableAction selectableAction : actions) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(selectableAction);
            menu.add(guiUtil.initMenuItem(item, selectableAction, group));
        }
    }

    public static void addMEToolbarItems(JToolBar tb, SelectableAction ... actions) {
        ButtonGroup group = new ButtonGroup();
        for (int m = 0; m < actions.length; ++m) {
            JToggleButton item = guiUtil.createToolbarToggleButton(actions[m]);
            tb.add(item);
            group.add(item);
        }
    }

    public static Icon createDisabledIcon(Icon i) {
        if (i == null) {
            return null;
        }
        if (i instanceof ImageIcon) {
            return new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)i).getImage()));
        }
        BufferedImage bi = new BufferedImage(i.getIconWidth(), i.getIconHeight(), 2);
        Graphics g = bi.getGraphics();
        i.paintIcon(null, g, 0, 0);
        g.dispose();
        return new ImageIcon(GrayFilter.createDisabledImage(bi));
    }

    public static Pair<JTabbedPane, Component> findTab(Component c) {
        if (c == null) {
            return null;
        }
        Container parent = c.getParent();
        while (parent != null && !(parent instanceof JTabbedPane)) {
            c = parent;
            parent = c.getParent();
        }
        return parent instanceof JTabbedPane ? new Pair<JTabbedPane, Component>((JTabbedPane)parent, c) : null;
    }

    public static void showAncestorTab(Component c) {
        Pair<JTabbedPane, Component> t = guiUtil.findTab(c);
        if (t == null) {
            return;
        }
        ((JTabbedPane)t.v1).setSelectedComponent((Component)t.v2);
    }

    private static int[] getSquareDims(int width, int height) {
        assert (width > 0 || height > 0);
        int w = width > 0 ? width : height;
        int h = height > 0 ? height : width;
        return new int[]{w, h};
    }

    public static Icon[] getIcons(IMaterial mat, int width, int height, int colorOptions, ImageFilter ... filters) {
        if (mat != null) {
            IMatAttrs attrs = mat.getAttributes();
            Texture diffuseTex = attrs.getTexture(MatChannel.DIFFUSE);
            if (diffuseTex != null) {
                return guiUtil.getIcons(diffuseTex.image, width, height, filters);
            }
            int[] dims = guiUtil.getSquareDims(width, height);
            Color dColor = attrs.getColor(MatChannel.DIFFUSE);
            if (dColor == null) {
                dColor = new Color(0, 0, 0, 0);
            }
            ColorIcon icon = new ColorIcon(dColor, dims[0], dims[1], colorOptions);
            Object[] result = new Icon[filters.length];
            Arrays.fill(result, icon);
            return result;
        }
        int[] dims = guiUtil.getSquareDims(width, height);
        Object[] result = new Icon[filters.length];
        Arrays.fill(result, new NoIcon(Color.BLACK, dims[0], dims[1]));
        return result;
    }

    public static Icon[] getIcons(IImage img, int width, int height, ImageFilter ... filters) {
        if (img != null) {
            Image[] images = guiUtil.getImages(img, width, height, filters);
            Icon[] result = new Icon[filters.length];
            for (int m = 0; m < images.length; ++m) {
                Image limg = images[m];
                result[m] = limg == null ? null : new ImageIcon(limg);
            }
            return result;
        }
        int[] dims = guiUtil.getSquareDims(width, height);
        Object[] result = new Icon[filters.length];
        Arrays.fill(result, new NoIcon(Color.BLACK, dims[0], dims[1]));
        return result;
    }

    public static Image[] getImages(IImage image, int width, int height, ImageFilter ... filters) {
        IImageRetriever<IImage> retriever = new IImageRetriever<IImage>(){

            @Override
            public BufferedImage getImage(IImage resource) throws IOException {
                return guiUtil.getBufferedImage(resource);
            }
        };
        return guiUtil.loadImages(image, retriever, width, height, filters);
    }

    public static void paintComponent(Component c, Graphics g, IMaterial mat) {
        Icon icon;
        Rectangle bounds = g.getClipBounds();
        if (bounds == null) {
            return;
        }
        Icon[] icons = guiUtil.getIcons(mat, bounds.width, bounds.height, 0, ImageFilter.NORMAL, ImageFilter.DISABLED);
        Icon icon2 = icon = c.isEnabled() || icons[1] == null ? icons[0] : icons[1];
        if (icon != null) {
            icon.paintIcon(c, g, bounds.x, bounds.y);
        }
    }

    public static void paintComponent(Component c, Graphics g, IImage img) {
        Icon icon;
        Rectangle bounds = g.getClipBounds();
        if (bounds == null) {
            return;
        }
        Icon[] icons = guiUtil.getIcons(img, bounds.width, bounds.height, ImageFilter.NORMAL, ImageFilter.DISABLED);
        Icon icon2 = icon = c.isEnabled() || icons[1] == null ? icons[0] : icons[1];
        if (icon != null) {
            icon.paintIcon(c, g, bounds.x, bounds.y);
        }
    }

    public static void initButton(AbstractButton btn, IMaterial mat, int iconWidth, int iconHeight) {
        Insets insets = btn.getBorder().getBorderInsets(btn);
        int borderSize = Math.min(insets.left, insets.bottom);
        int btnWidth = iconWidth + borderSize * 2;
        int btnHeight = iconHeight + borderSize * 2;
        btn.setPreferredSize(new Dimension(btnWidth, btnHeight));
        Icon[] icons = guiUtil.getIcons(mat, iconWidth, iconHeight, 0, ImageFilter.NORMAL, ImageFilter.DISABLED);
        btn.setIcon(icons[0]);
        btn.setDisabledIcon(icons[1]);
    }

    public static void initButton(AbstractButton btn, IImage img) {
        if (img != null) {
            btn.setToolTipText(img.getFilename());
        } else {
            btn.setToolTipText(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getBufferedImage(IImage img) {
        WeakHashMap<IImage, WeakReference<BufferedImage>> weakHashMap = s_imageCache;
        synchronized (weakHashMap) {
            BufferedImage bimg;
            WeakReference<BufferedImage> bimgRef = s_imageCache.get(img);
            BufferedImage bufferedImage = bimg = bimgRef != null ? (BufferedImage)bimgRef.get() : null;
            if (bimg == null) {
                bimg = img.toBufferedImage();
                s_imageCache.put(img, new WeakReference<BufferedImage>(bimg));
            }
            return bimg;
        }
    }

    public static void showError(Application app, String title, String msg, Throwable t) {
        guiUtil.showError(app.getActiveFrame(), title, msg, t);
    }

    public static void showError(Component parent, String title, String msg, Throwable t) {
        msg = guiUtil.formatError(msg, t);
        Window parentWindow = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        JOptionPane.showMessageDialog(parentWindow, msg, title, 0);
    }

    public static String formatError(String msg, Throwable t) {
        t.printStackTrace();
        while (t.getCause() != null) {
            t = t.getCause();
        }
        String error = t.getLocalizedMessage() != null && !t.getLocalizedMessage().isEmpty() ? t.getClass().getSimpleName() + ": " + t.getLocalizedMessage() : t.getClass().getSimpleName();
        String excMsg = String.format(Intl.intl("Cause: %s"), error);
        msg = msg == null || msg.isEmpty() ? excMsg : msg + "\n" + excMsg;
        return msg;
    }

    public static WaitCursorMgr getWaitMgr(Component c) {
        while (c != null) {
            if (c instanceof guiFrame) {
                return ((guiFrame)c).getWaitCursorMgr();
            }
            if (c instanceof guiDialog) {
                return ((guiDialog)c).getWaitCursorMgr();
            }
            c = c.getParent();
        }
        return null;
    }

    public static IListenerStripper stripListeners(JComboBox c) {
        return new ComboBoxListenerStripper(c);
    }

    public static IListenerStripper stripListeners(AbstractButton c) {
        return new ButtonListenerStripper(c);
    }

    public static IListenerStripper stripListeners(JList c) {
        return new ListListenerStripper(c);
    }

    public static IListenerStripper stripListeners(JCheckBox c) {
        IListenerStripper[] iListenerStripperArray = new IListenerStripper[4];
        iListenerStripperArray[0] = guiUtil.stripListeners(c::addItemListener, c::getItemListeners, c::removeItemListener);
        iListenerStripperArray[1] = guiUtil.stripListeners(c::addActionListener, c::getActionListeners, c::removeActionListener);
        iListenerStripperArray[2] = guiUtil.stripListeners(c::addChangeListener, c::getChangeListeners, c::removeChangeListener);
        iListenerStripperArray[3] = guiUtil.stripListeners(c::addPropertyChangeListener, c::getPropertyChangeListeners, c::removePropertyChangeListener);
        return new DefaultListenerStripper<JCheckBox>(c, iListenerStripperArray);
    }

    public static IListenerStripper stripListeners(JTable c) {
        return new TableListenerStripper(c);
    }

    public static IListenerStripper stripListeners(Component c) {
        if (c instanceof JComboBox) {
            return guiUtil.stripListeners((JComboBox)c);
        }
        if (c instanceof AbstractButton) {
            return guiUtil.stripListeners((AbstractButton)c);
        }
        if (c instanceof JList) {
            return guiUtil.stripListeners((JList)c);
        }
        if (c instanceof JCheckBox) {
            return guiUtil.stripListeners((JCheckBox)c);
        }
        if (c instanceof JTable) {
            return guiUtil.stripListeners((JTable)c);
        }
        return new DefaultListenerStripper<Component>(c, new IListenerStripper[0]);
    }

    public static <LType> IListenerStripper stripListeners(Consumer<LType> add, Supplier<LType[]> get, Consumer<LType> remove) {
        return new ListenerStripper<LType>(add, get, remove);
    }

    public static ButtonGroup group(AbstractButton ... buttons) {
        ButtonGroup gp = new ButtonGroup();
        for (AbstractButton btn : buttons) {
            gp.add(btn);
        }
        return gp;
    }

    public static void addItemListener(ButtonGroup group, ItemListener listener) {
        Enumeration<AbstractButton> buttons = group.getElements();
        while (buttons.hasMoreElements()) {
            buttons.nextElement().addItemListener(listener);
        }
    }

    public static void removeItemListener(ButtonGroup group, ItemListener listener) {
        Enumeration<AbstractButton> buttons = group.getElements();
        while (buttons.hasMoreElements()) {
            buttons.nextElement().removeItemListener(listener);
        }
    }

    public static <T extends Component> ComponentGroup2<T> group(Class<T> clazz, T ... items) {
        return new ComponentGroup2(items);
    }

    public static <T extends Component> ComponentGroup2<T> group(T ... items) {
        return new ComponentGroup2(items);
    }

    public static <T extends Component> ComponentGroup2<T> group(Collection<T> items) {
        return new ComponentGroup2<T>(items);
    }

    public static void link(AbstractButton button, boolean invert, Component ... components) {
        LinkStatus.link(button, invert, components);
    }

    public static void link(AbstractButton button, boolean invert, ComponentGroup group) {
        LinkStatus.link(button, invert, group);
    }

    public static void link(AbstractButton button, Component ... components) {
        LinkStatus.link(button, components);
    }

    public static void link(AbstractButton button, ComponentGroup cg) {
        LinkStatus.link(button, cg);
    }

    public static void link2(AbstractButton button, Component ... components) {
        LinkStatus.link2(button, components);
    }

    public static void link2(AbstractButton button, boolean invert, Component ... components) {
        LinkStatus.link2(button, invert, components);
    }

    public static String formatText(JComponent comp, String text) {
        FontMetrics fm = comp.getFontMetrics(comp.getFont());
        int pwidth = Math.max(0, comp.getPreferredSize().width - comp.getInsets().left - comp.getInsets().right);
        return guiUtil.formatText(fm, text, pwidth);
    }

    public static String formatText(FontMetrics fm, String text, int pwidth) {
        int width;
        char[] textChars = text.toCharArray();
        if (fm.charsWidth(textChars, 0, textChars.length) <= pwidth) {
            return text;
        }
        for (int m = 0; m < text.length() && (width = fm.charsWidth(textChars, 0, m + 1)) <= pwidth; ++m) {
        }
        for (int n = m; n >= 0; --n) {
            textChars[n] = 8230;
            int width2 = fm.charsWidth(textChars, 0, n + 1);
            if (width2 > pwidth) continue;
            return new String(textChars, 0, n + 1);
        }
        return "";
    }

    public static String escapeHTML(String text) {
        text = text.replace("&", "&amp;");
        text = text.replace("<", "&lt;");
        text = text.replace(">", "&gt;");
        text = text.replace("\"", "&quot;");
        return text;
    }

    public static boolean shouldValidateChild(Component child, int options) {
        return !(!guiUtil.test(options, 1) && !child.isVisible() && !(child.getParent() instanceof JTabbedPane) || !guiUtil.test(options, 2) && !child.isEnabled());
    }

    private static boolean test(int options, int option) {
        return (options & option) == option;
    }

    public static JButton newMediaBtn(String tooltip, String icon, ActionListener action) {
        JButton btn = new JButton();
        guiUtil.setMediaIcons(btn, icon);
        btn.addActionListener(action);
        btn.setContentAreaFilled(false);
        btn.setBorder(BorderFactory.createEmptyBorder());
        btn.setFocusable(false);
        return btn;
    }

    public static void setMediaIcons(JButton button, String icon) {
        button.setIcon(guiUtil.loadTeciIcon(icon + "Normal.png"));
        button.setPressedIcon(guiUtil.loadTeciIcon(icon + "Pressed.png"));
        button.setRolloverIcon(guiUtil.loadTeciIcon(icon + "Hot.png"));
        button.setDisabledIcon(guiUtil.loadTeciIcon(icon + "Disabled.png"));
    }

    public static javax.swing.filechooser.FileFilter toChooserFileFilter(final FileFilter filter) {
        return new javax.swing.filechooser.FileFilter(){

            @Override
            public String getDescription() {
                return filter.toString();
            }

            @Override
            public boolean accept(File f) {
                return filter.accept(f);
            }
        };
    }

    public static <T> guiComboBox<T> newCombo(T item1, String label1, Object ... args) {
        assert (args.length % 2 == 0);
        ArrayList items = new ArrayList();
        HashMap labels = new HashMap();
        BiConsumer<Object, String> add = (item, label) -> {
            items.add(item);
            labels.put(item, label);
        };
        add.accept(item1, label1);
        int m = 0;
        while (m < args.length) {
            Object item2 = args[m++];
            String label2 = (String)args[m++];
            add.accept(item2, label2);
        }
        return guiUtil.newCombo((T item) -> new Pair(labels.get(item), null), items);
    }

    public static <T> guiComboBox<T> newCombo(T item1, String label1, String tooltip1, Object ... args) {
        assert (args.length % 3 == 0);
        ArrayList items = new ArrayList();
        HashMap labels = new HashMap();
        TriConsumer<Object, String, String> add = (item, label, tooltip) -> {
            items.add(item);
            labels.put(item, new Pair<String, String>((String)label, (String)tooltip));
        };
        add.accept(item1, label1, tooltip1);
        int m = 0;
        while (m < args.length) {
            Object item2 = args[m++];
            String label2 = (String)args[m++];
            String tooltip2 = (String)args[m++];
            add.accept(item2, label2, tooltip2);
        }
        return guiUtil.newCombo((T item) -> (Pair)labels.get(item), items);
    }

    public static <T> guiComboBox<T> newCombo(Function<T, Pair<String, String>> formatter, T ... items) {
        return guiUtil.newCombo(formatter, Arrays.asList(items));
    }

    public static <T> guiComboBox<T> newCombo(final Function<T, Pair<String, String>> formatter, Collection<T> items) {
        final guiComboBox<T> combo = new guiComboBox<T>(items);
        combo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                Pair desc = (Pair)formatter.apply(value);
                this.setText((String)desc.v1);
                if (desc.v2 != null && !((String)desc.v2).isEmpty()) {
                    combo.setToolTipText((String)desc.v2);
                    this.setToolTipText((String)desc.v2);
                } else {
                    combo.setToolTipText(null);
                    this.setToolTipText(null);
                }
                return this;
            }
        });
        return combo;
    }

    public static void showIntelWarning(Component parent, String appName, Supplier<IRenderSurface.OpenGLInfo> getRenderInfo, Consumer<Boolean> setRememberPref) {
        IRenderSurface.OpenGLInfo caps = getRenderInfo.get();
        String msg = String.format(Intl.intl("%1$s has detected Intel graphics. In some cases, out-of-date drivers for this adapter\n(%2$s) have been associated with rendering errors, including\nblank and corrupted visualization.\n\nIf you experience display issues, go to the <b>File</b> menu and select <b>Preferences</b>.\nOn the <b>Rendering</b> tab, choose <b>Max Compatibility</b>."), appName, caps.renderer);
        msg = "<html>" + msg.replace("\n", "<br>");
        guiDialog dlg = new guiDialog(SwingUtilities.getWindowAncestor(parent), Intl.intl("Intel Graphics Detected"), 1);
        guiCheckBox remember = new guiCheckBox(Intl.intl("Do not show this warning again."));
        remember.setSelected(true);
        GridBagHelper gb = new GridBagHelper(dlg.getDialogPane());
        gb.addRow(msg, 1, 1.0);
        gb.addRow(remember);
        gb.finalizeRows();
        dlg.doModal();
        setRememberPref.accept(remember.isSelected());
    }

    public static guiPanel getRenderPrefsBtns(Supplier<IPropertySet> getRenderPref, Supplier<IPropertySet> getRenderComp, Consumer<IPropertySet> loadPrefs) {
        JButton prefBtn = new JButton(Intl.intl("Max Quality"));
        prefBtn.setToolTipText(Intl.intl("Loads rendering preferences for maximum quality rendering."));
        JButton compBtn = new JButton(Intl.intl("Max Compatibility"));
        compBtn.setToolTipText(Intl.intl("Loads rendering preferences for maximum compatibility with older graphics cards and drivers."));
        Function<Supplier, ActionListener> toActionListener = getPrefs -> arg_0 -> guiUtil.lambda$null$240((Supplier)getPrefs, loadPrefs, arg_0);
        prefBtn.addActionListener(toActionListener.apply(getRenderPref));
        compBtn.addActionListener(toActionListener.apply(getRenderComp));
        guiPanel pnl = new guiPanel();
        GridBagHelper gb = new GridBagHelper(pnl);
        gb.addRow(prefBtn, compBtn);
        return pnl;
    }

    public static <T> boolean canLoadPref(IPropertySet props, boolean onlyIfDefined, IPropertySet.Prop<T> prop) {
        return !onlyIfDefined || props.isDefined(prop);
    }

    public static void loadPref(IPropertySet props, boolean onlyIfDefined, guiCheckBox cb, IPropertySet.Prop<Boolean> prop) {
        if (guiUtil.canLoadPref(props, onlyIfDefined, prop)) {
            cb.setSelected(props.get(prop));
        }
    }

    public static <T> void loadPref(IPropertySet props, boolean onlyIfDefined, guiComboBox<T> cb, IPropertySet.Prop<T> prop) {
        if (guiUtil.canLoadPref(props, onlyIfDefined, prop)) {
            cb.setSelectedItem(props.get(prop));
        }
    }

    private static /* synthetic */ void lambda$null$240(Supplier supplier, Consumer consumer, ActionEvent e) {
        IPropertySet props = (IPropertySet)supplier.get();
        consumer.accept(props);
    }

    private static class ImageKey {
        public final Object resource;
        public final ImageFilter filter;
        public final int width;
        public final int height;

        public ImageKey(Object resource, ImageFilter imageOpt, int width, int height) {
            this.resource = resource;
            this.filter = imageOpt;
            this.width = width;
            this.height = height;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ImageKey && ((ImageKey)obj).filter == this.filter && ((ImageKey)obj).width == this.width && ((ImageKey)obj).height == this.height && ((ImageKey)obj).resource.equals(this.resource);
        }

        public int hashCode() {
            return 0xFAA344D ^ this.resource.hashCode() + this.width + this.height + this.filter.hashCode();
        }
    }

    private static class ButtonListenerStripper
    extends DefaultListenerStripper<AbstractButton> {
        public final ActionListener[] d_actionListeners;
        public final ItemListener[] d_itemListeners;

        public ButtonListenerStripper(AbstractButton button) {
            super(button, new IListenerStripper[0]);
            this.d_itemListeners = button.getItemListeners();
            for (ItemListener itemListener : this.d_itemListeners) {
                button.removeItemListener(itemListener);
            }
            this.d_actionListeners = button.getActionListeners();
            for (EventListener eventListener : this.d_actionListeners) {
                button.removeActionListener((ActionListener)eventListener);
            }
        }

        @Override
        public void restore() {
            super.restore();
            for (ItemListener itemListener : this.d_itemListeners) {
                ((AbstractButton)this.getComponent()).addItemListener(itemListener);
            }
            for (EventListener eventListener : this.d_actionListeners) {
                ((AbstractButton)this.getComponent()).addActionListener((ActionListener)eventListener);
            }
        }
    }

    private static class TableListenerStripper
    extends DefaultListenerStripper<JTable> {
        private final TableModelListener[] d_modelListeners;

        public TableListenerStripper(JTable table) {
            super(table, new IListenerStripper[0]);
            this.d_modelListeners = table.getModel() instanceof AbstractTableModel ? ((AbstractTableModel)table.getModel()).getTableModelListeners() : new TableModelListener[0];
            for (TableModelListener listener : this.d_modelListeners) {
                table.getModel().removeTableModelListener(listener);
            }
        }

        @Override
        public void restore() {
            super.restore();
            for (TableModelListener listener : this.d_modelListeners) {
                ((JTable)this.getComponent()).getModel().addTableModelListener(listener);
            }
        }
    }

    private static class ListListenerStripper
    extends DefaultListenerStripper<JList> {
        private final ListSelectionListener[] d_listSelListeners;

        public ListListenerStripper(JList list) {
            super(list, new IListenerStripper[0]);
            for (ListSelectionListener listener : this.d_listSelListeners = list.getListSelectionListeners()) {
                list.removeListSelectionListener(listener);
            }
        }

        @Override
        public void restore() {
            super.restore();
            for (ListSelectionListener listener : this.d_listSelListeners) {
                ((JList)this.getComponent()).addListSelectionListener(listener);
            }
        }
    }

    private static class ComboBoxListenerStripper
    implements IListenerStripper {
        private final JComboBox d_cb;
        private final ItemListener[] d_listeners;
        private final ActionListener[] d_actionListeners;

        public ComboBoxListenerStripper(JComboBox cb) {
            this.d_cb = cb;
            this.d_listeners = cb.getItemListeners();
            for (ItemListener itemListener : this.d_listeners) {
                cb.removeItemListener(itemListener);
            }
            this.d_actionListeners = cb.getActionListeners();
            for (EventListener eventListener : this.d_actionListeners) {
                cb.removeActionListener((ActionListener)eventListener);
            }
        }

        @Override
        public void restore() {
            for (ItemListener itemListener : this.d_listeners) {
                this.d_cb.addItemListener(itemListener);
            }
            for (EventListener eventListener : this.d_actionListeners) {
                this.d_cb.addActionListener((ActionListener)eventListener);
            }
        }
    }

    private static class DefaultListenerStripper<T extends Component>
    implements IListenerStripper {
        private final T d_comp;
        private final KeyListener[] d_keyListeners;
        private final IListenerStripper[] d_strippers;

        public DefaultListenerStripper(T c, IListenerStripper ... strippers) {
            this.d_comp = c;
            this.d_strippers = strippers;
            for (KeyListener listener : this.d_keyListeners = ((Component)c).getKeyListeners()) {
                ((Component)this.d_comp).removeKeyListener(listener);
            }
        }

        public T getComponent() {
            return this.d_comp;
        }

        @Override
        public void restore() {
            for (KeyListener listener : this.d_keyListeners) {
                ((Component)this.d_comp).addKeyListener(listener);
            }
            for (IListenerStripper stripper : this.d_strippers) {
                stripper.restore();
            }
        }
    }

    private static class ListenerStripper<LType>
    implements IListenerStripper {
        private final Consumer<LType> add;
        private final LType[] d_listeners;

        public ListenerStripper(Consumer<LType> add, Supplier<LType[]> get, Consumer<LType> remove) {
            this.add = add;
            for (LType listener : this.d_listeners = get.get()) {
                remove.accept(listener);
            }
        }

        @Override
        public void restore() {
            for (LType listener : this.d_listeners) {
                this.add.accept(listener);
            }
        }
    }

    private static interface IImageRetriever<T> {
        public BufferedImage getImage(T var1) throws IOException;
    }

    public static enum ImageFilter {
        NORMAL,
        DISABLED;

    }
}

