/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import thunderheadeng.gui.Comm;
import thunderheadeng.gui.ComponentGroup2;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.Utils;
import thunderheadeng.gui.Validateable;
import thunderheadeng.gui.WaitCursorMgr;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.gui.guiUtil;

public class guiPanel
extends JPanel
implements Modifiable,
Validateable,
ContainerListener {
    protected final Comm d_comm;
    private WaitCursorMgr d_waitCursorMgr;
    private Map<Component, Integer> d_validateOpts = Collections.EMPTY_MAP;
    private Map<Object, ComponentGroup2<? extends Component>> d_groups = Collections.EMPTY_MAP;

    public guiPanel() {
        this(new BorderLayout());
    }

    public guiPanel(LayoutManager layout) {
        super(layout);
        this.d_comm = new Comm();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Container parent = SwingUtilities.getAncestorOfClass(RootPaneContainer.class, this);
        if (parent != null) {
            this.d_waitCursorMgr = new WaitCursorMgr(parent);
        }
    }

    public void setValidateOptions(Component c, int options) {
        if (options == 0) {
            this.d_validateOpts.remove(c);
            if (this.d_validateOpts.isEmpty()) {
                this.d_validateOpts = Collections.EMPTY_MAP;
            }
        } else {
            if (this.d_validateOpts.isEmpty()) {
                this.d_validateOpts = new IdentityHashMap<Component, Integer>();
            }
            this.d_validateOpts.put(c, options);
        }
    }

    public Comm getComm() {
        return this.d_comm;
    }

    public WaitCursorMgr getWaitCursorMgr() {
        return this.d_waitCursorMgr;
    }

    public void beginWaitCursor() {
        if (this.d_waitCursorMgr != null) {
            this.d_waitCursorMgr.beginWaitCursor();
        }
    }

    public void beginWaitCursor(boolean delay) {
        if (this.d_waitCursorMgr != null) {
            this.d_waitCursorMgr.beginWaitCursor(delay);
        }
    }

    public void beginWaitCursor(int delay) {
        if (this.d_waitCursorMgr != null) {
            this.d_waitCursorMgr.beginWaitCursor(delay);
        }
    }

    public void endWaitCursor() {
        if (this.d_waitCursorMgr != null) {
            this.d_waitCursorMgr.endWaitCursor();
        }
    }

    @Override
    public boolean isModified() {
        return guiPanel.isModified(this);
    }

    public <T extends Component> ComponentGroup2<T> group(Object name, T ... components) {
        return this.group(name, (Collection<T>)Arrays.asList(components));
    }

    public <T extends Component> ComponentGroup2<T> group(Object name, Collection<T> components) {
        if (this.d_groups.isEmpty()) {
            this.d_groups = new HashMap<Object, ComponentGroup2<? extends Component>>();
        }
        ComponentGroup2<T> group = guiUtil.group(components);
        this.d_groups.put(name, group);
        return group;
    }

    public ComponentGroup2<? extends Component> getGroup(Object name) {
        return this.d_groups.get(name);
    }

    public void setGroupEnabled(Object name, boolean enabled) {
        ComponentGroup2<? extends Component> group = this.d_groups.get(name);
        if (group != null) {
            group.setEnabled(enabled);
        }
    }

    public void setGroupVisible(Object name, boolean visible) {
        ComponentGroup2<? extends Component> group = this.d_groups.get(name);
        if (group != null) {
            group.setVisible(visible);
        }
    }

    protected void ungroup(Object name) {
        this.d_groups.remove(name);
        if (this.d_groups.isEmpty()) {
            this.d_groups = Collections.EMPTY_MAP;
        }
    }

    private static boolean isModified(Container c) {
        int count = c.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component comp = c.getComponent(i);
            if (comp instanceof Modifiable && ((Modifiable)((Object)comp)).isModified()) {
                return true;
            }
            if (!(comp instanceof Container) || !guiPanel.isModified((Container)comp)) continue;
            return true;
        }
        return false;
    }

    public final boolean validateData() throws Exception {
        throw new Exception("Fail. Epic Fail.");
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        return guiPanel.validateData(this, this.d_validateOpts, showWarn, allowModify);
    }

    private static boolean validateData(Container c, Map<Component, Integer> options, boolean showWarn, boolean allowModify) {
        int count = c.getComponentCount();
        for (int i = 0; i < count; ++i) {
            int voptions;
            Component comp = c.getComponent(i);
            if (!guiUtil.shouldValidateChild(comp, voptions = options.getOrDefault(comp, 0).intValue()) || !(comp instanceof Validateable ? !((Validateable)((Object)comp)).validateData(showWarn, allowModify) : comp instanceof Container && !guiPanel.validateData((Container)comp, options, showWarn, allowModify))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setModified(boolean modified) {
        guiPanel.setModified(this, modified);
        this.d_comm.touch(this);
    }

    private static void setModified(Container c, boolean modified) {
        int count = c.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component comp = c.getComponent(i);
            if (comp instanceof Modifiable) {
                ((Modifiable)((Object)comp)).setModified(modified);
                continue;
            }
            if (!(comp instanceof Container)) continue;
            guiPanel.setModified((Container)comp, modified);
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        this.register(comp);
    }

    protected void register(Component c) {
        assert (c != this);
        if (c instanceof guiFormattedFld) {
            ((guiFormattedFld)c).addValueChangeListener(this.d_comm);
        } else if (c instanceof JTable) {
            ((JTable)c).getModel().addTableModelListener(this.d_comm);
        } else if (c instanceof JTextField) {
            ((JTextField)c).getDocument().addDocumentListener(this.d_comm);
        } else if (c instanceof AbstractButton) {
            ((AbstractButton)c).addActionListener(this.d_comm);
        } else if (c instanceof JComboBox) {
            ((JComboBox)c).addActionListener(this.d_comm);
        } else if (c instanceof guiPanel) {
            ((guiPanel)c).addObserver(this.d_comm);
        } else if (c instanceof Container) {
            ((Container)c).addContainerListener(this);
            Component[] childs = ((Container)c).getComponents();
            for (int i = 0; i < childs.length; ++i) {
                this.register(childs[i]);
            }
        }
    }

    protected void unregister(Component c) {
        assert (c != this);
        if (c instanceof guiFormattedFld) {
            ((guiFormattedFld)c).removeValueChangeListener(this.d_comm);
        } else if (c instanceof JTextField) {
            ((JTextField)c).getDocument().removeDocumentListener(this.d_comm);
        } else if (c instanceof AbstractButton) {
            ((AbstractButton)c).removeActionListener(this.d_comm);
        } else if (c instanceof JComboBox) {
            ((JComboBox)c).removeActionListener(this.d_comm);
        } else if (c instanceof guiPanel) {
            ((guiPanel)c).addObserver(this.d_comm);
        } else if (c instanceof Container) {
            ((Container)c).removeContainerListener(this);
            Component[] childs = ((Container)c).getComponents();
            for (int i = 0; i < childs.length; ++i) {
                this.unregister(childs[i]);
            }
        }
    }

    public void addObserver(Observer o) {
        this.d_comm.addObserver(o);
    }

    public void removeObserver(Observer o) {
        this.d_comm.deleteObserver(o);
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        Utils.setEnabled(this.getComponents(), enable);
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        this.register(e.getChild());
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        this.unregister(e.getChild());
    }
}

