/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.function.Predicate;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.ValueRange;

public class guiInputDlg<T>
extends guiDialog {
    private final ValueField<T> d_field;

    public guiInputDlg(Window parent, String title, String message, T defaultValue, ValueRange<T> range, Class<T> clazz) {
        this(parent, title, message, guiInputDlg.getFieldFor(defaultValue, range, clazz), defaultValue, clazz);
    }

    public guiInputDlg(Window parent, String title, String message, ValueField<T> field, T defaultValue, Class<T> clazz) {
        super(parent, title, 9);
        this.d_field = field;
        this.d_field.setValue(defaultValue);
        guiPanel mainPanel = this.getDialogPane();
        mainPanel.setLayout(new GridBagLayout());
        guiPanel inputPanel = new guiPanel(new GridBagLayout());
        GridBagUtil.add(inputPanel, new guiLabel(message), 0, 0, 1, 1, 0, 0, 6, 0, 2, 0.0, 0.0, 10);
        GridBagUtil.add(inputPanel, this.d_field, 0, 1, 1, 1, 0, 0, 0, 0, 2, 0.0, 0.0, 10);
        GridBagUtil.add(mainPanel, inputPanel, 1, 0, 1, 1, 0, 0, 0, 0, 2, 0.0, 0.0, 10);
    }

    public static <T> T getValue(Window parent, String title, String message, ValueRange<T> range, T defaultValue, Class<T> clazz) {
        guiInputDlg<T> dlg = new guiInputDlg<T>(parent, title, message, defaultValue, range, clazz);
        if (dlg.doModal() == 1) {
            return dlg.getValue();
        }
        return null;
    }

    public static <T> T getValue(Window parent, String title, String message, T defaultValue, Class<T> clazz) {
        return guiInputDlg.getValue(parent, title, message, null, defaultValue, clazz);
    }

    public static Double getDouble(Window parent, String title, String message, DoubleVR range, double defaultValue) {
        return guiInputDlg.getValue(parent, title, message, range, defaultValue, Double.class);
    }

    public static Double getDouble(Window parent, String title, String message, double defaultValue) {
        return guiInputDlg.getValue(parent, title, message, DoubleVR.UNBOUNDED, defaultValue, Double.class);
    }

    public static UnitDouble getUnitDouble(Window parent, String title, String message, UnitDoubleVR range, UnitDouble defaultValue) {
        return guiInputDlg.getValue(parent, title, message, range, defaultValue, UnitDouble.class);
    }

    public static UnitDouble getUnitDouble(Window parent, String title, String message, UnitDouble defaultValue) {
        return guiInputDlg.getValue(parent, title, message, UnitDoubleVR.UNBOUNDED, defaultValue, UnitDouble.class);
    }

    public static Integer getInteger(Window parent, String title, String message, IntVR range, int defaultValue) {
        return guiInputDlg.getValue(parent, title, message, range, defaultValue, Integer.class);
    }

    public static Integer getInteger(Window parent, String title, String message, int defaultValue) {
        return guiInputDlg.getValue(parent, title, message, IntVR.UNBOUNDED, defaultValue, Integer.class);
    }

    public T getValue() {
        return this.d_field.getValue();
    }

    private static <T> ValueField<T> getFieldFor(T defaultValue, ValueRange<T> range, Class<T> clazz) {
        ValueField<Comparable<Double>> field = null;
        if (Double.class.isAssignableFrom(clazz)) {
            field = ValueFields.doubleFld((Double)defaultValue, (DoubleVR)range);
        } else if (UnitDouble.class.isAssignableFrom(clazz)) {
            field = ValueFields.udFld((UnitDouble)defaultValue, (Predicate<UnitDouble>)((UnitDoubleVR)range));
        } else if (Integer.class.isAssignableFrom(clazz)) {
            field = ValueFields.intFld((Integer)defaultValue, (IntVR)range);
        }
        if (field != null) {
            field.setColumns(25);
        }
        return field;
    }
}

