/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.Command;
import thunderheadeng.gui.View;
import thunderheadeng.gui.WaitCursorMgr;

public class guiFrame
extends JFrame {
    private View d_view;
    private Command d_closeCommand;
    private final WaitCursorMgr d_waitCursorMgr;
    private final FrameProps d_frameProps;

    public guiFrame() {
        this((String)null);
    }

    public guiFrame(String title) {
        super(title, Application.getDefaultGraphicsConfiguration());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                Application app = Application.getApp();
                if (app != null) {
                    app.setActiveView(guiFrame.this.d_view);
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                guiFrame.this.close();
            }
        });
        this.d_waitCursorMgr = new WaitCursorMgr(this);
        this.d_frameProps = new FrameProps();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                this.saveBounds(e);
            }

            @Override
            public void componentResized(ComponentEvent e) {
                this.saveBounds(e);
            }

            private void saveBounds(ComponentEvent e) {
                guiFrame.this.d_frameProps.update(guiFrame.this);
            }
        });
    }

    @Override
    public void setExtendedState(int state) {
        super.setExtendedState(state);
        this.d_frameProps.update(this);
    }

    public FrameProps getFrameProps() {
        return this.d_frameProps;
    }

    public WaitCursorMgr getWaitCursorMgr() {
        return this.d_waitCursorMgr;
    }

    public void beginWaitCursor() {
        this.d_waitCursorMgr.beginWaitCursor();
    }

    public void beginWaitCursor(boolean delay) {
        this.d_waitCursorMgr.beginWaitCursor(delay);
    }

    public void beginWaitCursor(int delay) {
        this.d_waitCursorMgr.beginWaitCursor(delay);
    }

    public void endWaitCursor() {
        this.d_waitCursorMgr.endWaitCursor();
    }

    public boolean close() {
        if (this.d_closeCommand != null) {
            this.d_closeCommand.execute();
            return !this.d_closeCommand.breakCommandChain();
        }
        if (this.d_view != null) {
            if (!this.d_view.close()) {
                return false;
            }
            Application.getApp().getDocument().removeView(this.d_view);
        }
        this.dispose();
        return true;
    }

    @Override
    public void dispose() {
        Application app = Application.getApp();
        if (app != null) {
            app.removeFrame(this);
        }
        super.dispose();
    }

    public void setSize(double sizeFactor) {
        if (sizeFactor <= 0.0) {
            this.setExtendedState(1);
        } else if (sizeFactor > 1.0) {
            this.setExtendedState(6);
        } else {
            this.setExtendedState(0);
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            int ht = (int)(sizeFactor * (double)screen.height);
            int wid = ht * 4 / 3;
            this.setSize(wid, ht);
        }
    }

    public void center() {
        this.setLocationRelativeTo(null);
    }

    public void setView(View theView) {
        this.d_view = theView;
    }

    public View getView() {
        return this.d_view;
    }

    public void setCloseCommand(Command c) {
        this.d_closeCommand = c;
    }

    public static class FrameProps {
        public Rectangle lastBounds = null;
        public int lastExtendedState = 0;

        protected void update(guiFrame frame) {
            int estate = frame.getExtendedState();
            if (estate != 1) {
                this.lastExtendedState = estate;
            }
            if (estate == 0) {
                this.lastBounds = frame.getBounds();
            }
        }
    }
}

