/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;
import thunderheadeng.Intl;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.Validateable;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.theUtil;

public class guiFormattedFld<T>
extends JFormattedTextField
implements Modifiable,
Validateable {
    public static final int VAL_COMMIT = ValueAction.COMMIT.id;
    public static final int VAL_CANCEL = ValueAction.CANCEL.id;
    public static final int VAL_CHANGE = ValueAction.CHANGE.id;
    private static final String CUT = "cut-to-clipboard";
    private static final String COPY = "copy-to-clipboard";
    private static final String PASTE = "paste-from-clipboard";
    private static final String DELETE_SELECTION = "delete-selection";
    private static final String SELECT_ALL = "select-all";
    private boolean d_selectAll;
    private boolean d_modified;
    private boolean d_selectAllOnFocusEnabled;
    private PropertyChangeListener d_highlightOnErrorListener;
    private Map<Object, Action> d_rightClickMenuActions;
    private JPopupMenu d_rightClickMenu;
    private static final KeyStroke s_commitKS = KeyStroke.getKeyStroke(10, 0);
    private static final KeyStroke s_cancelKS = KeyStroke.getKeyStroke(27, 0);

    public guiFormattedFld(Format format, T initValue) {
        this(new Formatter(format), initValue);
    }

    public guiFormattedFld(Formatter<T> formatter, T initValue) {
        this((JFormattedTextField.AbstractFormatterFactory)new DefaultFormatterFactory(formatter), initValue);
    }

    public guiFormattedFld(JFormattedTextField.AbstractFormatterFactory formatterFactory, T initValue) {
        super(new FormatterFactory(formatterFactory, false));
        this.init(initValue);
    }

    private void init(T initValue) {
        this.d_selectAll = true;
        this.d_selectAllOnFocusEnabled = true;
        this.d_highlightOnErrorListener = null;
        Dimension d = this.getPreferredSize();
        this.setPreferredSize(new Dimension(90, d.height));
        this.setHorizontalAlignment(2);
        this.setInputVerifier(new Verifier(true));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                guiFormattedFld.this.d_selectAll = false;
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                Component c = e.getComponent();
                if (c.isEnabled() && e.isPopupTrigger()) {
                    JPopupMenu menu = guiFormattedFld.this.getRightClickMenu();
                    menu.setLocation(e.getPoint());
                    menu.show(c, e.getX(), e.getY());
                }
            }
        });
        this.addValueListener(VAL_CHANGE, evt -> {
            if (!theUtil.equal(evt.getOldValue(), evt.getNewValue())) {
                this.d_modified = true;
            }
        });
        this.setHighlightOnError(true);
        this.setFocusLostBehavior(0);
        this.setValue(initValue);
        this.setModified(false);
    }

    @Override
    public void commitEdit() throws ParseException {
        super.commitEdit();
        this.firePropertyChange(ValueAction.COMMIT.name, false, true);
    }

    public Format getFormat() {
        if (this.getFormatter() instanceof Formatter) {
            return ((Formatter)this.getFormatter()).getFormat();
        }
        return null;
    }

    public Predicate<T> getFilter() {
        return this.getFormatter() instanceof Formatter ? ((Formatter)this.getFormatter()).getFilter() : Filters.acceptAll();
    }

    public void setFilter(Predicate<T> filter) {
        if (this.getFormatter() instanceof Formatter) {
            ((Formatter)this.getFormatter()).setFilter(filter);
        }
    }

    public boolean getNullAllowed() {
        return this.getFormatter() instanceof Formatter ? ((Formatter)this.getFormatter()).d_nullAllowed : true;
    }

    public void setNullAllowed(boolean allowed) {
        if (this.getFormatter() instanceof Formatter) {
            ((Formatter)this.getFormatter()).setNullAllowed(allowed);
        }
    }

    public void setHighlightOnError(boolean highlight) {
        if (highlight && this.d_highlightOnErrorListener == null) {
            this.d_highlightOnErrorListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    guiFormattedFld.this.updateValidState();
                }
            };
            this.addPropertyChangeListener("editValid", this.d_highlightOnErrorListener);
        } else if (!highlight && this.d_highlightOnErrorListener != null) {
            this.removePropertyChangeListener("editValid", this.d_highlightOnErrorListener);
            this.d_highlightOnErrorListener = null;
        }
        this.updateValidState();
    }

    public boolean getHightlightOnError() {
        return this.d_highlightOnErrorListener != null;
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.isTemporary()) {
            return;
        }
        if (e.getID() == 1005) {
            this.d_selectAll = true;
        } else if (this.d_selectAllOnFocusEnabled && this.d_selectAll) {
            this.selectAll();
        }
    }

    protected void updateValidState() {
        if (!this.getHightlightOnError() || this.isEditValid()) {
            Border border = this.getBorder();
            if (border instanceof InvalidBorder) {
                InvalidBorder iborder = (InvalidBorder)border;
                Border existing = iborder.getInsideBorder();
                this.setBorder(existing);
            }
        } else {
            Border border = this.getBorder();
            if (!(border instanceof InvalidBorder)) {
                this.setBorder(new InvalidBorder(border));
            }
        }
    }

    public void setSelectAllOnFocus(boolean enabled) {
        this.d_selectAllOnFocusEnabled = enabled;
    }

    public boolean getSelectAllOnFocus() {
        return this.d_selectAllOnFocusEnabled;
    }

    public void setYieldFocusOnError(boolean enabled) {
        ((Verifier)this.getInputVerifier()).setYieldFocusOnErrorEnabled(enabled);
    }

    public boolean getYieldFocusOnError() {
        return ((Verifier)this.getInputVerifier()).isYieldFocusOnErrorEnabled();
    }

    public void setDefaultCommand(final Consumer<? super ActionEvent> command) {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "defaultCommand");
        this.getActionMap().put("defaultCommand", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                command.accept(e);
            }
        });
    }

    public void setCommitOnValidEdit(boolean enabled) {
        FormatterFactory current = this.getFormatterFactory();
        if (current != null) {
            current.setCommitOnValidEdit(this, enabled);
        }
    }

    public boolean getCommitOnValidEdit() {
        return this.getFormatterFactory().d_commitOnValidEdit;
    }

    public void addValueChangeListener(PropertyChangeListener listener) {
        this.addValueListener(VAL_CHANGE, listener);
    }

    public void removeValueChangeListener(PropertyChangeListener listener) {
        this.removeValueListener(VAL_CHANGE, listener);
    }

    public PropertyChangeListener[] getValueChangeListeners() {
        return theUtil.toArray(this.getValueListeners(VAL_CHANGE), PropertyChangeListener.class);
    }

    public void addValueCommitListener(PropertyChangeListener listener) {
        this.addValueListener(VAL_COMMIT, listener);
    }

    public void removeValueCommitListener(PropertyChangeListener listener) {
        this.removeValueListener(VAL_COMMIT, listener);
    }

    public PropertyChangeListener[] getValueCommitListeners() {
        return theUtil.toArray(this.getValueListeners(VAL_COMMIT), PropertyChangeListener.class);
    }

    public static int getValueChangeId(String name) {
        for (ValueAction type : ValueAction.values()) {
            if (!name.equals(type.name)) continue;
            return type.id;
        }
        return -1;
    }

    public void addValueListener(int types, PropertyChangeListener listener) {
        for (ValueAction type : ValueAction.values()) {
            if ((types & type.id) != type.id) continue;
            this.addPropertyChangeListener(type.name, listener);
        }
    }

    public void removeValueListener(int types, PropertyChangeListener listener) {
        for (ValueAction type : ValueAction.values()) {
            if ((types & type.id) != type.id) continue;
            this.removePropertyChangeListener(type.name, listener);
        }
    }

    public Collection<PropertyChangeListener> getValueListeners(int types) {
        ArrayList<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
        for (ValueAction type : ValueAction.values()) {
            if ((types & type.id) != type.id) continue;
            listeners.addAll(Arrays.asList(this.getPropertyChangeListeners(type.name)));
        }
        return listeners;
    }

    private JPopupMenu getRightClickMenu() {
        if (this.d_rightClickMenu == null) {
            this.d_rightClickMenu = new JPopupMenu();
            this.d_rightClickMenuActions = new HashMap<Object, Action>();
            DefaultEditorKit.CutAction cut = new DefaultEditorKit.CutAction();
            cut.putValue("Name", Intl.intl("Cut"));
            cut.putValue("SmallIcon", guiUtil.loadTeciIcon("Cut16.gif"));
            DefaultEditorKit.CopyAction copy = new DefaultEditorKit.CopyAction();
            copy.putValue("Name", Intl.intl("Copy"));
            copy.putValue("SmallIcon", guiUtil.loadTeciIcon("Copy16.gif"));
            DefaultEditorKit.PasteAction paste = new DefaultEditorKit.PasteAction();
            paste.putValue("Name", Intl.intl("Paste"));
            paste.putValue("SmallIcon", guiUtil.loadTeciIcon("Paste16.gif"));
            AbstractAction delete = new AbstractAction(Intl.intl("Delete")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    guiFormattedFld.this.replaceSelection("");
                }
            };
            delete.putValue("SmallIcon", guiUtil.loadTeciIcon("Delete16.gif"));
            AbstractAction selectAll = new AbstractAction(Intl.intl("Select All")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    guiFormattedFld.this.selectAll();
                }
            };
            this.d_rightClickMenuActions.put(CUT, cut);
            this.d_rightClickMenuActions.put(COPY, copy);
            this.d_rightClickMenuActions.put(PASTE, paste);
            this.d_rightClickMenuActions.put(DELETE_SELECTION, delete);
            this.d_rightClickMenuActions.put(SELECT_ALL, selectAll);
            this.d_rightClickMenu.add(cut);
            this.d_rightClickMenu.add(copy);
            this.d_rightClickMenu.add(paste);
            this.d_rightClickMenu.add(delete);
            this.d_rightClickMenu.addSeparator();
            this.d_rightClickMenu.add(selectAll);
        }
        String selText = this.getSelectedText();
        boolean canEdit = this.isEnabled() && this.isEditable();
        this.d_rightClickMenuActions.get(CUT).setEnabled(selText != null && canEdit);
        this.d_rightClickMenuActions.get(COPY).setEnabled(selText != null);
        this.d_rightClickMenuActions.get(PASTE).setEnabled(canEdit);
        this.d_rightClickMenuActions.get(DELETE_SELECTION).setEnabled(selText != null && canEdit);
        this.d_rightClickMenuActions.get(SELECT_ALL).setEnabled(!this.getText().isEmpty() && (selText == null || selText.length() < this.getText().length()));
        return this.d_rightClickMenu;
    }

    public T getValue() {
        return (T)super.getValue();
    }

    public boolean isEmpty() {
        return this.getText().trim().equals("");
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        boolean processed = super.processKeyBinding(ks, e, condition, pressed);
        if (processed && ks.equals(s_commitKS) && this.isEditValid()) {
            this.setValue(this.getValue());
            this.selectAll();
        } else if (processed && ks.equals(s_cancelKS)) {
            this.selectAll();
            this.firePropertyChange(ValueAction.CANCEL.name, false, true);
        }
        return processed;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        try {
            InputVerifier verifier = this.getInputVerifier();
            ((Verifier)verifier).check(this);
            if (allowModify) {
                this.commitEdit();
            }
        }
        catch (ParseException e) {
            if (showWarn) {
                this.showMessageBox(e.getLocalizedMessage(), true);
            }
            if (allowModify) {
                this.requestFocusHack();
            }
            return false;
        }
        return true;
    }

    protected void showMessageBox(String msg) {
        this.showMessageBox(msg, false);
    }

    protected void showMessageBox(String msg, boolean removeFocusListeners) {
        int focusLostBehavior = this.getFocusLostBehavior();
        FocusListener[] listeners = null;
        if (removeFocusListeners) {
            this.setFocusLostBehavior(3);
            for (FocusListener listener : listeners = this.getFocusListeners()) {
                this.removeFocusListener(listener);
            }
        }
        Window parent = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        JOptionPane.showMessageDialog(parent, msg, Intl.intl("Invalid Entry"), 2);
        if (removeFocusListeners) {
            for (FocusListener listener : listeners) {
                this.addFocusListener(listener);
            }
            this.setFocusLostBehavior(focusLostBehavior);
        }
    }

    protected void requestFocusHack() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                guiFormattedFld.this.requestFocus();
            }
        });
    }

    @Override
    public final void setInputVerifier(InputVerifier inputVerifier) {
        if (!(inputVerifier instanceof Verifier)) {
            return;
        }
        this.setInputVerifier((Verifier)inputVerifier);
    }

    public void setInputVerifier(Verifier<T> inputVerifier) {
        super.setInputVerifier(inputVerifier);
    }

    @Override
    public Verifier<T> getInputVerifier() {
        return (Verifier)super.getInputVerifier();
    }

    @Override
    public JFormattedTextField.AbstractFormatter getFormatter() {
        return super.getFormatter();
    }

    public void setFormatter(Formatter formatter) {
        this.setFormatterFactory(new DefaultFormatterFactory(formatter));
    }

    @Override
    public void setFormatterFactory(JFormattedTextField.AbstractFormatterFactory tf) {
        if (!(tf instanceof FormatterFactory)) {
            FormatterFactory curr = this.getFormatterFactory();
            tf = curr != null ? curr.newFactory(tf) : new FormatterFactory(tf, false);
        }
        super.setFormatterFactory(tf);
    }

    @Override
    public FormatterFactory getFormatterFactory() {
        return (FormatterFactory)super.getFormatterFactory();
    }

    public static class Verifier<T>
    extends InputVerifier {
        private boolean d_yieldFocusOnError;

        public Verifier(boolean yieldFocusOnError) {
            this.d_yieldFocusOnError = yieldFocusOnError;
        }

        public boolean isYieldFocusOnErrorEnabled() {
            return this.d_yieldFocusOnError;
        }

        public void setYieldFocusOnErrorEnabled(boolean enabled) {
            this.d_yieldFocusOnError = enabled;
        }

        @Override
        public boolean verify(JComponent input) {
            try {
                this.check(input);
            }
            catch (ParseException e) {
                return false;
            }
            return true;
        }

        @Override
        public boolean shouldYieldFocus(JComponent input) {
            return this.isYieldFocusOnErrorEnabled() || super.shouldYieldFocus(input);
        }

        public void check(JComponent input) throws ParseException {
            assert (input instanceof guiFormattedFld);
            guiFormattedFld fld = (guiFormattedFld)input;
            JFormattedTextField.AbstractFormatter formatter = fld.getFormatter();
            if (formatter != null) {
                String text = fld.getText();
                formatter.stringToValue(text);
            }
        }
    }

    public static class Formatter<T>
    extends InternationalFormatter
    implements IObserver {
        private Predicate<T> d_filter;
        private boolean d_nullAllowed;

        public Formatter(Format format) {
            this(format, null, false);
        }

        public Formatter(Format format, Predicate<T> filter) {
            this(format, filter, false);
        }

        public Formatter(Format format, boolean nullAllowed) {
            this(format, null, nullAllowed);
        }

        public Formatter(Format format, Predicate<T> filter, boolean nullAllowed) {
            super(format);
            if (format instanceof IObservable) {
                ((IObservable)((Object)format)).addObserver(this, true);
            }
            this.d_filter = filter;
            this.d_nullAllowed = nullAllowed;
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Formatter clone = (Formatter)super.clone();
            if (clone.getFormat() instanceof IObservable) {
                ((IObservable)((Object)clone.getFormat())).addObserver(clone, true);
            }
            return clone;
        }

        public Formatter newFormatter(Format format) {
            return this.newFormatter(format, null);
        }

        public Formatter newFormatter(Format format, Predicate<T> filter) {
            try {
                Formatter formatter = (Formatter)this.clone();
                formatter.setFormat(format);
                formatter.d_filter = filter;
                formatter.d_nullAllowed = this.d_nullAllowed;
                return formatter;
            }
            catch (CloneNotSupportedException e) {
                assert (false);
                return new Formatter<T>(format);
            }
        }

        @Override
        public void setFormat(Format format) {
            if (this.getFormat() instanceof IObservable) {
                ((IObservable)((Object)this.getFormat())).deleteObserver(this);
            }
            super.setFormat(format);
            if (format instanceof IObservable) {
                ((IObservable)((Object)format)).addObserver(this, true);
            }
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            Format f = this.getFormat();
            if (f == null) {
                if (value == null) {
                    return "";
                }
                return value.toString();
            }
            return f.format(value);
        }

        @Override
        public void install(JFormattedTextField ftf) {
            if (ftf != null) {
                JFormattedTextField oldField = this.getFormattedTextField();
                int oldLength = ftf.getDocument().getLength();
                int oldPosition = ftf.getCaretPosition();
                super.install(ftf);
                if (oldField == ftf && oldLength == ftf.getDocument().getLength()) {
                    ftf.setCaretPosition(oldPosition);
                }
            } else {
                super.install(ftf);
            }
        }

        @Override
        public void update(IObservable source, Object arg) {
            JFormattedTextField fld = this.getFormattedTextField();
            if (fld != null && !fld.isFocusOwner()) {
                this.uninstall();
                if (fld.getFormatter() == this) {
                    this.install(fld);
                } else {
                    this.install(null);
                }
            }
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            Object value = super.stringToValue(text);
            if (value == null && !this.isNullAllowed()) {
                throw new ParseException(Intl.intl("Empty values are not allowed."), 0);
            }
            if (this.d_filter != null && value != null && !this.d_filter.test(value)) {
                throw new ParseException(this.d_filter.toString(), 0);
            }
            return value;
        }

        public Predicate<T> getFilter() {
            return this.d_filter;
        }

        public void setFilter(Predicate<T> filter) {
            this.d_filter = filter;
        }

        public boolean isNullAllowed() {
            return this.d_nullAllowed;
        }

        public void setNullAllowed(boolean allowed) {
            this.d_nullAllowed = allowed;
        }
    }

    public static class FormatterFactory
    extends JFormattedTextField.AbstractFormatterFactory
    implements Cloneable {
        private boolean d_commitOnValidEdit;
        private JFormattedTextField.AbstractFormatterFactory d_baseFactory;

        public FormatterFactory(JFormattedTextField.AbstractFormatterFactory baseFactory, boolean commitOnValidEdit) {
            this.d_baseFactory = baseFactory;
            this.d_commitOnValidEdit = commitOnValidEdit;
        }

        @Override
        public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
            JFormattedTextField.AbstractFormatter formatter = this.d_baseFactory.getFormatter(tf);
            this.updateFormatter(formatter);
            return formatter;
        }

        public FormatterFactory clone() {
            try {
                FormatterFactory factory = (FormatterFactory)super.clone();
                return factory;
            }
            catch (CloneNotSupportedException e) {
                assert (false);
                return null;
            }
        }

        public FormatterFactory newFactory(JFormattedTextField.AbstractFormatterFactory baseFactory) {
            FormatterFactory clone = this.clone();
            clone.d_baseFactory = baseFactory;
            return clone;
        }

        public void setCommitOnValidEdit(JFormattedTextField field, boolean enabled) {
            this.d_commitOnValidEdit = enabled;
            this.updateFormatter(field.getFormatter());
        }

        public void updateFormatter(JFormattedTextField.AbstractFormatter formatter) {
            if (formatter instanceof DefaultFormatter) {
                ((DefaultFormatter)formatter).setCommitsOnValidEdit(this.d_commitOnValidEdit);
            }
        }
    }

    protected static class InvalidBorder
    extends CompoundBorder {
        public InvalidBorder(Border innerBorder) {
            super(BorderFactory.createLineBorder(Color.RED), innerBorder);
        }
    }

    private static enum ValueAction {
        COMMIT("commit", 1),
        CANCEL("cancel", 2),
        CHANGE("value", 4);

        public final String name;
        public final int id;

        private ValueAction(String name, int id) {
            this.name = name;
            this.id = id;
        }
    }
}

