/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;
import thunderheadeng.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.io.CompositeFileFilter;
import thunderheadeng.io.ExampleFileFilter;
import thunderheadeng.io.FilenameManager;

public class guiFileChooser
extends JFileChooser {
    private boolean d_mustExist = true;
    private boolean d_promptOverwrite = true;
    private boolean d_allowPathCreate = true;
    private final CompositeFileFilter d_allSupportedTypesFilter = new CompositeFileFilter(Intl.intl("All Supported Types"));

    public guiFileChooser() {
        String dir = null;
        if (Application.getApp() != null) {
            dir = Application.getApp().getWorkingDir();
        }
        if (dir != null) {
            this.setCurrentDirectory(new File(dir));
        }
    }

    public guiFileChooser(FileFilter filter) {
        this();
        this.addChoosableFileFilter(filter);
    }

    public guiFileChooser(String extension, String description) {
        this();
        ExampleFileFilter filter = new ExampleFileFilter();
        filter.addExtension(extension);
        filter.setDescription(description);
        this.addChoosableFileFilter(filter);
    }

    @Override
    public void setFileFilter(FileFilter filter) {
        super.setFileFilter(filter);
        if (filter instanceof ExampleFileFilter && this.getUI() instanceof BasicFileChooserUI) {
            String[] split;
            BasicFileChooserUI ui = (BasicFileChooserUI)this.getUI();
            ExampleFileFilter eff = (ExampleFileFilter)filter;
            String[] filters = eff.getFilters();
            String name = ui.getFileName();
            if (!(name.isEmpty() || filters.length <= 0 || eff.accept(new File(name)) || (split = FilenameManager.splitFilename(name))[0].isEmpty() || split[1].isEmpty())) {
                name = split[0] + "." + filters[0];
                ui.setFileName(name);
            }
        }
    }

    @Override
    public void setCurrentDirectory(File f) {
        this.setCurrentDirectory(f, true);
    }

    public void setCurrentDirectory(File f, boolean cwd) {
        super.setCurrentDirectory(f);
        if (Application.getApp() != null && cwd && f != null) {
            Application.getApp().setWorkingDir(f.getPath());
        }
    }

    public void setMustExist(boolean mustExist) {
        this.d_mustExist = mustExist;
    }

    public boolean getMustExist() {
        return this.d_mustExist;
    }

    public void setPromptOverwrite(boolean promptOverwrite) {
        this.d_promptOverwrite = promptOverwrite;
    }

    public boolean getPromptOverwrite() {
        return this.d_promptOverwrite;
    }

    public void setAllowPathCreate(boolean allowPathCreate) {
        this.d_allowPathCreate = allowPathCreate;
    }

    public boolean getAllowPathCreate() {
        return this.d_allowPathCreate;
    }

    public String getFilename() {
        try {
            return this.getSelectedFile().getCanonicalPath();
        }
        catch (IOException e) {
            return this.getSelectedFile().getAbsolutePath();
        }
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) {
        int option = super.showDialog(parent, approveButtonText);
        if (option == 0 && Application.getApp() != null) {
            Application.getApp().setWorkingDir(this.getSelectedFile().getParent());
        }
        return option;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void approveSelection() {
        block12: {
            File file;
            block11: {
                file = this.getSelectedFile();
                if (this.getDialogType() != 1) break block11;
                if ((file = this.addExtension(file)) != null && file.exists()) {
                    int option;
                    if (!file.canWrite()) {
                        JOptionPane.showMessageDialog(this, Intl.intl("File is read-only. Please choose another file name."), Intl.intl("Read-only"), 0);
                        return;
                    }
                    if (this.d_promptOverwrite && (option = JOptionPane.showOptionDialog(this, Intl.intl("File already exists. Overwrite?"), Intl.intl("Overwrite existing file?"), 0, 3, null, null, null)) != 0) {
                        return;
                    }
                    break block12;
                } else {
                    if (file == null) {
                        JOptionPane.showMessageDialog(this, Intl.intl("The specified path does not exist. Please create the directory or save to an existing directory."), Intl.intl("Directory does not exist"), 1);
                        return;
                    }
                    if (!guiFileChooser.isFilenameLegal(file.getAbsolutePath())) {
                        JOptionPane.showMessageDialog(this, Intl.intl("Cannot create the specified path because it contains any of the following illegal characters:\n: * ? \" < > |"), Intl.intl("Illegal Characters"), 1);
                        return;
                    }
                    File path = file.getParentFile();
                    if (!path.exists()) {
                        if (!this.getAllowPathCreate()) {
                            JOptionPane.showMessageDialog(this, Intl.intl("The specified path does not exist. Please create the directory or save to an existing directory."), Intl.intl("Directory does not exist"), 1);
                            return;
                        }
                        if (!path.mkdir()) {
                            JOptionPane.showMessageDialog(this, Intl.intl("Could not create the specified path. Please enter a valid pathname where you have write access."), Intl.intl("Could not create path"), 1);
                            return;
                        }
                    }
                }
                break block12;
            }
            if (this.getDialogType() == 0) {
                file = this.addExtension(file);
                if (this.d_mustExist && (file == null || !file.exists())) {
                    JOptionPane.showMessageDialog(this, Intl.intl("Can't find selected file. Please select an existing file."), Intl.intl("Can't find file"), 1);
                    return;
                }
            }
        }
        super.approveSelection();
    }

    private File addExtension(File file) {
        FileFilter curFilter = this.getFileFilter();
        if (curFilter != null && curFilter instanceof ExampleFileFilter) {
            String[] filters = ((ExampleFileFilter)curFilter).getFilters();
            if (file != null && filters != null && filters.length > 0) {
                String name = null;
                try {
                    name = file.getCanonicalPath();
                }
                catch (IOException e) {
                    name = file.getAbsolutePath();
                }
                if (name.indexOf(46) < 0) {
                    file = new File(name + "." + filters[0]);
                    this.setSelectedFile(file);
                }
            }
        }
        return file;
    }

    @Override
    public void resetChoosableFileFilters() {
        this.d_allSupportedTypesFilter.resetFilters();
        super.resetChoosableFileFilters();
    }

    @Override
    public void addChoosableFileFilter(FileFilter filter) {
        super.addChoosableFileFilter(filter);
        this.setFileFilter(filter);
        if (this.d_allSupportedTypesFilter != null && filter != this.getAcceptAllFileFilter()) {
            this.d_allSupportedTypesFilter.addFilter(filter);
        }
    }

    @Override
    public boolean removeChoosableFileFilter(FileFilter f) {
        boolean result = super.removeChoosableFileFilter(f);
        if (this.d_allSupportedTypesFilter != null) {
            this.d_allSupportedTypesFilter.removeFilter(f);
        }
        return result;
    }

    public CompositeFileFilter getAllSupportedTypesFilter() {
        return this.d_allSupportedTypesFilter;
    }

    public void setAllSupportedTypesFilterEnabled(boolean enabled) {
        if (enabled) {
            super.addChoosableFileFilter(this.d_allSupportedTypesFilter);
            this.setFileFilter(this.d_allSupportedTypesFilter);
        } else {
            super.removeChoosableFileFilter(this.d_allSupportedTypesFilter);
        }
    }

    public void selectFirstAppropriateFilter(File f) {
        FileFilter[] filters = this.getChoosableFileFilters();
        if (f != null && !f.getName().isEmpty()) {
            for (int m = 0; m < filters.length; ++m) {
                if (!filters[m].accept(f)) continue;
                this.setFileFilter(filters[m]);
                return;
            }
        } else if (filters.length > 0 && this.getFileFilter().equals(this.getAcceptAllFileFilter())) {
            this.setFileFilter(filters[0]);
        }
    }

    private void prepareFilters() {
        if (this.isAcceptAllFileFilterUsed()) {
            this.setAcceptAllFileFilterUsed(true);
        }
        this.selectFirstAppropriateFilter(this.getSelectedFile());
    }

    @Override
    public int showOpenDialog(Component parent) throws HeadlessException {
        this.prepareFilters();
        try {
            return super.showOpenDialog(parent);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public int showSaveDialog(Component parent) throws HeadlessException {
        this.prepareFilters();
        int result = super.showSaveDialog(parent);
        if (result == 0) {
            File selectedFile = super.getSelectedFile();
            FileFilter filter = this.getFileFilter();
            if (filter instanceof ExampleFileFilter) {
                ExampleFileFilter eff = (ExampleFileFilter)filter;
                this.setSelectedFile(eff.appendExtension(selectedFile));
            }
        }
        return result;
    }

    public static boolean isFilenameLegal(String filename) {
        return filename.lastIndexOf(58) < 2 && filename.indexOf(42) < 0 && filename.indexOf(63) < 0 && filename.indexOf(34) < 0 && filename.indexOf(60) < 0 && filename.indexOf(62) < 0 && filename.indexOf(124) < 0;
    }
}

