/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import thunderheadeng.util.IPropertySet;

public class guiAction
extends AbstractAction {
    public static final String DISABLED_ICON = "guiAction.DISABLED_ICON";
    private final ActionListener d_listener;
    private BooleanSupplier d_updateEnabled = () -> true;

    public guiAction(String name) {
        this(name, (Icon)null);
    }

    public guiAction(String name, Icon icon) {
        this(name, icon, e -> {});
    }

    public guiAction(String name, ActionListener listener) {
        this(name, null, listener);
    }

    public guiAction(String name, Icon icon, ActionListener listener) {
        this.setName(name);
        this.setIcon(icon);
        this.d_listener = listener;
    }

    public void setEnabledUpdator(BooleanSupplier updator) {
        this.d_updateEnabled = updator;
        this.updateEnabled();
    }

    public void updateEnabled() {
        this.setEnabled(this.d_updateEnabled.getAsBoolean());
    }

    public <T> void set(IPropertySet.Prop<T> prop, T value) {
        if (Objects.equals(value, prop.defVal)) {
            value = null;
        }
        this.putValue(prop.key.toString(), value);
    }

    public <T> T get(IPropertySet.Prop<T> prop) {
        Object value = this.getValue(prop.key.toString());
        if (value == null) {
            return prop.defVal;
        }
        return (T)value;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.d_listener.actionPerformed(e);
    }

    public void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public void setDisabledIcon(Icon icon) {
        this.putValue(DISABLED_ICON, icon);
    }

    public Icon getDisabledIcon() {
        return (Icon)this.getValue(DISABLED_ICON);
    }

    public void setName(String name) {
        int ix;
        int n = ix = name != null ? name.indexOf(38) : -1;
        if (ix >= 0) {
            char c = name.charAt(ix + 1);
            name = name.replaceAll("&", "");
            char keyCode = Character.toUpperCase(c);
            this.putValue("MnemonicKey", keyCode);
        }
        this.putValue("Name", name);
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public void addAccelerator(KeyStroke keystroke) {
        KeyStroke[] accelerators = this.getAccelerators();
        String key = accelerators.length == 0 ? "AcceleratorKey" : "AcceleratorKey" + accelerators.length;
        this.putValue(key, keystroke);
    }

    public KeyStroke[] getAccelerators() {
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>();
        int m = 0;
        while (true) {
            Object val;
            String key = "AcceleratorKey";
            if (m > 0) {
                key = key + m;
            }
            if (!((val = this.getValue(key)) instanceof KeyStroke)) break;
            keyStrokes.add((KeyStroke)val);
            ++m;
        }
        return keyStrokes.toArray(new KeyStroke[keyStrokes.size()]);
    }

    public JMenuItem addToMenu(JMenu menu) {
        JMenuItem jmi = menu.add(this);
        jmi.setDisabledIcon(this.getDisabledIcon());
        KeyStroke[] accelerators = this.getAccelerators();
        for (int m = 1; m < accelerators.length; ++m) {
            jmi.getActionMap().put(this, this);
            jmi.getInputMap(2).put(accelerators[m], this);
        }
        return jmi;
    }
}

