/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.format;

import java.text.ParseException;
import java.util.Collections;
import java.util.Map;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.format.AFormat;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.ObservableProxy;

public class UnitDoubleFormat
extends AFormat<UnitDouble>
implements IObserver,
IObservable {
    private IUnitSrc d_unit;
    private final boolean d_formatWithUnit;
    private ObservableProxy d_observableHelper;

    public UnitDoubleFormat(IUnitSrc unit) {
        this(unit, true);
    }

    public UnitDoubleFormat(IUnitSrc compatibilityUnit, boolean displayOnlyCompabilityUnit) {
        this.d_unit = compatibilityUnit;
        this.d_unit.addObserver(this, true);
        this.d_formatWithUnit = displayOnlyCompabilityUnit;
        this.d_observableHelper = new ObservableProxy(this);
    }

    @Override
    public UnitDoubleFormat clone() {
        UnitDoubleFormat clone = (UnitDoubleFormat)super.clone();
        clone.resetObeservableHelper();
        clone.d_unit.addObserver(clone, true);
        return clone;
    }

    public UnitDoubleFormat newFormat(IUnitSrc compatibilityUnit) {
        return this.newFormat(compatibilityUnit, Collections.EMPTY_MAP);
    }

    public UnitDoubleFormat newFormat(IUnitSrc compatibilityUnit, Map<String, UnitDouble> aliases) {
        UnitDoubleFormat clone = this.clone();
        clone.clearAliases();
        for (Map.Entry<String, UnitDouble> entry : aliases.entrySet()) {
            clone.alias(entry.getValue(), entry.getKey());
        }
        clone.d_unit.deleteObserver(clone);
        clone.d_unit = compatibilityUnit;
        clone.d_unit.addObserver(clone, true);
        return clone;
    }

    @Override
    protected UnitDouble parse(String text) throws ParseException {
        Unit unit = this.d_unit.getUnit();
        return Global.parseUnitDouble(text, unit);
    }

    @Override
    protected String toString(UnitDouble val) {
        Unit displayUnit = this.d_formatWithUnit && this.d_unit != null ? this.d_unit.getUnit() : val.getUnit();
        return Global.format(val.getValue(displayUnit), displayUnit);
    }

    @Override
    public void update(IObservable o, Object arg) {
        this.d_observableHelper.setChanged(true);
    }

    @Override
    public void addObserver(IObserver observer, boolean weakRef) {
        this.d_observableHelper.addObserver(observer, weakRef);
    }

    @Override
    public void deleteObserver(IObserver observer) {
        this.d_observableHelper.deleteObserver(observer);
    }

    public void resetObeservableHelper() {
        this.d_observableHelper = new ObservableProxy(this);
    }

    public IUnitSrc getUnitType() {
        return this.d_unit;
    }

    public boolean getFormatWithUnit() {
        return this.d_formatWithUnit;
    }
}

