/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.format;

import java.text.ParseException;
import java.util.StringTokenizer;
import thunderheadeng.gui.format.AFormat;
import thunderheadeng.gui.format.FormatUtil;
import thunderheadeng.util.Global;

public class DoubleListFormat
extends AFormat<double[]> {
    private final int d_minLen;
    private final int d_maxLen;

    public DoubleListFormat() {
        this(0, Integer.MAX_VALUE);
    }

    public DoubleListFormat(int minLen, int maxLen) {
        this.d_minLen = minLen;
        this.d_maxLen = maxLen;
    }

    @Override
    protected double[] parse(String text) throws ParseException {
        char coordSep = DoubleListFormat.getCoordSeparator();
        StringTokenizer tok = new StringTokenizer(text, coordSep + " ");
        double[] vals = new double[tok.countTokens()];
        int ix = 0;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken().trim();
            vals[ix++] = Global.parseDouble(token);
        }
        if (vals.length < this.d_minLen || vals.length > this.d_maxLen) {
            String msg = FormatUtil.formatLengthMessage(this.d_minLen, this.d_maxLen);
            throw new ParseException(msg, 0);
        }
        return vals;
    }

    @Override
    protected String toString(double[] vals) {
        char coordSep = DoubleListFormat.getCoordSeparator();
        StringBuffer buffer = new StringBuffer();
        for (int m = 0; m < vals.length; ++m) {
            if (m != 0) {
                buffer.append(coordSep + " ");
            }
            buffer.append(Global.format(vals[m]));
        }
        return buffer.toString();
    }

    private static char getCoordSeparator() {
        char decSep = FormatUtil.getDecimalSeparator();
        return decSep == ',' ? (char)';' : ',';
    }
}

