/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.colorscheme;

import java.awt.Color;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.theUtil;

public class ColorScheme
implements Cloneable {
    private String d_name;
    private Map<String, Color> d_colors;
    public static final String SEPARATOR = ".";

    public ColorScheme(String name) {
        this.d_name = name;
        this.d_colors = new LinkedHashMap<String, Color>();
    }

    public Object clone(String name) {
        try {
            ColorScheme cs = (ColorScheme)super.clone();
            cs.d_name = name;
            return cs;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getName() {
        return this.d_name;
    }

    public String toString() {
        return "ColorScheme: " + this.getName() + " (" + this.d_colors.size() + " colors)";
    }

    public Color getColor(IPropertySet.Prop<Color> colorName) {
        return this.d_colors.getOrDefault(colorName.key.toString(), (Color)colorName.defVal);
    }

    public void setColor(IPropertySet.Prop<Color> colorName, Color value) {
        this.d_colors.put(colorName.key.toString(), value);
    }

    public String[] getColorNames() {
        return theUtil.toArray(this.d_colors.keySet(), String.class);
    }

    public void load(Properties props, String prefix) {
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(prefix)) continue;
            String colorName = key.substring(prefix.length());
            try {
                Color color = Color.decode((String)props.get(key));
                this.d_colors.put(colorName, color);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void store(Properties props, String prefix) {
        for (Map.Entry<String, Color> entry : this.d_colors.entrySet()) {
            String colorName = entry.getKey();
            Color color = entry.getValue();
            props.setProperty(prefix + this.d_name + SEPARATOR + colorName, this.encodeColor(color));
        }
    }

    private String encodeColor(Color c) {
        int val = (c.getRed() << 16) + (c.getGreen() << 8) + c.getBlue();
        return "0x" + Integer.toHexString(val);
    }
}

