/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.animate;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import thunderheadeng.Intl;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IListenerStripper;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.animate.IAnimView;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.BitOptions;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.theUtil;

public class TimeView
implements IAnimView,
IEventObserver {
    public static final int OPT_REVERSE = 1;
    public static final int OPT_LOOP = 2;
    private final Mediator d_mediator;
    private final IAnimSession d_session;
    private final BitOptions d_options;
    private final guiPanel d_panel;
    private final JSlider d_timeSlider;
    private final JButton d_playPauseBtn;
    private final JButton d_stopBtn;
    private final JButton d_gotoStartBtn;
    private final JButton d_gotoEndBtn;
    private final JButton d_incSpeedBtn;
    private final JButton d_decSpeedBtn;
    private final guiCheckBox d_reverse;
    private final guiCheckBox d_loop;
    private Timer d_sliderTimer;

    public TimeView(Mediator mediator, IAnimSession session, int options) {
        this(mediator, session, options, null);
    }

    public TimeView(Mediator mediator, IAnimSession session, int options, Component additionalControls) {
        this.d_options = new BitOptions(options);
        this.d_mediator = mediator;
        this.d_session = session;
        this.d_panel = new guiPanel();
        this.d_playPauseBtn = TimeView.newMediaBtn(Intl.intl("Play"), "Play1", e -> {
            IAnimSession.State state = this.d_session.get(IAnimSession.STATE);
            switch (state) {
                case PAUSED: {
                    this.d_session.set(IAnimSession.STATE, IAnimSession.State.PLAYING);
                    break;
                }
                case PLAYING: {
                    this.d_session.set(IAnimSession.STATE, IAnimSession.State.PAUSED);
                }
            }
        });
        this.d_stopBtn = TimeView.newMediaBtn(Intl.intl("Stop"), "Stop1", e -> {
            this.d_session.set(IAnimSession.STATE, IAnimSession.State.PAUSED);
            this.d_session.set(IAnimSession.TIME, this.d_session.get(IAnimSession.TIME_RANGE)[0]);
        });
        this.d_gotoStartBtn = TimeView.newMediaBtn(Intl.intl("Move to Beginning"), "SkipBack", e -> this.d_session.set(IAnimSession.TIME, this.d_session.get(IAnimSession.TIME_RANGE)[0]));
        this.d_gotoEndBtn = TimeView.newMediaBtn(Intl.intl("Move to End"), "SkipForward", e -> this.d_session.set(IAnimSession.TIME, this.d_session.get(IAnimSession.TIME_RANGE)[1]));
        this.d_incSpeedBtn = TimeView.newMediaBtn(Intl.intl("Increase Speed"), "ScanForward", e -> this.scaleTime(2.0));
        this.d_decSpeedBtn = TimeView.newMediaBtn(Intl.intl("Decrease Speed"), "ScanBack", e -> this.scaleTime(0.5));
        this.d_reverse = new guiCheckBox(Intl.intl("Reverse"));
        this.d_reverse.addItemListener(e -> this.d_session.set(IAnimSession.TIME_SCALE, -1.0 * this.d_session.get(IAnimSession.TIME_SCALE)));
        this.d_loop = new guiCheckBox(Intl.intl("Loop"));
        this.d_loop.addItemListener(e -> this.d_session.set(IAnimSession.TIME_LOOP, this.d_loop.isSelected()));
        this.d_timeSlider = new JSlider();
        this.d_timeSlider.setMaximum(2000);
        this.d_timeSlider.setFocusable(false);
        this.d_timeSlider.addChangeListener(new SliderListener());
        this.d_timeSlider.setMajorTickSpacing(0);
        this.d_timeSlider.setMinorTickSpacing(0);
        this.d_timeSlider.setPaintTicks(true);
        guiPanel playStopPnl = new guiPanel();
        GridBagHelper gb = new GridBagHelper(playStopPnl);
        gb.d_colSpace = 3;
        ArrayList<Serializable> rowOpts = new ArrayList<Serializable>();
        rowOpts.addAll(Arrays.asList(this.d_playPauseBtn, this.d_stopBtn, Box.createHorizontalStrut(3), this.d_gotoStartBtn, this.d_decSpeedBtn, this.d_incSpeedBtn, this.d_gotoEndBtn));
        if (this.d_options.get(2L) && this.d_options.get(1L)) {
            rowOpts.add(Box.createHorizontalStrut(3));
            guiPanel cbPnl = new guiPanel();
            GridBagHelper gb2 = new GridBagHelper(cbPnl);
            gb2.d_rowSpace = 0;
            gb2.addRow(this.d_reverse);
            gb2.addRow(this.d_loop);
            gb2.finalizeRows();
            rowOpts.add(cbPnl);
        } else if (this.d_options.get(1L)) {
            rowOpts.add(Box.createHorizontalStrut(3));
            rowOpts.add(this.d_reverse);
        } else if (this.d_options.get(2L)) {
            rowOpts.add(Box.createHorizontalStrut(3));
            rowOpts.add(this.d_loop);
        }
        if (additionalControls != null) {
            rowOpts.add(Box.createHorizontalStrut(3));
            rowOpts.add(additionalControls);
        }
        rowOpts.add(Integer.valueOf(0));
        gb.addRow(theUtil.toArray(rowOpts, Object.class));
        gb = new GridBagHelper(this.d_panel, false);
        this.d_panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        gb.d_rowSpace = 4;
        gb.addRow(new Object[]{this.d_timeSlider, GridBagHelper.Anchor.CENTER, 0, 1.0});
        gb.addRow(new Object[]{playStopPnl, GridBagHelper.Anchor.CENTER, 0});
        this.sync();
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }

    @Override
    public void connect() {
        if (this.d_sliderTimer != null) {
            return;
        }
        this.d_mediator.getEvents().addObserver(this);
        this.d_sliderTimer = new Timer(16, e -> this.syncTime());
        this.d_sliderTimer.start();
    }

    @Override
    public void disconnect() {
        if (this.d_sliderTimer == null) {
            return;
        }
        this.d_sliderTimer.stop();
        this.d_sliderTimer = null;
        this.d_mediator.getEvents().removeObserver(this);
    }

    private void scaleTime(double mult) {
        double newScale = this.d_session.get(IAnimSession.TIME_SCALE) * mult;
        this.d_session.set(IAnimSession.TIME_SCALE, newScale);
    }

    private static JButton newMediaBtn(String tooltip, String icon, ActionListener action) {
        return guiUtil.newMediaBtn(tooltip, "media/" + icon, action);
    }

    private static void setMediaIcons(JButton button, String icon) {
        guiUtil.setMediaIcons(button, "media/" + icon);
    }

    @Override
    public guiPanel getViewUI() {
        return this.d_panel;
    }

    @Override
    public void update(Events events) {
        IEventRecord<IAnimSession> evts = events.getEvents(IAnimSession.class, new Class[0]);
        if (evts.isChanged(this.d_session, IAnimSession.STATE)) {
            this.syncState();
        }
        if (evts.isChanged(this.d_session, IAnimSession.TIME_SCALE)) {
            this.syncSpeed();
        }
        if (evts.isChanged(this.d_session, IAnimSession.TIME_LOOP)) {
            this.syncLoop();
        }
    }

    public void sync() {
        this.syncState();
        this.syncLoop();
        this.syncSpeed();
        this.syncTime();
    }

    private void syncState() {
        IAnimSession.State state = this.d_session.get(IAnimSession.STATE);
        switch (state) {
            case PAUSED: {
                this.d_playPauseBtn.setToolTipText(Intl.intl("Play"));
                TimeView.setMediaIcons(this.d_playPauseBtn, "Play1");
                break;
            }
            default: {
                this.d_playPauseBtn.setToolTipText(Intl.intl("Pause"));
                TimeView.setMediaIcons(this.d_playPauseBtn, "Pause");
            }
        }
    }

    private void syncSpeed() {
        double scale = this.d_session.get(IAnimSession.TIME_SCALE);
        IListenerStripper listeners = guiUtil.stripListeners(this.d_reverse);
        this.d_reverse.setSelected(scale < 0.0);
        listeners.restore();
    }

    private void syncLoop() {
        boolean loop = this.d_session.get(IAnimSession.TIME_LOOP);
        IListenerStripper listeners = guiUtil.stripListeners(this.d_loop);
        this.d_loop.setSelected(loop);
        listeners.restore();
    }

    private void syncTime() {
        double[] trange;
        double t = this.d_session.get(IAnimSession.TIME);
        this.d_stopBtn.setEnabled(t > (trange = this.d_session.get(IAnimSession.TIME_RANGE))[0]);
        double tRange = trange[1] - trange[0];
        int sliderPos = (int)(t / tRange * (double)this.d_timeSlider.getMaximum());
        IListenerStripper listeners = guiUtil.stripListeners(this.d_timeSlider::addChangeListener, this.d_timeSlider::getChangeListeners, this.d_timeSlider::removeChangeListener);
        this.d_timeSlider.setValue(sliderPos);
        listeners.restore();
    }

    private class SliderListener
    implements ChangeListener {
        private boolean d_slidingTime = false;
        private IAnimSession.State d_stateBeforeSliding = IAnimSession.State.PAUSED;

        private SliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.d_slidingTime != TimeView.this.d_timeSlider.getValueIsAdjusting()) {
                this.d_slidingTime = TimeView.this.d_timeSlider.getValueIsAdjusting();
                if (this.d_slidingTime) {
                    this.d_stateBeforeSliding = TimeView.this.d_session.get(IAnimSession.STATE);
                    TimeView.this.d_session.set(IAnimSession.STATE, IAnimSession.State.PAUSED);
                } else {
                    TimeView.this.d_session.set(IAnimSession.STATE, this.d_stateBeforeSliding);
                }
            }
            double t = (double)TimeView.this.d_timeSlider.getValue() / (double)TimeView.this.d_timeSlider.getMaximum();
            double[] range = TimeView.this.d_session.get(IAnimSession.TIME_RANGE);
            double time = range[0] + (range[1] - range[0]) * t;
            TimeView.this.d_session.set(IAnimSession.TIME, time);
        }
    }
}

