/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.animate;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.Timer;
import thunderheadeng.Intl;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.animate.IAnimView;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiStatusBar;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;

public class StatusView
implements IAnimView,
IEventObserver {
    private final Mediator d_mediator;
    private final IAnimSession d_session;
    private final BarInfo d_barInfo;
    private Timer d_fpsTimer;
    private Timer d_timeTimer;
    private double d_lastFPS = Double.NEGATIVE_INFINITY;
    private double d_lastTime = Double.NEGATIVE_INFINITY;
    private double[] d_lastTimeRange = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};

    public StatusView(Mediator mediator, IAnimSession session) {
        this(mediator, session, new BarInfo());
    }

    public StatusView(Mediator mediator, IAnimSession session, BarInfo barInfo) {
        this.d_mediator = mediator;
        this.d_session = session;
        this.d_barInfo = barInfo;
        this.sync();
    }

    public BarInfo getBarInfo() {
        return this.d_barInfo;
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }

    @Override
    public void connect() {
        if (this.d_fpsTimer != null) {
            return;
        }
        this.d_mediator.getEvents().addObserver(this);
        this.d_fpsTimer = new Timer(1000, e -> this.syncFPS());
        this.d_fpsTimer.start();
        this.d_timeTimer = new Timer(16, e -> this.syncTime());
        this.d_timeTimer.start();
    }

    @Override
    public void disconnect() {
        if (this.d_fpsTimer == null) {
            return;
        }
        this.d_timeTimer.stop();
        this.d_fpsTimer.stop();
        this.d_fpsTimer = null;
        this.d_mediator.getEvents().removeObserver(this);
    }

    @Override
    public Component getViewUI() {
        return this.d_barInfo.bar;
    }

    public void sync() {
        this.syncFPS();
        this.syncSpeed();
        this.syncTime();
        this.syncState();
    }

    private static String formatFPS(double fps) {
        return String.format(Intl.intl("Framerate: %.1f fps"), fps);
    }

    private static String formatTime(double time) {
        int seconds = (int)Math.floor(time);
        int minutes = seconds / 60;
        return String.format(Intl.intl("%d:%02d"), minutes, seconds %= 60);
    }

    private static String formatSpeed(double speed) {
        String speedStr = "";
        if (speed < 0.0) {
            speedStr = speedStr + "-";
        }
        if ((speed = Math.abs(speed)) < 1.0) {
            speedStr = speedStr + "1/";
            speed = 1.0 / speed;
        }
        long val = Math.round(speed);
        speedStr = speedStr + val + " X";
        return speedStr;
    }

    private static String formatSpeedMsg(double scale) {
        String speedStr = StatusView.formatSpeed(scale);
        return String.format(Intl.intl("Speed: %s"), speedStr);
    }

    private static String formatTime(double time, double maxTime) {
        return String.format(Intl.intl("Time: %s / %s"), StatusView.formatTime(time), StatusView.formatTime(maxTime));
    }

    private static int getDesiredWidth(guiStatusBar field, int ix, String s) {
        guiLabel pane = (guiLabel)field.getPane(ix);
        String oldText = pane.getText();
        pane.setText(s);
        pane.setPreferredSize(null);
        Dimension preferredSize = pane.getPreferredSize();
        pane.setText(oldText);
        return preferredSize.width;
    }

    private static void setWidth(guiStatusBar field, int ix, int width) {
        JComponent comp = field.getPane(ix);
        comp.setPreferredSize(new Dimension(width, comp.getPreferredSize().height));
    }

    private void syncSpeed() {
        guiStatusBar bar = this.d_barInfo.bar;
        int speedIx = this.d_barInfo.speedIx;
        int speedSize = Math.max(StatusView.getDesiredWidth(bar, speedIx, StatusView.formatSpeedMsg(128.0)), StatusView.getDesiredWidth(bar, speedIx, StatusView.formatSpeedMsg(0.03125)));
        StatusView.setWidth(bar, speedIx, speedSize);
        double speed = this.d_session.get(IAnimSession.TIME_SCALE);
        bar.setMessage(speedIx, StatusView.formatSpeedMsg(speed));
    }

    private void syncFPS() {
        double fps = this.d_session.getFPS();
        if (fps != this.d_lastFPS) {
            guiStatusBar bar = this.d_barInfo.bar;
            int fpsIx = this.d_barInfo.fpsIx;
            int width = StatusView.getDesiredWidth(bar, fpsIx, StatusView.formatFPS(9999.900390625));
            StatusView.setWidth(bar, fpsIx, width);
            bar.setMessage(fpsIx, StatusView.formatFPS(fps));
            this.d_lastFPS = fps;
        }
    }

    private void syncTime() {
        double time = this.d_session.get(IAnimSession.TIME);
        double[] trange = this.d_session.get(IAnimSession.TIME_RANGE);
        double maxTime = trange[1];
        if (time != this.d_lastTime || maxTime != this.d_lastTimeRange[1]) {
            guiStatusBar bar = this.d_barInfo.bar;
            int timeIx = this.d_barInfo.timeIx;
            int width = StatusView.getDesiredWidth(bar, timeIx, StatusView.formatTime(time, 0.0));
            StatusView.setWidth(bar, timeIx, width);
            bar.setMessage(timeIx, StatusView.formatTime(time, maxTime));
            this.d_lastTime = time;
            this.d_lastTimeRange = trange;
        }
    }

    private void syncState() {
        IAnimSession.State state = this.d_session.get(IAnimSession.STATE);
        double t = this.d_session.get(IAnimSession.TIME);
        double[] trange = this.d_session.get(IAnimSession.TIME_RANGE);
        String statusTxt = state == IAnimSession.State.PAUSED && t == trange[0] ? Intl.intl("Stopped") : (state == IAnimSession.State.PAUSED ? Intl.intl("Paused") : Intl.intl("Playing"));
        this.d_barInfo.bar.setMessage(this.d_barInfo.statusIx, statusTxt);
    }

    @Override
    public void update(Events events) {
        IEventRecord<IAnimSession> records = events.getEvents(IAnimSession.class, new Class[0]);
        if (records.isChanged(this.d_session, IAnimSession.TIME_SCALE)) {
            this.syncSpeed();
        }
        if (records.isChanged(this.d_session, IAnimSession.STATE)) {
            this.syncState();
        }
    }

    public static class BarInfo {
        public final guiStatusBar bar;
        public final int statusIx;
        public final int timeIx;
        public final int speedIx;
        public final int fpsIx;

        public BarInfo() {
            this.bar = new guiStatusBar();
            this.statusIx = 0;
            this.timeIx = this.bar.addPane(new guiLabel(), 0.0);
            this.speedIx = this.bar.addPane(new guiLabel(), 0.0);
            this.fpsIx = this.bar.addPane(new guiLabel(), 0.0);
        }

        public BarInfo(guiStatusBar bar, int statusIx, int timeIx, int speedIx, int fpsIx) {
            this.bar = bar;
            this.statusIx = statusIx;
            this.timeIx = timeIx;
            this.speedIx = speedIx;
            this.fpsIx = fpsIx;
        }
    }
}

