/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.text.Format;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.format.DoubleFormat;
import thunderheadeng.gui.format.IValueFormat;
import thunderheadeng.gui.format.IntFormat;
import thunderheadeng.gui.format.LongFormat;
import thunderheadeng.gui.format.UnitDoubleFormat;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.units.ConstantUnitSrc;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.ValueRange;

public class ValueFields {
    public static <T> ValueField<T> fld(Class<T> type) throws IllegalArgumentException {
        return new ValueField<T>(ValueFields.getFormat(type), ValueFields.getInitVal(type));
    }

    public static <T> ValueField<T> fld(T initValue) throws NullPointerException, IllegalArgumentException {
        return new ValueField<T>(ValueFields.getFormat(initValue.getClass()), initValue);
    }

    public static <T> ValueField<T> fld(T defValue, Predicate<T> filter, Class<T> type) throws IllegalArgumentException {
        return new ValueField<T>(new guiFormattedFld.Formatter<T>(ValueFields.getFormat(type), filter), defValue);
    }

    public static <T> ValueField<T> fld(ValueRange<T> range, Class<T> type) throws IllegalArgumentException {
        T initVal = range.clampValue(ValueFields.getInitVal(type));
        return new ValueField<T>(new guiFormattedFld.Formatter<T>(ValueFields.getFormat(type), range), initVal);
    }

    public static <T> ValueField<T> fld(T initValue, Predicate<T> filter) throws NullPointerException, IllegalArgumentException {
        return new ValueField<T>(new guiFormattedFld.Formatter<T>(ValueFields.getFormat(initValue.getClass()), filter), initValue);
    }

    public static <T> IValueFormat<T> getFormat(ValueField<T> field) {
        Format format = field.getFormat();
        if (format instanceof IValueFormat) {
            return (IValueFormat)((Object)format);
        }
        return null;
    }

    protected static <T> Format getFormat(Class<T> type) throws IllegalArgumentException {
        if (Double.class.isAssignableFrom(type)) {
            return new DoubleFormat();
        }
        if (Integer.class.isAssignableFrom(type)) {
            return new IntFormat();
        }
        if (Long.class.isAssignableFrom(type)) {
            return new LongFormat();
        }
        throw new IllegalArgumentException();
    }

    protected static <T> T getInitVal(Class<T> type) throws IllegalArgumentException {
        if (type.equals(Long.class)) {
            return (T)Long.valueOf(0L);
        }
        if (type.equals(Double.class)) {
            return (T)Double.valueOf(0.0);
        }
        if (type.equals(Integer.class)) {
            return (T)Integer.valueOf(0);
        }
        throw new IllegalArgumentException();
    }

    public static ValueField<Double> doubleFld() {
        return ValueFields.doubleFld(0.0);
    }

    public static ValueField<Double> doubleFld(Double initValue) {
        return new ValueField<Double>(new DoubleFormat(), initValue);
    }

    public static ValueField<Double> doubleFld(DoubleVR range) {
        Double initVal = range.clampValue(0.0);
        return ValueFields.doubleFld(initVal, range);
    }

    public static ValueField<Double> doubleFld(Double initValue, Predicate<Double> filter) {
        return new ValueField<Double>(new guiFormattedFld.Formatter<Double>((Format)new DoubleFormat(), filter), initValue);
    }

    public static ValueField<Integer> intFld() {
        return ValueFields.intFld(0);
    }

    public static ValueField<Integer> intFld(Integer initValue) {
        return new ValueField<Integer>(new IntFormat(), initValue);
    }

    public static ValueField<Integer> intFld(IntVR range) {
        Integer initVal = range.clampValue(0);
        return ValueFields.intFld(initVal, range);
    }

    public static ValueField<Integer> intFld(Integer initValue, Predicate<Integer> filter) {
        return new ValueField<Integer>(new guiFormattedFld.Formatter<Integer>((Format)new IntFormat(), filter), initValue);
    }

    public static ValueField<UnitDouble> udFld(IUnitSrc u) {
        return ValueFields.udFld(new UnitDouble(0.0, u.getUnit()), u);
    }

    public static ValueField<UnitDouble> udFld(IUnitSrc u, UnitDoubleVR range) {
        return ValueFields.udFld(range.clampValue(new UnitDouble(0.0, u.getUnit())), range, u);
    }

    public static ValueField<UnitDouble> udFld(double value, Unit unit) {
        return new ValueField<UnitDouble>(new UnitDoubleFormat(new ConstantUnitSrc(unit)), new UnitDouble(value, unit));
    }

    public static ValueField<UnitDouble> udFld(UnitDouble value) {
        return new ValueField<UnitDouble>(new UnitDoubleFormat(new ConstantUnitSrc(value.getUnit())), value);
    }

    public static ValueField<UnitDouble> udFld(UnitDouble value, IUnitSrc displayUnit) {
        return new ValueField<UnitDouble>(new UnitDoubleFormat(displayUnit), value);
    }

    public static ValueField<UnitDouble> udFld(Unit u, DoubleVR range) {
        return ValueFields.udFld(range, u);
    }

    public static ValueField<UnitDouble> udFld(DoubleVR range, Unit u) {
        return ValueFields.udFld((double)range.clampValue(0.0), range, u);
    }

    public static ValueField<UnitDouble> udFld(double value, DoubleVR range, Unit unit) {
        return new ValueField<UnitDouble>(new guiFormattedFld.Formatter<UnitDouble>((Format)new UnitDoubleFormat(new ConstantUnitSrc(unit)), UnitDoubleVR.from(range, unit)), new UnitDouble(value, unit));
    }

    public static ValueField<UnitDouble> udFld(double value, Unit unit, IUnitSrc displayUnit) {
        return new ValueField<UnitDouble>(new UnitDoubleFormat(displayUnit), new UnitDouble(value, unit));
    }

    public static ValueField<UnitDouble> udFld(double value, DoubleVR range, Unit unit, IUnitSrc displayUnit) {
        return new ValueField<UnitDouble>(new guiFormattedFld.Formatter<UnitDouble>((Format)new UnitDoubleFormat(displayUnit), UnitDoubleVR.from(range, unit)), new UnitDouble(value, unit));
    }

    public static ValueField<UnitDouble> udFld(DoubleVR range, Unit unit, IUnitSrc displayUnit) {
        return ValueFields.udFld(range.clampValue(0.0), range, unit, displayUnit);
    }

    public static ValueField<UnitDouble> udFld(UnitDouble value, Predicate<UnitDouble> filter) {
        return new ValueField<UnitDouble>(new guiFormattedFld.Formatter<UnitDouble>((Format)new UnitDoubleFormat(new ConstantUnitSrc(value.getUnit())), filter), value);
    }

    public static ValueField<UnitDouble> udFld(UnitDouble value, Predicate<UnitDouble> filter, IUnitSrc displayUnit) {
        return new ValueField<UnitDouble>(new guiFormattedFld.Formatter<UnitDouble>((Format)new UnitDoubleFormat(displayUnit), filter), value);
    }

    public static IUnitSrc getUnitSource(ValueField<UnitDouble> field) {
        if (field.getFormat() instanceof UnitDoubleFormat) {
            return ((UnitDoubleFormat)field.getFormat()).getUnitType();
        }
        return null;
    }

    public static void setUnitSource(ValueField<UnitDouble> field, IUnitSrc src) {
        IUnitSrc currSrc = ValueFields.getUnitSource(field);
        if (currSrc == null || currSrc.equals(src)) {
            return;
        }
        Unit currUnit = currSrc.getUnit();
        Unit newUnit = src.getUnit();
        UnitDouble currVal = (UnitDouble)field.getValue();
        boolean compatible = UnitDouble.areCompatible(currUnit, newUnit);
        if (currVal != null && !compatible) {
            currVal = currVal.reinterpret(newUnit);
        }
        field.setValue(null);
        UnitDoubleFormat format = (UnitDoubleFormat)field.getFormat();
        Map<String, UnitDouble> aliases = compatible ? format.getAliases() : Collections.EMPTY_MAP;
        format = format.newFormat(src, aliases);
        if (field.getFormatter() instanceof guiFormattedFld.Formatter) {
            guiFormattedFld.Formatter formatter = (guiFormattedFld.Formatter)field.getFormatter();
            formatter = compatible ? formatter.newFormatter(format, formatter.getFilter()) : formatter.newFormatter(format);
            field.setFormatter(formatter);
        }
        field.setValue(currVal);
    }
}

